/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.locator.impl;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.testfx.service.locator.BoundsLocator;
import org.testfx.service.locator.PointLocator;
import org.testfx.service.query.PointQuery;
import org.testfx.service.query.impl.BoundsPointQuery;
import org.testfx.service.query.impl.CallableBoundsPointQuery;

public class PointLocatorImpl
implements PointLocator {
    private final BoundsLocator boundsLocator;

    public PointLocatorImpl(BoundsLocator boundsLocator) {
        this.boundsLocator = boundsLocator;
    }

    @Override
    public PointQuery point(Bounds bounds) {
        return new BoundsPointQuery(bounds);
    }

    @Override
    public PointQuery point(Point2D point) {
        return new BoundsPointQuery((Bounds)new BoundingBox(point.getX(), point.getY(), 0.0, 0.0));
    }

    @Override
    public PointQuery point(Node node) {
        return new CallableBoundsPointQuery(() -> this.boundsLocator.boundsOnScreenFor(node), node);
    }

    @Override
    public PointQuery point(Scene scene) {
        return new CallableBoundsPointQuery(() -> this.boundsLocator.boundsOnScreenFor(scene));
    }

    @Override
    public PointQuery point(Window window) {
        return new CallableBoundsPointQuery(() -> this.boundsLocator.boundsOnScreenFor(window));
    }
}

