/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.finder.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.hamcrest.Matcher;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.finder.WindowFinder;
import org.testfx.service.query.NodeQuery;
import org.testfx.service.query.impl.NodeQueryImpl;
import org.testfx.util.NodeQueryUtils;

public class NodeFinderImpl
implements NodeFinder {
    private final WindowFinder windowFinder;

    public NodeFinderImpl(WindowFinder windowFinder) {
        this.windowFinder = windowFinder;
    }

    @Override
    public NodeQuery lookup(String query) {
        return this.fromAll().lookup(query);
    }

    @Override
    public <T> NodeQuery lookup(Matcher<T> matcher) {
        return this.fromAll().lookup(matcher);
    }

    @Override
    public <T extends Node> NodeQuery lookup(Predicate<T> predicate) {
        return this.fromAll().lookup(predicate);
    }

    @Override
    public NodeQuery fromAll() {
        return new NodeQueryImpl().from(this.rootsOfWindows());
    }

    @Override
    public NodeQuery from(Node ... parentNodes) {
        return new NodeQueryImpl().from(parentNodes);
    }

    @Override
    public NodeQuery from(Collection<Node> parentNodes) {
        return new NodeQueryImpl().from(parentNodes);
    }

    @Override
    public NodeQuery from(NodeQuery nodeQuery) {
        return new NodeQueryImpl().from(nodeQuery.queryAll());
    }

    @Override
    public Node rootNode(Window window) {
        return window.getScene().getRoot();
    }

    @Override
    public Node rootNode(Scene scene) {
        return scene.getRoot();
    }

    @Override
    public Node rootNode(Node node) {
        return node.getScene().getRoot();
    }

    private Set<Node> rootsOfWindows() {
        List<Window> windows = this.windowFinder.listTargetWindows();
        return NodeQueryUtils.rootsOfWindows(windows);
    }
}

