/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.adapter.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import org.testfx.internal.JavaVersionAdapter;
import org.testfx.internal.PlatformAdapter;
import org.testfx.service.adapter.impl.GlassRobotAdapter;
import org.testfx.util.WaitForAsyncUtils;

class PrivateGlassRobotAdapter
extends GlassRobotAdapter {
    PrivateGlassRobotAdapter() {
    }

    @Override
    public void robotCreate() {
        try {
            Object application = Class.forName("com.sun.glass.ui.Application").getMethod("GetApplication", new Class[0]).invoke(null, new Object[0]);
            Method createRobotMethod = application.getClass().getDeclaredMethod("createRobot", new Class[0]);
            createRobotMethod.setAccessible(true);
            this.glassRobot = createRobotMethod.invoke(application, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void robotDestroy() {
        if (this.glassRobot != null) {
            WaitForAsyncUtils.waitForAsyncFx(10000L, () -> {
                try {
                    this.getRobot().getClass().getMethod("destroy", new Class[0]).invoke(this.glassRobot, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                this.glassRobot = null;
            });
        }
    }

    @Override
    public void keyPress(KeyCode key) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("keyPress", Integer.TYPE).invoke(this.getRobot(), JavaVersionAdapter.convertToKeyCodeId(key)));
    }

    @Override
    public void keyRelease(KeyCode key) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("keyRelease", Integer.TYPE).invoke(this.getRobot(), JavaVersionAdapter.convertToKeyCodeId(key)));
    }

    @Override
    public Point2D getMouseLocation() {
        if (PlatformAdapter.getOs() == PlatformAdapter.OS.UNIX && JavaVersionAdapter.currentVersion().isJava9Compatible()) {
            return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> new Point2D((double)((Integer)this.getRobot().getClass().getMethod("getMouseX", new Class[0]).invoke(this.getRobot(), new Object[0])).intValue() / JavaVersionAdapter.getScreenScaleX(), (double)((Integer)this.getRobot().getClass().getMethod("getMouseY", new Class[0]).invoke(this.getRobot(), new Object[0])).intValue() / JavaVersionAdapter.getScreenScaleY()));
        }
        return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> new Point2D((double)((Integer)this.getRobot().getClass().getMethod("getMouseX", new Class[0]).invoke(this.glassRobot, new Object[0])).intValue(), (double)((Integer)this.getRobot().getClass().getMethod("getMouseY", new Class[0]).invoke(this.glassRobot, new Object[0])).intValue()));
    }

    @Override
    public void mouseMove(Point2D location) {
        Rectangle2D scaled = new Rectangle2D(location.getX(), location.getY(), 0.0, 0.0);
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mouseMove", Integer.TYPE, Integer.TYPE).invoke(this.getRobot(), (int)scaled.getMinX(), (int)scaled.getMinY()));
    }

    @Override
    public void mousePress(MouseButton button) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mousePress", Integer.TYPE).invoke(this.getRobot(), this.convertToButtonId(button)));
    }

    @Override
    public void mouseRelease(MouseButton button) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mouseRelease", Integer.TYPE).invoke(this.getRobot(), this.convertToButtonId(button)));
    }

    @Override
    public Color getCapturePixelColor(Point2D location) {
        Rectangle2D scaled = new Rectangle2D(location.getX(), location.getY(), 0.0, 0.0);
        return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> {
            int glassColor = (Integer)this.getRobot().getClass().getMethod("getPixelColor", Integer.TYPE, Integer.TYPE).invoke(this.getRobot(), (int)scaled.getMinX(), (int)scaled.getMinY());
            return this.convertFromGlassColor(glassColor);
        });
    }

    @Override
    protected Image getScreenCapture(Rectangle2D region, boolean raw) {
        return WaitForAsyncUtils.waitForAsyncFx(10000L, () -> this.convertFromGlassPixels(this.getRobot().getClass().getMethod("getScreenCapture", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE).invoke(this.glassRobot, (int)region.getMinX(), (int)region.getMinY(), (int)region.getWidth(), (int)region.getHeight(), raw)));
    }

    private int convertToButtonId(MouseButton button) {
        try {
            switch (button) {
                case PRIMARY: {
                    return this.getRobot().getClass().getField("MOUSE_LEFT_BTN").getInt(null);
                }
                case SECONDARY: {
                    return this.getRobot().getClass().getField("MOUSE_RIGHT_BTN").getInt(null);
                }
                case MIDDLE: {
                    return this.getRobot().getClass().getField("MOUSE_MIDDLE_BTN").getInt(null);
                }
            }
            throw new IllegalArgumentException("MouseButton: " + button + " not supported by GlassRobot");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("MouseButton: " + button + " not supported by GlassRobot");
        }
    }

    private Color convertFromGlassColor(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Color((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, (double)alpha / 255.0);
    }

    private Image convertFromGlassPixels(Object glassPixels) {
        try {
            int width = (Integer)glassPixels.getClass().getMethod("getWidth", new Class[0]).invoke(glassPixels, new Object[0]);
            int height = (Integer)glassPixels.getClass().getMethod("getHeight", new Class[0]).invoke(glassPixels, new Object[0]);
            WritableImage image = new WritableImage(width, height);
            IntBuffer intBuffer = (IntBuffer)glassPixels.getClass().getMethod("getPixels", new Class[0]).invoke(glassPixels, new Object[0]);
            this.writeIntBufferToImage(intBuffer, image);
            return image;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeIntBufferToImage(IntBuffer intBuffer, WritableImage image) {
        PixelWriter pixelWriter = image.getPixelWriter();
        double width = image.getWidth();
        double height = image.getHeight();
        int y = 0;
        while ((double)y < height) {
            int x = 0;
            while ((double)x < width) {
                int argb = intBuffer.get();
                pixelWriter.setArgb(x, y, argb);
                ++x;
            }
            ++y;
        }
    }
}

