/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.adapter.impl;

import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.testfx.service.adapter.RobotAdapter;
import org.testfx.util.WaitForAsyncUtils;

public class JavafxRobotAdapter
implements RobotAdapter<JavafxRobotAdapter> {
    private Scene scene;
    private boolean isShiftDown;
    private boolean isControlDown;
    private boolean isAltDown;
    private boolean isMetaDown;
    private MouseButton lastButtonPressed;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;
    private double sceneMouseX;
    private double sceneMouseY;
    private double screenMouseX;
    private double screenMouseY;

    public void robotCreate(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void robotCreate() {
    }

    @Override
    public void robotDestroy() {
    }

    @Override
    public void keyPress(KeyCode key) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createKeyEvent((EventType<KeyEvent>)KeyEvent.KEY_PRESSED, key, "")));
    }

    @Override
    public void keyRelease(KeyCode key) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createKeyEvent((EventType<KeyEvent>)KeyEvent.KEY_RELEASED, key, "")));
    }

    public void keyType(KeyCode key, String character) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createKeyEvent((EventType<KeyEvent>)KeyEvent.KEY_TYPED, key, character)));
    }

    @Override
    public Point2D getMouseLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mouseMove(Point2D location) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createMouseEvent((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED, (int)location.getX(), (int)location.getY(), this.lastButtonPressed, 0)));
    }

    public void mousePress(MouseButton button, int clickCount) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createMouseEvent((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, this.sceneMouseX, this.sceneMouseY, button, clickCount)));
    }

    public void mouseRelease(MouseButton button, int clickCount) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createMouseEvent((EventType<MouseEvent>)MouseEvent.MOUSE_RELEASED, this.sceneMouseX, this.sceneMouseY, button, clickCount)));
    }

    public void mouseClick(MouseButton button, int clickCount) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createMouseEvent((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, this.sceneMouseX, this.sceneMouseY, button, clickCount)));
    }

    @Override
    public void mousePress(MouseButton button) {
        this.mousePress(button, 1);
    }

    @Override
    public void mouseRelease(MouseButton button) {
        this.mouseRelease(button, 1);
    }

    public void mouseClick(MouseButton button) {
        this.mouseClick(button, 1);
    }

    public void mouseDrag(MouseButton button) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createMouseEvent((EventType<MouseEvent>)MouseEvent.MOUSE_DRAGGED, this.sceneMouseX, this.sceneMouseY, button, 0)));
    }

    @Override
    public void mouseWheel(int wheelAmount) {
        WaitForAsyncUtils.asyncFx(() -> Event.fireEvent((EventTarget)this.getEventTarget(this.scene), (Event)this.createScrollEvent(wheelAmount)));
    }

    @Override
    public Color getCapturePixelColor(Point2D location) {
        if (!Platform.isFxApplicationThread()) {
            throw new RuntimeException("JavafxRobotAdapter#getCapturePixelColor(..) must be called on JavaFX application thread but was: " + Thread.currentThread());
        }
        WritableImage snapshot = this.scene.snapshot(null);
        return snapshot.getPixelReader().getColor((int)location.getX(), (int)location.getY());
    }

    @Override
    public Image getCaptureRegion(Rectangle2D region) {
        if (!Platform.isFxApplicationThread()) {
            throw new RuntimeException("JavafxRobotAdapter#getCaptureRegion(..) must be called on JavaFX application thread but was: " + Thread.currentThread());
        }
        ImageView imageView = new ImageView((Image)this.scene.snapshot(null));
        imageView.setViewport(region);
        new Scene((Parent)new Pane(new Node[]{imageView}));
        return imageView.snapshot(null, null);
    }

    private EventTarget getEventTarget(Scene scene) {
        return scene.getFocusOwner() != null ? scene.getFocusOwner() : scene;
    }

    private KeyEvent createKeyEvent(EventType<KeyEvent> eventType, KeyCode keyCode, String character) {
        boolean pressed;
        boolean bl = pressed = eventType == KeyEvent.KEY_PRESSED;
        if (keyCode == KeyCode.SHIFT) {
            this.isShiftDown = pressed;
        }
        if (keyCode == KeyCode.CONTROL) {
            this.isControlDown = pressed;
        }
        if (keyCode == KeyCode.ALT) {
            this.isAltDown = pressed;
        }
        if (keyCode == KeyCode.META) {
            this.isMetaDown = pressed;
        }
        boolean typed = eventType == KeyEvent.KEY_TYPED;
        String keyChar = typed ? character : KeyEvent.CHAR_UNDEFINED;
        String keyText = typed ? "" : keyCode.getName();
        return new KeyEvent(eventType, keyChar, keyText, keyCode, this.isShiftDown, this.isControlDown, this.isAltDown, this.isMetaDown);
    }

    private MouseEvent createMouseEvent(EventType<MouseEvent> eventType, double x, double y, MouseButton mouseButton, int clickCount) {
        this.screenMouseX = this.scene.getWindow().getX() + this.scene.getX() + x;
        this.screenMouseY = this.scene.getWindow().getY() + this.scene.getY() + y;
        this.sceneMouseX = x;
        this.sceneMouseY = y;
        MouseButton button = mouseButton;
        EventType type = eventType;
        if (type == MouseEvent.MOUSE_PRESSED || type == MouseEvent.MOUSE_RELEASED) {
            boolean pressed = type == MouseEvent.MOUSE_PRESSED;
            switch (button) {
                case PRIMARY: {
                    this.isButton1Pressed = pressed;
                    break;
                }
                case MIDDLE: {
                    this.isButton2Pressed = pressed;
                    break;
                }
                case SECONDARY: {
                    this.isButton3Pressed = pressed;
                }
            }
            if (pressed) {
                this.lastButtonPressed = button;
            } else if (!(this.isButton1Pressed || this.isButton2Pressed || this.isButton3Pressed)) {
                this.lastButtonPressed = MouseButton.NONE;
            }
        } else if (type == MouseEvent.MOUSE_MOVED) {
            boolean someButtonPressed;
            boolean bl = someButtonPressed = this.isButton1Pressed || this.isButton2Pressed || this.isButton3Pressed;
            if (someButtonPressed) {
                type = MouseEvent.MOUSE_DRAGGED;
                button = MouseButton.NONE;
            }
        }
        return new MouseEvent(type, (double)((int)this.sceneMouseX), (double)((int)this.sceneMouseY), (double)((int)this.screenMouseX), (double)((int)this.screenMouseY), button, clickCount, this.isShiftDown, this.isControlDown, this.isAltDown, this.isMetaDown, this.isButton1Pressed, this.isButton2Pressed, this.isButton3Pressed, false, button == MouseButton.SECONDARY, false, null);
    }

    private ScrollEvent createScrollEvent(int wheelAmount) {
        this.screenMouseX = this.scene.getWindow().getX() + this.scene.getX() + this.sceneMouseX;
        this.screenMouseY = this.scene.getWindow().getY() + this.scene.getY() + this.sceneMouseY;
        return new ScrollEvent(ScrollEvent.SCROLL, (double)((int)this.sceneMouseX), (double)((int)this.sceneMouseY), (double)((int)this.screenMouseX), (double)((int)this.screenMouseY), this.isShiftDown, this.isControlDown, this.isAltDown, this.isMetaDown, false, false, 0.0, (double)(wheelAmount * 40), 0.0, 0.0, ScrollEvent.HorizontalTextScrollUnits.NONE, 0.0, ScrollEvent.VerticalTextScrollUnits.NONE, 0.0, 0, null);
    }
}

