/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.control;

import java.util.Objects;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;

public class TextMatchers {
    private TextMatchers() {
    }

    @Factory
    public static Matcher<Text> hasText(String text) {
        String descriptionText = "has text \"" + text + "\"";
        return GeneralMatchers.typeSafeMatcher(Text.class, descriptionText, textNode -> textNode.getClass().getSimpleName() + " with text: \"" + textNode.getText() + "\"", textNode -> Objects.equals(text, textNode.getText()));
    }

    @Factory
    public static Matcher<Text> hasText(Matcher<String> matcher) {
        String descriptionText = "has " + matcher.toString();
        return GeneralMatchers.typeSafeMatcher(Text.class, descriptionText, text -> text.getClass().getSimpleName() + " with text: \"" + text.getText() + "\"", textNode -> matcher.matches((Object)textNode.getText()));
    }

    @Factory
    public static Matcher<Text> hasFont(Font font) {
        String descriptionText = "has font " + TextMatchers.toText(font);
        return GeneralMatchers.typeSafeMatcher(Text.class, descriptionText, textNode -> textNode.getClass().getSimpleName() + " with font: " + TextMatchers.toText(textNode.getFont()), textNode -> Objects.equals(font, textNode.getFont()));
    }

    @Factory
    public static Matcher<Text> hasFontSmoothingType(FontSmoothingType smoothingType) {
        String descriptionText = "has font smoothing type: \"" + smoothingType + "\"";
        return GeneralMatchers.typeSafeMatcher(Text.class, descriptionText, textNode -> textNode.getClass().getSimpleName() + " with font smoothing type: \"" + textNode.getFontSmoothingType() + "\"", textNode -> Objects.equals(smoothingType, textNode.getFontSmoothingType()));
    }

    @Factory
    public static Matcher<Text> hasStrikethrough(boolean strikethrough) {
        String descriptionText = (strikethrough ? "has " : "does not have ") + "strikethrough";
        return GeneralMatchers.typeSafeMatcher(Text.class, descriptionText, textNode -> textNode.getClass().getSimpleName() + (textNode.isStrikethrough() ? " with " : " without ") + "strikethrough", textNode -> textNode.isStrikethrough() == strikethrough);
    }

    @Factory
    public static Matcher<Text> isUnderlined(boolean underlined) {
        String descriptionText = (underlined ? "is " : "is not ") + "underlined";
        return GeneralMatchers.typeSafeMatcher(Text.class, descriptionText, textNode -> textNode.getClass().getSimpleName() + (textNode.isUnderline() ? " with " : " without ") + "underline", textNode -> textNode.isUnderline() == underlined);
    }

    private static String toText(Font font) {
        return String.format("\"%s\" with family (\"%s\") and size (%.1f)", font.getName(), font.getFamily(), font.getSize());
    }
}

