/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.control;

import java.util.Objects;
import javafx.scene.control.TextInputControl;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;

public class TextInputControlMatchers {
    private TextInputControlMatchers() {
    }

    @Factory
    public static Matcher<TextInputControl> hasText(String text) {
        String descriptionText = "has text \"" + text + "\"";
        return GeneralMatchers.typeSafeMatcher(TextInputControl.class, descriptionText, textInputControl -> textInputControl.getClass().getSimpleName() + " with text: \"" + textInputControl.getText() + "\"", textInputControl -> Objects.equals(text, textInputControl.getText()));
    }

    @Factory
    public static Matcher<TextInputControl> hasText(Matcher<String> matcher) {
        String descriptionText = "has " + matcher.toString();
        return GeneralMatchers.typeSafeMatcher(TextInputControl.class, descriptionText, textInputControl -> textInputControl.getClass().getSimpleName() + " with text: \"" + textInputControl.getText() + "\"", textInputControl -> matcher.matches((Object)textInputControl.getText()));
    }
}

