/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.matcher.base;

import java.util.Optional;
import javafx.scene.paint.Color;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.testfx.matcher.base.GeneralMatchers;
import org.testfx.service.support.ColorMatcher;
import org.testfx.util.ColorUtils;

public class ColorMatchers {
    @Factory
    public static Matcher<Color> isColor(Color color) {
        String descriptionText = "has color " + ColorMatchers.getColorText(color);
        return GeneralMatchers.typeSafeMatcher(Color.class, descriptionText, ColorMatchers::getColorText, col -> col.equals((Object)color));
    }

    @Factory
    public static Matcher<Color> isColor(Color color, ColorMatcher colorMatcher) {
        String descriptionText = "has color " + ColorMatchers.getColorText(color);
        return GeneralMatchers.typeSafeMatcher(Color.class, descriptionText, ColorMatchers::getColorText, col -> colorMatcher.matchColors((Color)col, color));
    }

    @Factory
    public static Matcher<Color> isColor(String namedColor) {
        if (!ColorUtils.getNamedColor(namedColor).isPresent()) {
            throw new AssertionError((Object)("given color name: \"" + namedColor + "\" is not a named color\nSee: https://docs.oracle.com/javase/9/docs/api/javafx/scene/doc-files/cssref.html#typecolor"));
        }
        String descriptionText = "is \"" + namedColor + "\"";
        return GeneralMatchers.typeSafeMatcher(Color.class, descriptionText, ColorMatchers::getColorText, color -> ColorUtils.getNamedColor(namedColor).map(col -> col.equals(color)).orElse(false));
    }

    @Factory
    public static Matcher<Color> hasClosestNamedColor(Color namedColor) {
        Optional<String> namedColorOptional = ColorUtils.getNamedColor(Integer.parseInt(namedColor.toString().substring(2, 8), 16));
        if (!namedColorOptional.isPresent()) {
            throw new AssertionError((Object)("given color: \"#" + namedColor.toString().substring(2, 8) + "\" is not a named color\nSee: https://docs.oracle.com/javase/9/docs/api/javafx/scene/doc-files/cssref.html#typecolor"));
        }
        String descriptionText = "has closest named color " + ColorMatchers.getColorText(namedColor);
        return GeneralMatchers.typeSafeMatcher(Color.class, descriptionText, color -> ColorMatchers.getColorText(color) + " which has closest named color: \"" + ColorUtils.getClosestNamedColor(Integer.parseInt(color.toString().substring(2, 8), 16)) + "\"", color -> namedColor.equals((Object)ColorUtils.getClosestNamedColor(color)));
    }

    @Factory
    public static Matcher<Color> hasClosestNamedColor(String namedColor) {
        Optional<Color> namedColorOptional = ColorUtils.getNamedColor(namedColor);
        if (!namedColorOptional.isPresent()) {
            throw new AssertionError((Object)("given color name: \"" + namedColor + "\" is not a named color\nSee: https://docs.oracle.com/javase/9/docs/api/javafx/scene/doc-files/cssref.html#typecolor"));
        }
        String descriptionText = "has closest named color " + ColorMatchers.getColorText(namedColorOptional.get());
        return GeneralMatchers.typeSafeMatcher(Color.class, descriptionText, color -> ColorMatchers.getColorText(color) + " which has closest named color: \"" + ColorUtils.getClosestNamedColor(Integer.parseInt(color.toString().substring(2, 8), 16)) + "\"", color -> ((Color)namedColorOptional.get()).equals((Object)ColorUtils.getClosestNamedColor(color)));
    }

    private static String getColorText(Color color) {
        String hex = color.toString().substring(2, 8);
        return ColorUtils.getNamedColor(Integer.parseInt(hex, 16)).map(s -> String.format("\"%s\" (#%s)", s, hex)).orElseGet(() -> "\"#" + hex + "\"");
    }
}

