/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.api;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Application;
import javafx.event.Event;
import javafx.stage.Stage;
import org.testfx.service.support.FiredEvents;
import org.testfx.toolkit.PrimaryStageApplication;

public class FxToolkitContext {
    private final CompletableFuture<Stage> primaryStageFuture = PrimaryStageApplication.PRIMARY_STAGE_FUTURE;
    private final Class<? extends Application> applicationClass = PrimaryStageApplication.class;
    private String[] applicationArgs = new String[0];
    private Stage registeredStage;
    private FiredEvents firedEvents;
    private long launchTimeoutInMillis = Long.getLong("testfx.launch.timeout", 60000L);
    private long setupTimeoutInMillis = Long.getLong("testfx.setup.timeout", 30000L);

    public CompletableFuture<Stage> getPrimaryStageFuture() {
        return this.primaryStageFuture;
    }

    public Class<? extends Application> getApplicationClass() {
        return this.applicationClass;
    }

    public String[] getApplicationArgs() {
        return this.applicationArgs;
    }

    public void setApplicationArgs(String[] applicationArgs) {
        this.applicationArgs = applicationArgs;
    }

    public Stage getRegisteredStage() {
        return this.registeredStage;
    }

    public void setRegisteredStage(Stage registeredStage) {
        this.registeredStage = registeredStage;
        if (this.firedEvents != null) {
            this.firedEvents.stopStoringFiredEvents();
        }
        this.firedEvents = FiredEvents.beginStoringFiredEventsOf(registeredStage);
    }

    public List<Event> getFiredEvents() {
        return this.firedEvents.getEvents();
    }

    public long getLaunchTimeoutInMillis() {
        return this.launchTimeoutInMillis;
    }

    public void setLaunchTimeoutInMillis(long launchTimeoutInMillis) {
        this.launchTimeoutInMillis = launchTimeoutInMillis;
    }

    public long getSetupTimeoutInMillis() {
        return this.setupTimeoutInMillis;
    }

    public void setSetupTimeoutInMillis(long setupTimeoutInMillis) {
        this.setupTimeoutInMillis = setupTimeoutInMillis;
    }
}

