/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.api;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.geometry.Bounds;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.MouseButton;
import javafx.stage.Window;
import org.hamcrest.Matcher;
import org.testfx.api.FxRobotContext;
import org.testfx.api.FxRobotException;
import org.testfx.api.FxRobotInterface;
import org.testfx.robot.Motion;
import org.testfx.service.locator.PointLocator;
import org.testfx.service.query.BoundsQuery;
import org.testfx.service.query.NodeQuery;
import org.testfx.service.query.PointQuery;
import org.testfx.service.support.Capture;
import org.testfx.util.BoundsQueryUtils;
import org.testfx.util.NodeQueryUtils;
import org.testfx.util.WaitForAsyncUtils;

public class FxRobot
implements FxRobotInterface {
    private final FxRobotContext context = new FxRobotContext();

    public FxRobotContext robotContext() {
        return this.context;
    }

    @Override
    public Window targetWindow() {
        return this.context.getWindowFinder().targetWindow();
    }

    @Override
    public FxRobot targetWindow(Window window) {
        this.context.getWindowFinder().targetWindow(window);
        return this;
    }

    @Override
    public FxRobot targetWindow(Predicate<Window> predicate) {
        this.context.getWindowFinder().targetWindow(predicate);
        return this;
    }

    @Override
    public FxRobot targetWindow(int windowNumber) {
        this.context.getWindowFinder().targetWindow(windowNumber);
        return this;
    }

    @Override
    public FxRobot targetWindow(String stageTitleRegex) {
        this.context.getWindowFinder().targetWindow(stageTitleRegex);
        return this;
    }

    @Override
    public FxRobot targetWindow(Pattern stageTitlePattern) {
        this.context.getWindowFinder().targetWindow(stageTitlePattern);
        return this;
    }

    @Override
    public FxRobot targetWindow(Scene scene) {
        this.context.getWindowFinder().targetWindow(scene);
        return this;
    }

    @Override
    public FxRobot targetWindow(Node node) {
        this.context.getWindowFinder().targetWindow(node);
        return this;
    }

    @Override
    public List<Window> listWindows() {
        return this.context.getWindowFinder().listWindows();
    }

    @Override
    public List<Window> listTargetWindows() {
        return this.context.getWindowFinder().listTargetWindows();
    }

    @Override
    public Window window(Predicate<Window> predicate) {
        return this.context.getWindowFinder().window(predicate);
    }

    @Override
    public Window window(int windowIndex) {
        return this.context.getWindowFinder().window(windowIndex);
    }

    @Override
    public Window window(String stageTitleRegex) {
        return this.context.getWindowFinder().window(stageTitleRegex);
    }

    @Override
    public Window window(Pattern stageTitlePattern) {
        return this.context.getWindowFinder().window(stageTitlePattern);
    }

    @Override
    public Window window(Scene scene) {
        return this.context.getWindowFinder().window(scene);
    }

    @Override
    public Window window(Node node) {
        return this.context.getWindowFinder().window(node);
    }

    @Override
    public NodeQuery fromAll() {
        return this.context.getNodeFinder().fromAll();
    }

    @Override
    public NodeQuery from(Node ... parentNodes) {
        return this.context.getNodeFinder().from(parentNodes);
    }

    @Override
    public NodeQuery from(Collection<Node> parentNodes) {
        return this.context.getNodeFinder().from(parentNodes);
    }

    @Override
    public NodeQuery from(NodeQuery nodeQuery) {
        return this.context.getNodeFinder().from(nodeQuery);
    }

    @Override
    public NodeQuery lookup(String query) {
        return this.context.getNodeFinder().lookup(query);
    }

    @Override
    public <T extends Node> NodeQuery lookup(Matcher<T> matcher) {
        return this.context.getNodeFinder().lookup(matcher);
    }

    @Override
    public <T extends Node> NodeQuery lookup(Predicate<T> predicate) {
        return this.context.getNodeFinder().lookup(predicate);
    }

    @Override
    public Node rootNode(Window window) {
        return this.context.getNodeFinder().rootNode(window);
    }

    @Override
    public Node rootNode(Scene scene) {
        return this.context.getNodeFinder().rootNode(scene);
    }

    @Override
    public Node rootNode(Node node) {
        return this.context.getNodeFinder().rootNode(node);
    }

    @Override
    public BoundsQuery bounds(double minX, double minY, double width, double height) {
        return () -> BoundsQueryUtils.bounds(minX, minY, width, height);
    }

    @Override
    public BoundsQuery bounds(Point2D point) {
        return () -> BoundsQueryUtils.bounds(point);
    }

    @Override
    public BoundsQuery bounds(Bounds bounds) {
        return () -> bounds;
    }

    @Override
    public BoundsQuery bounds(Node node) {
        return () -> BoundsQueryUtils.boundsOnScreen(node);
    }

    @Override
    public BoundsQuery bounds(Scene scene) {
        return () -> BoundsQueryUtils.boundsOnScreen(BoundsQueryUtils.bounds(scene), scene);
    }

    @Override
    public BoundsQuery bounds(Window window) {
        return () -> BoundsQueryUtils.boundsOnScreen(BoundsQueryUtils.bounds(window), window);
    }

    @Override
    public BoundsQuery bounds(String query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Node> BoundsQuery bounds(Matcher<T> matcher) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Node> BoundsQuery bounds(Predicate<T> predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FxRobot targetPos(Pos pointPosition) {
        this.context.setPointPosition(pointPosition);
        return this;
    }

    @Override
    public PointQuery point(double x, double y) {
        PointLocator pointLocator = this.context.getPointLocator();
        Pos pointPosition = this.context.getPointPosition();
        return pointLocator.point(new Point2D(x, y)).atPosition(pointPosition);
    }

    @Override
    public PointQuery point(Point2D point) {
        PointLocator pointLocator = this.context.getPointLocator();
        Pos pointPosition = this.context.getPointPosition();
        return pointLocator.point(point).atPosition(pointPosition);
    }

    @Override
    public PointQuery point(Bounds bounds) {
        PointLocator pointLocator = this.context.getPointLocator();
        Pos pointPosition = this.context.getPointPosition();
        return pointLocator.point(bounds).atPosition(pointPosition);
    }

    @Override
    public PointQuery point(Node node) {
        PointLocator pointLocator = this.context.getPointLocator();
        Pos pointPosition = this.context.getPointPosition();
        this.targetWindow(node.getScene().getWindow());
        return pointLocator.point(node).onNode(node).atPosition(pointPosition);
    }

    @Override
    public PointQuery point(Scene scene) {
        PointLocator pointLocator = this.context.getPointLocator();
        Pos pointPosition = this.context.getPointPosition();
        this.targetWindow(scene.getWindow());
        return pointLocator.point(scene).atPosition(pointPosition);
    }

    @Override
    public PointQuery point(Window window) {
        PointLocator pointLocator = this.context.getPointLocator();
        Pos pointPosition = this.context.getPointPosition();
        this.targetWindow(window);
        return pointLocator.point(window).atPosition(pointPosition);
    }

    @Override
    public PointQuery point(String query) {
        NodeQuery nodeQuery = this.lookup(query);
        Node node = this.queryNode(nodeQuery, "the query \"" + query + "\"");
        return this.point(node).atPosition(this.context.getPointPosition());
    }

    @Override
    public <T extends Node> PointQuery point(Matcher<T> matcher) {
        NodeQuery nodeQuery = this.lookup(matcher);
        Node node = this.queryNode(nodeQuery, "the matcher \"" + matcher.toString() + "\"");
        return this.point(node).atPosition(this.context.getPointPosition());
    }

    @Override
    public <T extends Node> PointQuery point(Predicate<T> predicate) {
        NodeQuery nodeQuery = this.lookup(predicate);
        Node node = this.queryNode(nodeQuery, "the predicate");
        return this.point(node).atPosition(this.context.getPointPosition());
    }

    @Override
    public PointQuery offset(Point2D point, double offsetX, double offsetY) {
        return this.point(point).atOffset(offsetX, offsetY);
    }

    @Override
    public PointQuery offset(Bounds bounds, double offsetX, double offsetY) {
        return this.point(bounds).atOffset(offsetX, offsetY);
    }

    @Override
    public PointQuery offset(Node node, double offsetX, double offsetY) {
        return this.point(node).atOffset(offsetX, offsetY);
    }

    @Override
    public PointQuery offset(Node node, Pos offsetReferencePos, double offsetX, double offsetY) {
        return this.point(node).atPosition(offsetReferencePos).atOffset(offsetX, offsetY);
    }

    @Override
    public PointQuery offset(Scene scene, double offsetX, double offsetY) {
        return this.point(scene).atOffset(offsetX, offsetY);
    }

    @Override
    public PointQuery offset(Window window, double offsetX, double offsetY) {
        return this.point(window).atOffset(offsetX, offsetY);
    }

    @Override
    public PointQuery offset(String query, double offsetX, double offsetY) {
        return this.point(query).atOffset(offsetX, offsetY);
    }

    @Override
    public <T extends Node> PointQuery offset(Matcher<T> matcher, double offsetX, double offsetY) {
        return this.point(matcher).atOffset(offsetX, offsetY);
    }

    @Override
    public <T extends Node> PointQuery offset(Predicate<T> predicate, double offsetX, double offsetY) {
        return this.point(predicate).atOffset(offsetX, offsetY);
    }

    @Override
    public Capture capture(Rectangle2D screenRegion) {
        return () -> this.context.getCaptureSupport().captureRegion(screenRegion);
    }

    @Override
    public Capture capture(Bounds bounds) {
        Rectangle2D region = new Rectangle2D(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
        return () -> this.context.getCaptureSupport().captureRegion(region);
    }

    @Override
    public Capture capture(Node node) {
        return () -> this.context.getCaptureSupport().captureNode(node);
    }

    @Override
    public Capture capture(Image image) {
        return () -> image;
    }

    @Override
    public Capture capture(Path path) {
        return () -> this.context.getCaptureSupport().loadImage(path);
    }

    @Override
    public Capture capture(URL url) {
        try {
            Path path = Paths.get(url.toURI());
            return () -> this.context.getCaptureSupport().loadImage(path);
        }
        catch (URISyntaxException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public FxRobot interact(Runnable runnable) {
        WaitForAsyncUtils.waitFor(WaitForAsyncUtils.asyncFx(runnable));
        WaitForAsyncUtils.waitForFxEvents();
        return this;
    }

    @Override
    public <T> FxRobot interact(Callable<T> callable) {
        WaitForAsyncUtils.waitFor(WaitForAsyncUtils.asyncFx(callable));
        WaitForAsyncUtils.waitForFxEvents();
        return this;
    }

    @Override
    public FxRobot interactNoWait(Runnable runnable) {
        WaitForAsyncUtils.waitFor(WaitForAsyncUtils.asyncFx(runnable));
        return this;
    }

    @Override
    public <T> FxRobot interactNoWait(Callable<T> callable) {
        WaitForAsyncUtils.waitFor(WaitForAsyncUtils.asyncFx(callable));
        return this;
    }

    @Override
    public FxRobot interrupt() {
        WaitForAsyncUtils.waitForFxEvents();
        return this;
    }

    @Override
    public FxRobot interrupt(int attemptsCount) {
        WaitForAsyncUtils.waitForFxEvents(attemptsCount);
        return this;
    }

    @Override
    public FxRobot push(KeyCode ... combination) {
        this.context.getTypeRobot().push(combination);
        return this;
    }

    @Override
    public FxRobot push(KeyCodeCombination combination) {
        this.context.getTypeRobot().push(combination);
        return this;
    }

    @Override
    public FxRobot type(KeyCode ... keyCodes) {
        this.context.getTypeRobot().type(keyCodes);
        return this;
    }

    @Override
    public FxRobot type(KeyCode keyCode, int times) {
        this.context.getTypeRobot().type(keyCode, times);
        return this;
    }

    @Override
    public FxRobot eraseText(int amount) {
        return this.type(KeyCode.BACK_SPACE, amount);
    }

    @Deprecated
    public FxRobot closeCurrentWindow() {
        return this.push(KeyCode.ALT, KeyCode.F4).sleep(100L);
    }

    @Override
    public FxRobot write(char character) {
        this.context.getWriteRobot().write(character);
        return this;
    }

    @Override
    public FxRobot write(String text) {
        this.context.getWriteRobot().write(text);
        return this;
    }

    @Override
    public FxRobot write(String text, int sleepMillis) {
        this.context.getWriteRobot().write(text, sleepMillis);
        return this;
    }

    @Override
    public FxRobot sleep(long milliseconds) {
        this.context.getSleepRobot().sleep(milliseconds);
        return this;
    }

    @Override
    public FxRobot sleep(long duration, TimeUnit timeUnit) {
        this.context.getSleepRobot().sleep(duration, timeUnit);
        return this;
    }

    @Override
    @Deprecated
    public FxRobot scroll(int amount) {
        this.context.getScrollRobot().scroll(amount);
        return this;
    }

    @Override
    public FxRobot scroll(int amount, VerticalDirection direction) {
        this.context.getScrollRobot().scroll(amount, direction);
        return this;
    }

    @Override
    public FxRobot scroll(VerticalDirection direction) {
        this.scroll(1, direction);
        return this;
    }

    @Override
    public FxRobot scroll(int amount, HorizontalDirection direction) {
        this.context.getScrollRobot().scroll(amount, direction);
        return this;
    }

    @Override
    public FxRobot scroll(HorizontalDirection direction) {
        this.scroll(1, direction);
        return this;
    }

    @Override
    public FxRobot press(KeyCode ... keys) {
        this.context.getKeyboardRobot().press(keys);
        return this;
    }

    @Override
    public FxRobot release(KeyCode ... keys) {
        this.context.getKeyboardRobot().release(keys);
        return this;
    }

    @Override
    public FxRobot press(MouseButton ... buttons) {
        this.context.getMouseRobot().press(buttons);
        return this;
    }

    @Override
    public FxRobot release(MouseButton ... buttons) {
        this.context.getMouseRobot().release(buttons);
        return this;
    }

    @Override
    public FxRobot clickOn(MouseButton ... buttons) {
        this.context.getClickRobot().clickOn(buttons);
        return this;
    }

    @Override
    public FxRobot clickOn(PointQuery pointQuery, Motion motion, MouseButton ... buttons) {
        this.context.getClickRobot().clickOn(pointQuery, motion, buttons);
        return this;
    }

    @Override
    public FxRobot doubleClickOn(MouseButton ... buttons) {
        this.context.getClickRobot().doubleClickOn(buttons);
        return this;
    }

    @Override
    public FxRobot doubleClickOn(PointQuery pointQuery, Motion motion, MouseButton ... buttons) {
        this.context.getClickRobot().doubleClickOn(pointQuery, motion, buttons);
        return this;
    }

    @Override
    public FxRobot clickOn(double x, double y, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.point(x, y), motion, buttons);
    }

    @Override
    public FxRobot clickOn(Point2D point, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.point(point), motion, buttons);
    }

    @Override
    public FxRobot clickOn(Bounds bounds, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.point(bounds), motion, buttons);
    }

    @Override
    public FxRobot clickOn(Node node, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.point(node), motion, buttons);
    }

    @Override
    public FxRobot clickOn(Scene scene, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.point(scene), motion, buttons);
    }

    @Override
    public FxRobot clickOn(Window window, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.point(window), motion, buttons);
    }

    @Override
    public FxRobot clickOn(String query, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.pointOfVisibleNode(query), motion, buttons);
    }

    @Override
    public <T extends Node> FxRobot clickOn(Matcher<T> matcher, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.pointOfVisibleNode(matcher), motion, buttons);
    }

    @Override
    public <T extends Node> FxRobot clickOn(Predicate<T> predicate, Motion motion, MouseButton ... buttons) {
        return this.clickOn(this.pointOfVisibleNode(predicate), motion, buttons);
    }

    @Override
    public FxRobot rightClickOn() {
        return this.clickOn(MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(PointQuery pointQuery, Motion motion) {
        return this.clickOn(pointQuery, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(double x, double y, Motion motion) {
        return this.clickOn(x, y, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(Point2D point, Motion motion) {
        return this.clickOn(point, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(Bounds bounds, Motion motion) {
        return this.clickOn(bounds, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(Node node, Motion motion) {
        return this.clickOn(node, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(Scene scene, Motion motion) {
        return this.clickOn(scene, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(Window window, Motion motion) {
        return this.clickOn(window, motion, MouseButton.SECONDARY);
    }

    @Override
    public FxRobot rightClickOn(String query, Motion motion) {
        return this.clickOn(query, motion, MouseButton.SECONDARY);
    }

    @Override
    public <T extends Node> FxRobot rightClickOn(Matcher<T> matcher, Motion motion) {
        return this.clickOn((Matcher)matcher, motion, new MouseButton[]{MouseButton.SECONDARY});
    }

    @Override
    public <T extends Node> FxRobot rightClickOn(Predicate<T> predicate, Motion motion) {
        return this.clickOn((Predicate)predicate, motion, new MouseButton[]{MouseButton.SECONDARY});
    }

    @Override
    public FxRobot doubleClickOn(double x, double y, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.point(x, y), motion, buttons);
    }

    @Override
    public FxRobot doubleClickOn(Point2D point, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.point(point), motion, buttons);
    }

    @Override
    public FxRobot doubleClickOn(Bounds bounds, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.point(bounds), motion, buttons);
    }

    @Override
    public FxRobot doubleClickOn(Node node, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.point(node), motion, buttons);
    }

    @Override
    public FxRobot doubleClickOn(Scene scene, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.point(scene), motion, buttons);
    }

    @Override
    public FxRobot doubleClickOn(Window window, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.point(window), motion, buttons);
    }

    @Override
    public FxRobot doubleClickOn(String query, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.pointOfVisibleNode(query), motion, buttons);
    }

    @Override
    public <T extends Node> FxRobot doubleClickOn(Matcher<T> matcher, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.pointOfVisibleNode(matcher), motion, buttons);
    }

    @Override
    public <T extends Node> FxRobot doubleClickOn(Predicate<T> predicate, Motion motion, MouseButton ... buttons) {
        return this.doubleClickOn(this.pointOfVisibleNode(predicate), motion, buttons);
    }

    @Override
    public FxRobot drag(MouseButton ... buttons) {
        this.context.getDragRobot().drag(buttons);
        return this;
    }

    @Override
    public FxRobot drag(PointQuery pointQuery, MouseButton ... buttons) {
        this.context.getDragRobot().drag(pointQuery, buttons);
        return this;
    }

    @Override
    public FxRobot drop() {
        this.context.getDragRobot().drop();
        return this;
    }

    @Override
    public FxRobot dropTo(PointQuery pointQuery) {
        this.context.getDragRobot().dropTo(pointQuery);
        return this;
    }

    @Override
    public FxRobot dropBy(double x, double y) {
        this.context.getDragRobot().dropBy(x, y);
        return this;
    }

    @Override
    public FxRobot drag(double x, double y, MouseButton ... buttons) {
        return this.drag(this.point(x, y), buttons);
    }

    @Override
    public FxRobot drag(Point2D point, MouseButton ... buttons) {
        return this.drag(this.point(point), buttons);
    }

    @Override
    public FxRobot drag(Bounds bounds, MouseButton ... buttons) {
        return this.drag(this.point(bounds), buttons);
    }

    @Override
    public FxRobot drag(Node node, MouseButton ... buttons) {
        return this.drag(this.point(node), buttons);
    }

    @Override
    public FxRobot drag(Scene scene, MouseButton ... buttons) {
        return this.drag(this.point(scene), buttons);
    }

    @Override
    public FxRobot drag(Window window, MouseButton ... buttons) {
        return this.drag(this.point(window), buttons);
    }

    @Override
    public FxRobot drag(String query, MouseButton ... buttons) {
        return this.drag(this.pointOfVisibleNode(query), buttons);
    }

    @Override
    public <T extends Node> FxRobot drag(Matcher<T> matcher, MouseButton ... buttons) {
        return this.drag(this.pointOfVisibleNode(matcher), buttons);
    }

    @Override
    public <T extends Node> FxRobot drag(Predicate<T> predicate, MouseButton ... buttons) {
        return this.drag(this.pointOfVisibleNode(predicate), buttons);
    }

    @Override
    public FxRobot dropTo(double x, double y) {
        return this.dropTo(this.point(x, y));
    }

    @Override
    public FxRobot dropTo(Point2D point) {
        return this.dropTo(this.point(point));
    }

    @Override
    public FxRobot dropTo(Bounds bounds) {
        return this.dropTo(this.point(bounds));
    }

    @Override
    public FxRobot dropTo(Node node) {
        return this.dropTo(this.point(node));
    }

    @Override
    public FxRobot dropTo(Scene scene) {
        return this.dropTo(this.point(scene));
    }

    @Override
    public FxRobot dropTo(Window window) {
        return this.dropTo(this.point(window));
    }

    @Override
    public FxRobot dropTo(String query) {
        return this.dropTo(this.pointOfVisibleNode(query));
    }

    @Override
    public <T extends Node> FxRobot dropTo(Matcher<T> matcher) {
        return this.dropTo(this.pointOfVisibleNode(matcher));
    }

    @Override
    public <T extends Node> FxRobot dropTo(Predicate<T> predicate) {
        return this.dropTo(this.pointOfVisibleNode(predicate));
    }

    @Override
    public FxRobot moveTo(PointQuery pointQuery, Motion motion) {
        this.context.getMoveRobot().moveTo(pointQuery, motion);
        return this;
    }

    @Override
    public FxRobot moveBy(double x, double y, Motion motion) {
        this.context.getMoveRobot().moveBy(x, y, motion);
        return this;
    }

    @Override
    public FxRobot moveTo(double x, double y, Motion motion) {
        return this.moveTo(this.point(new Point2D(x, y)), motion);
    }

    @Override
    public FxRobot moveTo(Point2D point, Motion motion) {
        return this.moveTo(this.point(point), motion);
    }

    @Override
    public FxRobot moveTo(Bounds bounds, Motion motion) {
        return this.moveTo(this.point(bounds), motion);
    }

    @Override
    public FxRobot moveTo(Node node, Pos offsetReferencePos, Point2D offset, Motion motion) {
        return this.moveTo(this.point(node).atPosition(offsetReferencePos).atOffset(offset), motion);
    }

    @Override
    public FxRobot moveTo(Scene scene, Motion motion) {
        return this.moveTo(this.point(scene), motion);
    }

    @Override
    public FxRobot moveTo(Window window, Motion motion) {
        return this.moveTo(this.point(window), motion);
    }

    @Override
    public FxRobot moveTo(String query, Motion motion) {
        return this.moveTo(this.pointOfVisibleNode(query), motion);
    }

    @Override
    public <T extends Node> FxRobot moveTo(Matcher<T> matcher, Motion motion) {
        return this.moveTo(this.pointOfVisibleNode(matcher), motion);
    }

    @Override
    public <T extends Node> FxRobot moveTo(Predicate<T> predicate, Motion motion) {
        return this.moveTo(this.pointOfVisibleNode(predicate), motion);
    }

    private PointQuery pointOfVisibleNode(String query) {
        NodeQuery nodeQuery = this.lookup(query);
        Node node = this.queryVisibleNode(nodeQuery, "the query \"" + query + "\"");
        return this.point(node);
    }

    private <T extends Node> PointQuery pointOfVisibleNode(Matcher<T> matcher) {
        NodeQuery nodeQuery = this.lookup(matcher);
        Node node = this.queryVisibleNode(nodeQuery, "the matcher \"" + matcher.toString() + "\"");
        return this.point(node);
    }

    private <T extends Node> PointQuery pointOfVisibleNode(Predicate<T> predicate) {
        NodeQuery nodeQuery = this.lookup(predicate);
        Node node = this.queryVisibleNode(nodeQuery, "the predicate");
        return this.point(node);
    }

    private Node queryNode(NodeQuery nodeQuery, String queryDescription) {
        Optional resultNode = nodeQuery.tryQuery();
        if (!resultNode.isPresent()) {
            throw new FxRobotException(queryDescription + " returned no nodes.");
        }
        return (Node)resultNode.get();
    }

    private Node queryVisibleNode(NodeQuery nodeQuery, String queryDescription) {
        Set<Node> resultNodes = nodeQuery.queryAll();
        if (resultNodes.isEmpty()) {
            throw new FxRobotException(queryDescription + " returned no nodes.");
        }
        Optional resultNode = this.from(resultNodes).match(NodeQueryUtils.isVisible()).tryQuery();
        if (!resultNode.isPresent()) {
            throw new FxRobotException(queryDescription + " returned " + resultNodes.size() + " nodes, but no nodes were visible.");
        }
        return (Node)resultNode.get();
    }
}

