/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.strategy;

import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.YugabyteDBYCQLContainer;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public final class YugabyteDBYCQLWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(YugabyteDBYCQLWaitStrategy.class);
    private static final String YCQL_TEST_QUERY = "SELECT release_version FROM system.local";
    private static final String BIN_PATH = "/home/yugabyte/tserver/bin/ycqlsh";
    private final WaitStrategyTarget target;

    public void waitUntilReady(WaitStrategyTarget target) {
        YugabyteDBYCQLContainer container = (YugabyteDBYCQLContainer)target;
        AtomicBoolean status = new AtomicBoolean(true);
        String containerInterfaceIP = ((ContainerNetwork)((Map.Entry)container.getContainerInfo().getNetworkSettings().getNetworks().entrySet().stream().findFirst().get()).getValue()).getIpAddress();
        Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
            this.getRateLimiter().doWhenReady(() -> {
                block6: {
                    try {
                        Container.ExecResult result = container.execInContainer(new String[]{BIN_PATH, containerInterfaceIP, "-u", container.getUsername(), "-p", container.getPassword(), "-k", container.getKeyspace(), "-e", YCQL_TEST_QUERY});
                        if (result.getExitCode() != 0) {
                            status.set(false);
                            log.debug(result.getStderr());
                        }
                    }
                    catch (Exception e) {
                        status.set(false);
                        log.debug(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (status.getAndSet(true)) break block6;
                        throw new RuntimeException("container hasn't come up yet");
                    }
                }
            });
            return status;
        });
    }

    public void waitUntilReady() {
        this.waitUntilReady(this.target);
    }

    public YugabyteDBYCQLWaitStrategy(WaitStrategyTarget target) {
        this.target = target;
    }
}

