/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.weaviate;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class WeaviateContainer
extends GenericContainer<WeaviateContainer> {
    private static final DockerImageName DEFAULT_WEAVIATE_IMAGE = DockerImageName.parse((String)"cr.weaviate.io/semitechnologies/weaviate");
    private static final DockerImageName DOCKER_HUB_WEAVIATE_IMAGE = DockerImageName.parse((String)"semitechnologies/weaviate");

    public WeaviateContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public WeaviateContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_WEAVIATE_IMAGE, DOCKER_HUB_WEAVIATE_IMAGE});
        this.withExposedPorts(new Integer[]{8080, 50051});
        this.withEnv("AUTHENTICATION_ANONYMOUS_ACCESS_ENABLED", "true");
        this.withEnv("PERSISTENCE_DATA_PATH", "/var/lib/weaviate");
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/v1/.well-known/ready").forPort(8080).forStatusCode(200));
    }

    public String getHttpHostAddress() {
        return this.getHost() + ":" + this.getMappedPort(8080);
    }

    public String getGrpcHostAddress() {
        return this.getHost() + ":" + this.getMappedPort(50051);
    }
}

