/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.timeplus;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class TimeplusContainer
extends JdbcDatabaseContainer<TimeplusContainer> {
    static final String NAME = "timeplus";
    static final String DOCKER_IMAGE_NAME = "timeplus/timeplusd";
    private static final DockerImageName TIMEPLUS_IMAGE_NAME = DockerImageName.parse((String)"timeplus/timeplusd");
    private static final Integer HTTP_PORT = 3218;
    private static final Integer NATIVE_PORT = 8463;
    private static final String DRIVER_CLASS_NAME = "com.timeplus.jdbc.TimeplusDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:timeplus://";
    private static final String TEST_QUERY = "SELECT 1";
    private String databaseName = "default";
    private String username = "default";
    private String password = "";

    public TimeplusContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public TimeplusContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{TIMEPLUS_IMAGE_NAME});
        this.addExposedPorts(new int[]{HTTP_PORT, NATIVE_PORT});
        this.waitingFor(Wait.forHttp((String)"/timeplusd/v1/ping").forStatusCode(200).withStartupTimeout(Duration.ofMinutes(1L)));
    }

    protected void configure() {
        this.withEnv("TIMEPLUS_DB", this.databaseName);
        this.withEnv("TIMEPLUS_USER", this.username);
        this.withEnv("TIMEPLUS_PASSWORD", this.password);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return new HashSet<Integer>(this.getMappedPort(HTTP_PORT));
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getJdbcUrl() {
        return JDBC_URL_PREFIX + this.getHost() + ":" + this.getMappedPort(NATIVE_PORT) + "/" + this.databaseName + this.constructUrlParameters("?", "&");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTestQueryString() {
        return TEST_QUERY;
    }

    public TimeplusContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public TimeplusContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    public TimeplusContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }
}

