/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import java.io.IOException;
import java.io.Writer;
import org.testcontainers.shaded.freemarker.core.CommonMarkupOutputFormat;
import org.testcontainers.shaded.freemarker.core.TemplateXMLOutputModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.utility.StringUtil;

public class XMLOutputFormat
extends CommonMarkupOutputFormat<TemplateXMLOutputModel> {
    public static final XMLOutputFormat INSTANCE = new XMLOutputFormat();

    protected XMLOutputFormat() {
    }

    @Override
    public String getName() {
        return "XML";
    }

    @Override
    public String getMimeType() {
        return "application/xml";
    }

    @Override
    public void output(String textToEsc, Writer out) throws IOException, TemplateModelException {
        StringUtil.XMLEnc(textToEsc, out);
    }

    @Override
    public String escapePlainText(String plainTextContent) {
        return StringUtil.XMLEnc(plainTextContent);
    }

    @Override
    public boolean isLegacyBuiltInBypassed(String builtInName) {
        return builtInName.equals("xml");
    }

    @Override
    protected TemplateXMLOutputModel newTemplateMarkupOutputModel(String plainTextContent, String markupContent) {
        return new TemplateXMLOutputModel(plainTextContent, markupContent);
    }
}

