/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.localstack;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class LocalStackContainer
extends GenericContainer<LocalStackContainer> {
    private static final Logger log = LoggerFactory.getLogger(LocalStackContainer.class);
    static final int PORT = 4566;
    private final List<String> services = new ArrayList<String>();
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"localstack/localstack");
    private static final DockerImageName LOCALSTACK_PRO_IMAGE_NAME = DockerImageName.parse((String)"localstack/localstack-pro");
    private static final String DEFAULT_REGION = "us-east-1";
    private static final String DEFAULT_AWS_ACCESS_KEY_ID = "test";
    private static final String DEFAULT_AWS_SECRET_ACCESS_KEY = "test";
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";

    public LocalStackContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public LocalStackContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, LOCALSTACK_PRO_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{4566});
        this.withFileSystemBind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), "/var/run/docker.sock");
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready\\.\n", (int)1));
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"sh", "-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"}));
    }

    protected void configure() {
        if (!this.services.isEmpty()) {
            this.withEnv("SERVICES", String.join((CharSequence)",", this.services));
        }
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        String command = "#!/bin/bash\n";
        command = command + "export LAMBDA_DOCKER_FLAGS=" + this.configureServiceContainerLabels("LAMBDA_DOCKER_FLAGS") + "\n";
        command = command + "export ECS_DOCKER_FLAGS=" + this.configureServiceContainerLabels("ECS_DOCKER_FLAGS") + "\n";
        command = command + "export EC2_DOCKER_FLAGS=" + this.configureServiceContainerLabels("EC2_DOCKER_FLAGS") + "\n";
        command = command + "export BATCH_DOCKER_FLAGS=" + this.configureServiceContainerLabels("BATCH_DOCKER_FLAGS") + "\n";
        command = command + "/usr/local/bin/docker-entrypoint.sh\n";
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    private String configureServiceContainerLabels(String existingEnvFlagKey) {
        String internalMarkerFlags = this.internalMarkerLabels();
        String existingFlags = (String)this.getEnvMap().get(existingEnvFlagKey);
        if (existingFlags != null) {
            internalMarkerFlags = existingFlags + " " + internalMarkerFlags;
        }
        return "\"" + internalMarkerFlags + "\"";
    }

    private String internalMarkerLabels() {
        return this.getContainerInfo().getConfig().getLabels().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(DockerClientFactory.TESTCONTAINERS_LABEL)).filter(entry -> !((String)entry.getKey()).equals("org.testcontainers.hash") && !((String)entry.getKey()).equals("org.testcontainers.copied_files.hash")).map(entry -> String.format("-l %s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(" "));
    }

    public LocalStackContainer withServices(String ... services) {
        this.services.addAll(Arrays.asList(services));
        return (LocalStackContainer)this.self();
    }

    public URI getEndpoint() {
        try {
            String address = this.getHost();
            String ipAddress = InetAddress.getByName(address).getHostAddress();
            return new URI("http://" + ipAddress + ":" + this.getMappedPort(4566));
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new IllegalStateException("Cannot obtain endpoint URL", e);
        }
    }

    public String getAccessKey() {
        return this.getEnvMap().getOrDefault("AWS_ACCESS_KEY_ID", "test");
    }

    public String getSecretKey() {
        return this.getEnvMap().getOrDefault("AWS_SECRET_ACCESS_KEY", "test");
    }

    public String getRegion() {
        return this.getEnvMap().getOrDefault("DEFAULT_REGION", DEFAULT_REGION);
    }
}

