/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.TestcontainersConfiguration;

public class OracleContainer
extends JdbcDatabaseContainer {
    public static final String NAME = "oracle";
    private static final int ORACLE_PORT = 1521;
    private static final int APEX_HTTP_PORT = 8080;

    private static String resolveImageName() {
        String image = TestcontainersConfiguration.getInstance().getProperties().getProperty("oracle.container.image");
        if (image == null) {
            throw new IllegalStateException("An image to use for Oracle containers must be configured. To do this, please place a file on the classpath named `testcontainers.properties`, containing `oracle.container.image=IMAGE`, where IMAGE is a suitable image name and tag.");
        }
        return image;
    }

    public OracleContainer() {
        super(OracleContainer.resolveImageName());
    }

    public OracleContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(1521);
    }

    protected void configure() {
        this.addExposedPorts(new int[]{1521, 8080});
    }

    public String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:oracle:thin:" + this.getUsername() + "/" + this.getPassword() + "@//" + this.getContainerIpAddress() + ":" + this.getOraclePort() + "/" + this.getSid();
    }

    public String getUsername() {
        return "system";
    }

    public String getPassword() {
        return NAME;
    }

    public String getSid() {
        return "xe";
    }

    public Integer getOraclePort() {
        return this.getMappedPort(1521);
    }

    public Integer getWebPort() {
        return this.getMappedPort(8080);
    }

    public String getTestQueryString() {
        return "SELECT 1 FROM DUAL";
    }

    protected int getStartupTimeoutSeconds() {
        return 240;
    }
}

