/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.TestcontainersConfiguration;

public class OracleContainer<SELF extends JdbcDatabaseContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "oracle";
    public static final String IMAGE = TestcontainersConfiguration.getInstance().getProperties().getProperty("oracle.container.image", "wnameless/oracle-xe-11g");
    private static final int ORACLE_PORT = 1521;
    private static final int APEX_HTTP_PORT = 8080;
    private static final RateLimiter DB_CONNECT_RATE_LIMIT = RateLimiterBuilder.newBuilder().withRate(10, TimeUnit.SECONDS).withConstantThroughput().build();

    public OracleContainer() {
        super(IMAGE + ":latest");
    }

    public OracleContainer(String dockerImageName) {
        super(dockerImageName);
    }

    protected Integer getLivenessCheckPort() {
        return this.getMappedPort(1521);
    }

    protected void configure() {
        this.addExposedPorts(new int[]{1521, 8080});
    }

    public String getDriverClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    public String getJdbcUrl() {
        return "jdbc:oracle:thin:" + this.getUsername() + "/" + this.getPassword() + "@//" + this.getContainerIpAddress() + ":" + this.getOraclePort() + "/" + this.getSid();
    }

    public String getUsername() {
        return "system";
    }

    public String getPassword() {
        return NAME;
    }

    public String getSid() {
        return "xe";
    }

    public Integer getOraclePort() {
        return this.getMappedPort(1521);
    }

    public Integer getWebPort() {
        return this.getMappedPort(8080);
    }

    public String getTestQueryString() {
        return "SELECT 1 FROM DUAL";
    }

    public Connection createConnection(String queryString) throws SQLException {
        Properties info = new Properties();
        info.put("user", this.getUsername());
        info.put("password", this.getPassword());
        String url = this.getJdbcUrl() + queryString;
        Driver jdbcDriverInstance = this.getJdbcDriverInstance();
        try {
            return (Connection)Unreliables.retryUntilSuccess((int)120, (TimeUnit)TimeUnit.SECONDS, () -> jdbcDriverInstance.connect(url, info));
        }
        catch (Exception e) {
            throw new SQLException("Could not create new connection", e);
        }
    }
}

