/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.google.auto.service.AutoService;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.ConnectionFactoryOptions;
import javax.annotation.Nullable;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.MySQLR2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainer;
import org.testcontainers.r2dbc.R2DBCDatabaseContainerProvider;

@AutoService(value={R2DBCDatabaseContainerProvider.class})
public class MySQLR2DBCDatabaseContainerProvider
implements R2DBCDatabaseContainerProvider {
    static final String DRIVER = "mysql";

    public boolean supports(ConnectionFactoryOptions options) {
        return DRIVER.equals(options.getRequiredValue(ConnectionFactoryOptions.DRIVER));
    }

    public R2DBCDatabaseContainer createContainer(ConnectionFactoryOptions options) {
        String image = MySQLContainer.IMAGE + ":" + (String)options.getRequiredValue(IMAGE_TAG_OPTION);
        JdbcDatabaseContainer container = new MySQLContainer(image).withDatabaseName((String)options.getRequiredValue(ConnectionFactoryOptions.DATABASE));
        if (Boolean.TRUE.equals(options.getValue(REUSABLE_OPTION))) {
            container.withReuse(true);
        }
        return new MySQLR2DBCDatabaseContainer((MySQLContainer<?>)container);
    }

    @Nullable
    public ConnectionFactoryMetadata getMetadata(ConnectionFactoryOptions options) {
        ConnectionFactoryOptions.Builder builder = options.mutate();
        if (!options.hasOption(ConnectionFactoryOptions.USER)) {
            builder.option(ConnectionFactoryOptions.USER, (Object)"test");
        }
        if (!options.hasOption(ConnectionFactoryOptions.PASSWORD)) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)"test");
        }
        return super.getMetadata(builder.build());
    }
}

