/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.builder;

import java.io.Serializable;
import org.terracotta.toolkit.builder.ConfigurationImpl;
import org.terracotta.toolkit.nonstop.NonStopConfiguration;
import org.terracotta.toolkit.nonstop.NonStopConfigurationFields;

public class NonStopConfigurationBuilder {
    private NonStopConfigurationFields.NonStopReadTimeoutBehavior immutableOpNonStopTimeoutBehavior = NonStopConfigurationFields.DEFAULT_NON_STOP_READ_TIMEOUT_BEHAVIOR;
    private NonStopConfigurationFields.NonStopWriteTimeoutBehavior mutableOpNonStopTimeoutBehavior = NonStopConfigurationFields.DEFAULT_NON_STOP_WRITE_TIMEOUT_BEHAVIOR;
    private long timeout = NonStopConfigurationFields.DEFAULT_TIMEOUT_MILLIS;
    private long searchTimeout = -1L;
    private boolean isEnabled = true;
    private boolean immediateTimeout = false;

    public NonStopConfigurationBuilder nonStopReadTimeoutBehavior(NonStopConfigurationFields.NonStopReadTimeoutBehavior immutableOpBehavior) {
        this.immutableOpNonStopTimeoutBehavior = immutableOpBehavior;
        return this;
    }

    public NonStopConfigurationBuilder nonStopWriteTimeoutBehavior(NonStopConfigurationFields.NonStopWriteTimeoutBehavior mutableOpBehavior) {
        this.mutableOpNonStopTimeoutBehavior = mutableOpBehavior;
        return this;
    }

    public NonStopConfigurationBuilder timeoutMillis(long timeoutParam) {
        if (timeoutParam < 0L) {
            throw new IllegalArgumentException("timeout cannot be less than 0");
        }
        this.timeout = timeoutParam;
        return this;
    }

    public NonStopConfigurationBuilder searchTimeoutMillis(long searchTimeoutParam) {
        if (searchTimeoutParam < 0L) {
            throw new IllegalArgumentException("default search timeout cannot be less than 0");
        }
        this.searchTimeout = searchTimeoutParam;
        return this;
    }

    public NonStopConfigurationBuilder immediateTimeout(boolean enabled) {
        this.immediateTimeout = enabled;
        return this;
    }

    public NonStopConfigurationBuilder enable(boolean isEnabledParam) {
        this.isEnabled = isEnabledParam;
        return this;
    }

    public NonStopConfiguration build() {
        return new NonStopToolkitConfigImpl(this.isEnabled, this.timeout, this.searchTimeout <= 0L ? this.timeout : this.searchTimeout, this.immutableOpNonStopTimeoutBehavior, this.mutableOpNonStopTimeoutBehavior, this.immediateTimeout);
    }

    private static class NonStopToolkitConfigImpl
    extends ConfigurationImpl
    implements NonStopConfiguration {
        NonStopToolkitConfigImpl(boolean isEnabled, long timeout, long searchTimeout, NonStopConfigurationFields.NonStopReadTimeoutBehavior immutableOpBehavior, NonStopConfigurationFields.NonStopWriteTimeoutBehavior mutableOpBehavior, boolean immediateTimeout) {
            this.internalSetConfigMapping("nonStopTimeoutMillis", Long.valueOf(timeout));
            this.internalSetConfigMapping("nonStopSearchTimeoutMillis", Long.valueOf(searchTimeout));
            this.internalSetConfigMapping("nonStopReadOpTimeoutBehavior", (Serializable)((Object)immutableOpBehavior.name()));
            this.internalSetConfigMapping("nonStopWritesOpTimeoutBehavior", (Serializable)((Object)mutableOpBehavior.name()));
            this.internalSetConfigMapping("nonStopEnabled", Boolean.valueOf(isEnabled));
            this.internalSetConfigMapping("immediateTimeoutEnabled", Boolean.valueOf(immediateTimeout));
        }

        @Override
        public NonStopConfigurationFields.NonStopReadTimeoutBehavior getReadOpNonStopTimeoutBehavior() {
            String mode = this.getString("nonStopReadOpTimeoutBehavior");
            return NonStopConfigurationFields.NonStopReadTimeoutBehavior.valueOf(mode);
        }

        @Override
        public NonStopConfigurationFields.NonStopWriteTimeoutBehavior getWriteOpNonStopTimeoutBehavior() {
            String mode = this.getString("nonStopWritesOpTimeoutBehavior");
            return NonStopConfigurationFields.NonStopWriteTimeoutBehavior.valueOf(mode);
        }

        @Override
        public long getTimeoutMillis() {
            return this.getLong("nonStopTimeoutMillis");
        }

        @Override
        public long getSearchTimeoutMillis() {
            return this.getLong("nonStopSearchTimeoutMillis");
        }

        @Override
        public boolean isEnabled() {
            return this.getBoolean("nonStopEnabled");
        }

        @Override
        public boolean isImmediateTimeoutEnabled() {
            return this.getBoolean("immediateTimeoutEnabled");
        }
    }
}

