/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.terracotta.toolkit.builder.ConfigurationImpl;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.store.ToolkitConfigFields;
import org.terracotta.toolkit.store.ToolkitStore;

abstract class AbstractToolkitStoreCacheConfigBuilder {
    private int concurrency;
    private ToolkitConfigFields.Consistency consistency;
    private long maxBytesLocalHeap;
    private long maxBytesLocalOffheap;
    private int maxCountLocalHeap;
    private boolean localCacheEnabled;
    private boolean offheapEnabled;
    private boolean compressionEnabled;
    private boolean copyOnReadEnabled;
    private boolean pinnedInLocalMemory;
    private final List<ConfigFieldMapping> fieldMappings = new ArrayList<ConfigFieldMapping>();

    AbstractToolkitStoreCacheConfigBuilder() {
    }

    protected void addFieldToApply(String name, Serializable value) {
        this.fieldMappings.add(new ConfigFieldMapping(name, value));
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public ToolkitConfigFields.Consistency getConsistency() {
        return this.consistency;
    }

    public long getMaxBytesLocalHeap() {
        return this.maxBytesLocalHeap;
    }

    public long getMaxBytesLocalOffheap() {
        return this.maxBytesLocalOffheap;
    }

    public long getMaxCountLocalHeap() {
        return this.maxCountLocalHeap;
    }

    public boolean isOffheapEnabled() {
        return this.offheapEnabled;
    }

    public boolean isLocalCacheEnabled() {
        return this.localCacheEnabled;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setPinnedInLocalMemory(boolean pinnedInLocalMemory) {
        this.pinnedInLocalMemory = pinnedInLocalMemory;
        this.addFieldToApply("pinnedInLocalMemory", Boolean.valueOf(this.pinnedInLocalMemory));
    }

    public boolean isPinnedInLocalMemory() {
        return this.pinnedInLocalMemory;
    }

    public boolean isCopyOnReadEnabled() {
        return this.copyOnReadEnabled;
    }

    protected void setConcurrency(int concurrencyParam) throws IllegalArgumentException {
        this.concurrency = concurrencyParam;
        this.addFieldToApply("concurrency", Integer.valueOf(this.concurrency));
    }

    protected void setConsistency(ToolkitConfigFields.Consistency consistencyParam) {
        this.consistency = consistencyParam;
        this.addFieldToApply("consistency", (Serializable)((Object)this.consistency.name()));
    }

    protected void setMaxBytesLocalHeap(long maxBytesLocalHeapParam) throws IllegalArgumentException {
        this.maxBytesLocalHeap = maxBytesLocalHeapParam;
        this.addFieldToApply("maxBytesLocalHeap", Long.valueOf(this.maxBytesLocalHeap));
    }

    protected void setMaxBytesLocalOffheap(long maxBytesLocalOffheapParam) throws IllegalArgumentException {
        this.maxBytesLocalOffheap = maxBytesLocalOffheapParam;
        this.addFieldToApply("maxBytesLocalOffHeap", Long.valueOf(this.maxBytesLocalOffheap));
    }

    protected void setMaxCountLocalHeap(int maxCountLocalHeapParam) throws IllegalArgumentException {
        this.maxCountLocalHeap = maxCountLocalHeapParam;
        this.addFieldToApply("maxCountLocalHeap", Integer.valueOf(this.maxCountLocalHeap));
    }

    protected void setOffheapEnabled(boolean offheapEnabledParam) {
        this.offheapEnabled = offheapEnabledParam;
        this.addFieldToApply("offheapEnabled", Boolean.valueOf(this.offheapEnabled));
    }

    protected void setLocalCacheEnabled(boolean localCacheEnabledParam) {
        this.localCacheEnabled = localCacheEnabledParam;
        this.addFieldToApply("localCacheEnabled", Boolean.valueOf(this.localCacheEnabled));
    }

    protected void setCompressionEnabled(boolean compressionEnabledParam) {
        this.compressionEnabled = compressionEnabledParam;
        this.addFieldToApply("compressionEnabled", Boolean.valueOf(this.compressionEnabled));
    }

    protected void setCopyOnReadEnabled(boolean copyOnReadEnabledParam) {
        this.copyOnReadEnabled = copyOnReadEnabledParam;
        this.addFieldToApply("copyOnReadEnabled", Boolean.valueOf(this.copyOnReadEnabled));
    }

    protected void setConfigField(String fieldName, Serializable value) {
        this.addFieldToApply(fieldName, value);
    }

    public Configuration build() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        for (ConfigFieldMapping field : this.fieldMappings) {
            field.updateConfig(configuration);
        }
        return configuration;
    }

    public void apply(ToolkitStore store) {
        Iterator<ConfigFieldMapping> iter = this.fieldMappings.iterator();
        while (iter.hasNext()) {
            ConfigFieldMapping field = iter.next();
            field.apply(store);
            iter.remove();
        }
    }

    public void apply(ToolkitCache cache) {
        Iterator<ConfigFieldMapping> iter = this.fieldMappings.iterator();
        while (iter.hasNext()) {
            ConfigFieldMapping field = iter.next();
            field.apply(cache);
            iter.remove();
        }
    }

    private static class ConfigFieldMapping {
        private final String fieldName;
        private final Serializable value;

        public ConfigFieldMapping(String fieldName, Serializable value) {
            this.fieldName = fieldName;
            this.value = value;
        }

        void apply(ToolkitStore map) {
            map.setConfigField(this.fieldName, this.value);
        }

        void apply(ToolkitCache map) {
            map.setConfigField(this.fieldName, this.value);
        }

        void updateConfig(ConfigurationImpl configuration) {
            configuration.internalSetConfigMapping(this.fieldName, this.value);
        }
    }
}

