/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FilePermission;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.utilities.io.FilesSupport;

public final class Files {
    private static Logger LOGGER = LoggerFactory.getLogger(Files.class);
    private static final Duration OPERATION_REPEAT_DELAY = Duration.ofMillis(100L);
    private static final int OPERATION_ATTEMPTS = 10;
    private static final Duration DEFAULT_RENAME_TIME_LIMIT = OPERATION_REPEAT_DELAY.multipliedBy(25L);
    public static final Duration MINIMUM_TIME_LIMIT = DEFAULT_RENAME_TIME_LIMIT.dividedBy(4L);
    private static final Set<String> RETRY_REASONS = FilesSupport.getRetryReasons();
    private static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    private static final Set<CopyOption> ACCEPTED_OPTIONS_COPY;
    private static final ExecutorService DELETE_EXECUTOR;
    private static final SecureRandom random;
    private static final ThreadLocal<Map<Path, FileStore>> FILE_STORE_CACHE;
    private static final ThreadLocal<Map<Path, Path>> DRIVE_SUBSTITUTIONS;

    private Files() {
    }

    public static Path rename(Path origin, Path target) throws IOException {
        return Files.rename(origin, target, DEFAULT_RENAME_TIME_LIMIT);
    }

    public static Path rename(Path origin, Path target, Duration renameTimeLimit) throws IOException {
        Objects.requireNonNull(origin, "origin must be non-null");
        Objects.requireNonNull(target, "target must be non-null");
        Objects.requireNonNull(renameTimeLimit, "renameTimeLimit must be non-null");
        Path realOrigin = origin.toRealPath(LinkOption.NOFOLLOW_LINKS);
        Path resolvedTarget = origin.resolveSibling(target);
        Files.retryingRenamePath(realOrigin, () -> resolvedTarget, renameTimeLimit);
        return target;
    }

    public static void deleteTree(Path path) throws IOException {
        Files.deleteTree(path, DEFAULT_RENAME_TIME_LIMIT);
    }

    public static void deleteTree(Path path, Duration renameTimeLimit) throws IOException {
        Objects.requireNonNull(path, "path must be non-null");
        Objects.requireNonNull(renameTimeLimit, "renameTimeLimit must be non-null");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FilePermission(path.toString(), "read,write,delete"));
        }
        Path realPath = path.toRealPath(LinkOption.NOFOLLOW_LINKS);
        Files.deleteTreeWithRetry(realPath, true, renameTimeLimit);
    }

    public static void delete(Path path) throws IOException {
        Files.delete(path, DEFAULT_RENAME_TIME_LIMIT);
    }

    public static void delete(Path path, Duration renameTimeLimit) throws IOException {
        Objects.requireNonNull(path, "path must be non-null");
        Objects.requireNonNull(renameTimeLimit, "renameTimeLimit must be non-null");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FilePermission(path.toString(), "read,write,delete"));
        }
        Path realPath = path.toRealPath(LinkOption.NOFOLLOW_LINKS);
        if (java.nio.file.Files.readAttributes(realPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).isDirectory()) {
            try (DirectoryStream<Path> stream = java.nio.file.Files.newDirectoryStream(realPath);){
                if (stream.iterator().hasNext()) {
                    LOGGER.debug("Failing to delete \"{}\"; directory not empty", (Object)realPath);
                    throw new DirectoryNotEmptyException(realPath.toString());
                }
            }
        }
        Files.deleteTreeWithRetry(realPath, false, renameTimeLimit);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        try {
            Files.delete(path);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path copy(Path source, Path target, CopyOption ... options) throws IOException {
        Objects.requireNonNull(source, "source must be non-null");
        Objects.requireNonNull(target, "target must be non-null");
        try {
            Path path = Files.copyInternal(source, target, options);
            return path;
        }
        finally {
            DRIVE_SUBSTITUTIONS.remove();
            FILE_STORE_CACHE.remove();
        }
    }

    private static Path copyInternal(Path source, Path target, CopyOption[] options) throws IOException {
        Path resolvedTargetParent;
        LinkOption[] linkOptionArray;
        LinkedHashSet<CopyOption> copyOptions = new LinkedHashSet<CopyOption>(Arrays.asList(options));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("copy({}, {}, {})", new Object[]{source, target, Arrays.toString(options)});
        }
        if (!ACCEPTED_OPTIONS_COPY.containsAll(copyOptions)) {
            copyOptions.removeAll(ACCEPTED_OPTIONS_COPY);
            throw new UnsupportedOperationException("Unsupported option(s) specified - " + copyOptions);
        }
        boolean noFollowLinks = copyOptions.contains(LinkOption.NOFOLLOW_LINKS);
        boolean recursive = copyOptions.contains(ExtendedOption.RECURSIVE);
        if (noFollowLinks) {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        } else {
            linkOptionArray = new LinkOption[]{};
        }
        LinkOption[] linkOptions = linkOptionArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new FilePermission(source.toString(), "read"));
            if (noFollowLinks) {
                securityManager.checkPermission(new FilePermission(source.toString(), "readlink"));
                securityManager.checkPermission(new LinkPermission(source.toString(), "symbolic"));
            }
            securityManager.checkPermission(new FilePermission(target.toString(), "read,write,delete"));
        }
        Path specifiedSource = source.toRealPath(LinkOption.NOFOLLOW_LINKS);
        Path resolvedTarget = target.toAbsolutePath();
        if (java.nio.file.Files.exists(resolvedTarget, LinkOption.NOFOLLOW_LINKS)) {
            if (java.nio.file.Files.isSameFile(specifiedSource.toRealPath(linkOptions), resolvedTarget)) {
                return target;
            }
            if (copyOptions.contains(StandardCopyOption.REPLACE_EXISTING)) {
                Files.delete(resolvedTarget);
            } else {
                throw new FileAlreadyExistsException(resolvedTarget.toString());
            }
        }
        if ((resolvedTargetParent = resolvedTarget.getParent()) != null) {
            java.nio.file.Files.createDirectories(resolvedTargetParent, new FileAttribute[0]);
        }
        if (recursive && (java.nio.file.Files.isDirectory(specifiedSource, linkOptions) || noFollowLinks && copyOptions.contains(ExtendedOption.DEEP_COPY) && java.nio.file.Files.isSymbolicLink(specifiedSource) && java.nio.file.Files.isDirectory(specifiedSource, new LinkOption[0]))) {
            EnumSet<FileVisitOption> fileVisitOptions = noFollowLinks ? EnumSet.noneOf(FileVisitOption.class) : EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            java.nio.file.Files.walkFileTree(specifiedSource, fileVisitOptions, Integer.MAX_VALUE, new CopyingFileVisitor(specifiedSource, resolvedTarget, copyOptions, linkOptions));
        } else {
            Object[] effectiveCopyOptions = Files.effectiveCopyOptions(copyOptions);
            if (copyOptions.contains(ExtendedOption.DEEP_COPY)) {
                ArrayList<CopyOption> x = new ArrayList<CopyOption>(Arrays.asList(effectiveCopyOptions));
                x.remove(LinkOption.NOFOLLOW_LINKS);
                effectiveCopyOptions = x.toArray(new CopyOption[0]);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Files.copy({}, {}, {})", new Object[]{specifiedSource, resolvedTarget, Arrays.toString(effectiveCopyOptions)});
            }
            if (copyOptions.contains(ExtendedOption.NOSPAN_FILESTORES) && !copyOptions.contains(LinkOption.NOFOLLOW_LINKS)) {
                Path effectiveSource = java.nio.file.Files.isSymbolicLink(specifiedSource) ? specifiedSource.getParent() : specifiedSource;
                Path resolvedSource = specifiedSource.toRealPath(linkOptions);
                if (!Files.getFileStore(effectiveSource).equals(Files.getFileStore(resolvedSource))) {
                    throw new FileStoreConstraintException(specifiedSource.toString(), resolvedSource.toString(), "not in same FileStore");
                }
            }
            java.nio.file.Files.copy(specifiedSource, resolvedTarget, (CopyOption[])effectiveCopyOptions);
        }
        return target;
    }

    public static Path relocate(Path source, Path target, CopyOption ... options) throws IOException {
        Objects.requireNonNull(source, "source must be non-null");
        Objects.requireNonNull(target, "target must be non-null");
        LinkedHashSet<CopyOption> copyOptions = new LinkedHashSet<CopyOption>(Arrays.asList(options));
        copyOptions.add(LinkOption.NOFOLLOW_LINKS);
        copyOptions.add(StandardCopyOption.COPY_ATTRIBUTES);
        copyOptions.add(ExtendedOption.RECURSIVE);
        try {
            return Files.rename(source, target);
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            Files.copy(source, target, copyOptions.toArray(new CopyOption[0]));
            Files.deleteTree(source);
            return target;
        }
    }

    private static void deleteTreeWithRetry(Path path, boolean retryDirNotEmpty, Duration renameTimeLimit) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[deleteTreeWithRetry] Deleting \"{}\"", (Object)path);
        }
        Path renamedPath = Files.retryingRename(path, () -> Files.randomName("del"), renameTimeLimit);
        LOGGER.debug("Deleting \"{}\" renamed from \"{}\"", (Object)renamedPath, (Object)path);
        Files.deleteTreeWithBackgroundRetry(renamedPath, retryDirNotEmpty);
    }

    private static void deleteTreeWithBackgroundRetry(Path path, boolean retryDirNotEmpty) {
        RetryingDeleteTask deleteTask = new RetryingDeleteTask(DELETE_EXECUTOR, () -> {
            Files.treeDelete(path, retryDirNotEmpty, 10, OPERATION_REPEAT_DELAY);
            return null;
        }, path, retryDirNotEmpty);
        deleteTask.run();
    }

    private static void treeDelete(Path path, final boolean retryDirNotEmpty, final int attempts, final Duration retryDelay) throws IOException {
        if (attempts <= 0) {
            throw new IllegalArgumentException("attempts must be positive");
        }
        if (retryDelay.isNegative()) {
            throw new IllegalArgumentException("retryDelay duration must be non-negative");
        }
        java.nio.file.Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.retryingDelete(file, retryDirNotEmpty, attempts, retryDelay);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.retryingDelete(dir, retryDirNotEmpty, attempts, retryDelay);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * Exception decompiling
     */
    private static void retryingDelete(Path path, boolean retryDirNotEmpty, int attempts, Duration retryDelay) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Path retryingRename(Path originalPath, Supplier<String> targetNameSupplier, Duration renameTimeLimit) throws IOException {
        Supplier<Path> renamePathSupplier = () -> originalPath.resolveSibling(originalPath.getFileSystem().getPath((String)targetNameSupplier.get(), new String[0]));
        return Files.retryingRenamePath(originalPath, renamePathSupplier, renameTimeLimit);
    }

    private static Path retryingRenamePath(Path originalPath, Supplier<Path> renamePathSupplier, Duration renameTimeLimit) throws IOException {
        IOException last;
        Path renamePath;
        if (renameTimeLimit.compareTo(MINIMUM_TIME_LIMIT) < 0) {
            throw new IllegalArgumentException("renameTimeLimit must be greater than " + MINIMUM_TIME_LIMIT);
        }
        boolean interrupted = Thread.interrupted();
        boolean unexpected = false;
        long startTime = System.nanoTime();
        long deadline = startTime + renameTimeLimit.toNanos();
        do {
            renamePath = renamePathSupplier.get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Renaming \"{}\" to \"{}\"", (Object)originalPath, (Object)renamePath);
            }
            try {
                java.nio.file.Files.move(originalPath, renamePath, StandardCopyOption.ATOMIC_MOVE);
                Path path = renamePath;
                return path;
            }
            catch (AtomicMoveNotSupportedException e) {
                throw e;
            }
            catch (FileSystemException e) {
                last = e;
                if (e instanceof AccessDeniedException || RETRY_REASONS.contains(e.getReason())) {
                    try {
                        TimeUnit.NANOSECONDS.sleep(OPERATION_REPEAT_DELAY.toNanos());
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    if (!LOGGER.isTraceEnabled()) continue;
                    LOGGER.trace("Retrying rename of \"{}\"; elapsedTime={}, interrupted={}", new Object[]{originalPath, Duration.ofNanos(System.nanoTime() - startTime), interrupted});
                    continue;
                }
                unexpected = true;
                break;
            }
            catch (IOException e) {
                last = e;
                unexpected = true;
                break;
            }
        } while (deadline - System.nanoTime() >= 0L);
        LOGGER.warn("{} IOException renaming \"{}\" to \"{}\"; elapsedTime={}", new Object[]{unexpected ? "Unexpected" : "Persistent", originalPath, renamePath, Duration.ofNanos(System.nanoTime() - startTime), last});
        throw last;
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static CopyOption[] effectiveCopyOptions(Set<CopyOption> copyOptions) {
        EnumSet<ExtendedOption> privateOptions = EnumSet.allOf(ExtendedOption.class);
        return (CopyOption[])copyOptions.stream().filter(o -> !privateOptions.contains(o)).toArray(CopyOption[]::new);
    }

    private static String format(BasicFileAttributes attributes) {
        return FilesSupport.pathType(attributes).toString();
    }

    private static String randomName(String prefix) {
        long r = random.nextLong();
        return prefix + (r == Long.MIN_VALUE ? 0L : Math.abs(r));
    }

    private static void createWindowsDirectorySymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        LOGGER.trace("createWindowsDirectorySymbolicLink({}, {})", (Object)link, (Object)target);
        Path resolvedTarget = link.resolveSibling(target).normalize();
        Path deletionPoint = null;
        if (!java.nio.file.Files.exists(resolvedTarget, LinkOption.NOFOLLOW_LINKS)) {
            LOGGER.debug("[createWindowsDirectorySymbolicLink] Creating temporary directory \"{}\" for linking", (Object)resolvedTarget);
            Path constructedPath = resolvedTarget.getRoot();
            for (Path path : resolvedTarget) {
                constructedPath = constructedPath.resolve(path);
                if (java.nio.file.Files.exists(constructedPath, LinkOption.NOFOLLOW_LINKS)) continue;
                if (deletionPoint == null) {
                    deletionPoint = constructedPath;
                }
                java.nio.file.Files.createDirectory(constructedPath, new FileAttribute[0]);
            }
        }
        LOGGER.trace("Files.createSymbolicLink({}, {})", (Object)link, (Object)target);
        java.nio.file.Files.createSymbolicLink(link, target, attrs);
        if (deletionPoint != null) {
            LOGGER.debug("[createWindowsDirectorySymbolicLink] Deleting temporary directory \"{}\"", deletionPoint);
            Files.deleteTree(deletionPoint);
        }
    }

    private static FileStore getFileStore(Path path) throws IOException {
        FileStore fileStore;
        Map<Path, FileStore> storeMap;
        block7: {
            storeMap = FILE_STORE_CACHE.get();
            fileStore = storeMap.get(path);
            if (fileStore != null) {
                return fileStore;
            }
            try {
                fileStore = java.nio.file.Files.getFileStore(path);
            }
            catch (FileSystemException e) {
                Path substitutePath;
                if (e.getReason() == null) {
                    throw e;
                }
                Path root = path.getRoot();
                if (root != null && (substitutePath = DRIVE_SUBSTITUTIONS.get().get(root)) != null) {
                    substitutePath = substitutePath.resolve(root.relativize(path));
                    try {
                        fileStore = java.nio.file.Files.getFileStore(substitutePath);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                }
                if (fileStore != null) break block7;
                fileStore = new UnknownFileStore(path);
            }
        }
        storeMap.put(path, fileStore);
        return fileStore;
    }

    static {
        HashSet<ExtendedOption> acceptedOptions = new HashSet<ExtendedOption>(EnumSet.allOf(ExtendedOption.class));
        acceptedOptions.add((ExtendedOption)((Object)StandardCopyOption.COPY_ATTRIBUTES));
        acceptedOptions.add((ExtendedOption)((Object)StandardCopyOption.REPLACE_EXISTING));
        acceptedOptions.add((ExtendedOption)((Object)LinkOption.NOFOLLOW_LINKS));
        ACCEPTED_OPTIONS_COPY = Collections.unmodifiableSet(acceptedOptions);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final ThreadGroup group = new ThreadGroup("DeletionService");
            private final AtomicInteger threadNumber = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(this.group, r, this.group.getName() + "-thread-" + this.threadNumber.incrementAndGet());
                thread.setDaemon(true);
                thread.setPriority(1);
                return thread;
            }
        });
        executor.allowCoreThreadTimeOut(true);
        DELETE_EXECUTOR = executor;
        random = new SecureRandom();
        FILE_STORE_CACHE = ThreadLocal.withInitial(WeakHashMap::new);
        DRIVE_SUBSTITUTIONS = ThreadLocal.withInitial(FilesSupport::getSubsts);
    }

    private static final class UnknownFileStore
    extends FileStore {
        private final Path root;

        private UnknownFileStore(Path root) {
            this.root = root;
        }

        @Override
        public String name() {
            return "Unknown";
        }

        @Override
        public String type() {
            return "Unknown";
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public long getTotalSpace() {
            return 0L;
        }

        @Override
        public long getUsableSpace() {
            return 0L;
        }

        @Override
        public long getUnallocatedSpace() {
            return 0L;
        }

        @Override
        public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
            return false;
        }

        @Override
        public boolean supportsFileAttributeView(String name) {
            return false;
        }

        @Override
        public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
            return null;
        }

        @Override
        public Object getAttribute(String attribute) {
            return null;
        }

        public String toString() {
            return "Unknown (" + this.root + ")";
        }
    }

    public static enum ExtendedOption implements CopyOption
    {
        RECURSIVE,
        NOSPAN_FILESTORES,
        DEEP_COPY;

    }

    public static class FileStoreConstraintException
    extends FileSystemException {
        private static final long serialVersionUID = 1639103038640071760L;

        public FileStoreConstraintException(String file, String other, String reason) {
            super(file, other, reason);
        }
    }

    private static class CopyingFileVisitor
    extends SimpleFileVisitor<Path> {
        private final FileStore sourceFileStore;
        private final Path target;
        private final Set<CopyOption> copyOptions;
        private final LinkOption[] linkOptions;
        private final Path source;
        private final boolean noSpan;
        private final boolean deepCopy;
        private final CopyOption[] effectiveCopyOptions;

        public CopyingFileVisitor(Path source, Path target, Set<CopyOption> copyOptions, LinkOption[] linkOptions) throws IOException {
            this.source = source;
            this.target = target;
            this.copyOptions = copyOptions;
            this.linkOptions = linkOptions;
            this.sourceFileStore = java.nio.file.Files.isSymbolicLink(source) ? Files.getFileStore(source.getParent()) : Files.getFileStore(source);
            this.noSpan = copyOptions.contains(ExtendedOption.NOSPAN_FILESTORES);
            this.deepCopy = copyOptions.contains(ExtendedOption.DEEP_COPY);
            this.effectiveCopyOptions = Files.effectiveCopyOptions(copyOptions);
        }

        private Path relocate(Path path) {
            return this.target.resolve(this.source.relativize(path));
        }

        private void checkFileStore(Path path, LinkOption ... linkOptions) throws IOException {
            if (this.noSpan && !this.sourceFileStore.equals(Files.getFileStore(path.toRealPath(linkOptions)))) {
                throw new FileStoreConstraintException(this.source.toString(), path.toString(), "not in same FileStore");
            }
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        private Optional<Path> containedBy(Path tree, Path candidate) {
            if (!tree.isAbsolute()) {
                throw new IllegalArgumentException("tree (\"" + tree + "\") must be non-relative");
            }
            if (!candidate.isAbsolute()) {
                throw new IllegalArgumentException("candidate (\"" + candidate + "\") must be non-relative");
            }
            try {
                int prefixCount = tree.getNameCount();
                int childCount = candidate.getNameCount();
                if (prefixCount == 0) {
                    if (tree.getRoot() == null) {
                        return Optional.empty();
                    }
                    return java.nio.file.Files.isSameFile(tree, candidate.getRoot()) ? Optional.of(Paths.get("", new String[0])) : Optional.empty();
                }
                if (childCount >= prefixCount) {
                    Path candidateRoot = candidate.getRoot().resolve(candidate.subpath(0, prefixCount));
                    boolean isSame = java.nio.file.Files.isSameFile(tree, candidateRoot);
                    return isSame ? Optional.of(candidateRoot.relativize(candidate)) : Optional.empty();
                }
                return Optional.empty();
            }
            catch (Exception e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("containedBy({}, {}) failed", new Object[]{tree, candidate, e});
                } else {
                    LOGGER.debug("containedBy({}, {}) failed with {}", new Object[]{tree, candidate, e.toString()});
                }
                return Optional.empty();
            }
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetDir = this.relocate(dir);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Files.copy({}, {}, {}) attrs={}", new Object[]{dir, targetDir, Arrays.toString(this.effectiveCopyOptions), Files.format(attrs)});
            }
            this.checkFileStore(dir, this.linkOptions);
            java.nio.file.Files.copy(dir, targetDir, this.effectiveCopyOptions);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path targetFile = this.relocate(file);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Files.copy({}, {}, {}) attrs={}", new Object[]{file, targetFile, Arrays.toString(this.effectiveCopyOptions), Files.format(attrs)});
            }
            if (attrs.isSymbolicLink()) {
                boolean isWindowsDirectoryLink;
                boolean foreignContent = false;
                Path foreignLink = null;
                Path linkTarget = java.nio.file.Files.readSymbolicLink(file);
                try {
                    Integer fileAttributes = (Integer)java.nio.file.Files.getAttribute(file, "dos:attributes", LinkOption.NOFOLLOW_LINKS);
                    isWindowsDirectoryLink = (fileAttributes & 0x10) != 0;
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    isWindowsDirectoryLink = false;
                }
                if (linkTarget.isAbsolute()) {
                    Optional<Path> relativeLink = this.containedBy(this.source, linkTarget);
                    if (relativeLink.isPresent()) {
                        Path relocatedLinkTarget = this.target.resolve(relativeLink.get()).normalize();
                        if (isWindowsDirectoryLink) {
                            Files.createWindowsDirectorySymbolicLink(targetFile, relocatedLinkTarget, new FileAttribute[0]);
                        } else {
                            LOGGER.trace("Files.createSymbolicLink({}, {})", (Object)targetFile, (Object)relocatedLinkTarget);
                            java.nio.file.Files.createSymbolicLink(targetFile, relocatedLinkTarget, new FileAttribute[0]);
                        }
                    } else {
                        foreignContent = true;
                        foreignLink = linkTarget;
                    }
                } else {
                    Path resolvedLinkTarget = file.resolveSibling(linkTarget).normalize().toAbsolutePath();
                    if (this.containedBy(this.source, resolvedLinkTarget).isPresent()) {
                        if (isWindowsDirectoryLink) {
                            Files.createWindowsDirectorySymbolicLink(targetFile, linkTarget, new FileAttribute[0]);
                        } else {
                            LOGGER.trace("Files.createSymbolicLink({}, {})", (Object)targetFile, (Object)linkTarget);
                            java.nio.file.Files.createSymbolicLink(targetFile, linkTarget, new FileAttribute[0]);
                        }
                    } else {
                        foreignContent = true;
                        foreignLink = resolvedLinkTarget;
                    }
                }
                if (foreignContent) {
                    if (!this.deepCopy) {
                        if (linkTarget.isAbsolute()) {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("[symlink] SHALLOW copy({}, {}, {}) attrs={}", new Object[]{file, targetFile, Arrays.toString(this.effectiveCopyOptions), Files.format(attrs)});
                            }
                            java.nio.file.Files.copy(file, targetFile, this.effectiveCopyOptions);
                        } else {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("[symlink] createSymbolicLink({}, {}) attrs={}", new Object[]{foreignLink, targetFile, Files.format(attrs)});
                            }
                            java.nio.file.Files.createSymbolicLink(foreignLink, targetFile, new FileAttribute[0]);
                        }
                    } else {
                        Object[] symlinkOptions = (CopyOption[])this.copyOptions.stream().filter(o -> !o.equals(LinkOption.NOFOLLOW_LINKS)).toArray(CopyOption[]::new);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("[symlink] DEEP copy({}, {}, {}) attrs={}", new Object[]{file, targetFile, Arrays.toString(symlinkOptions), Files.format(attrs)});
                        }
                        this.checkFileStore(file, new LinkOption[0]);
                        Files.copyInternal(file, targetFile, (CopyOption[])symlinkOptions);
                    }
                }
            } else {
                this.checkFileStore(file, this.linkOptions);
                java.nio.file.Files.copy(file, targetFile, this.effectiveCopyOptions);
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class RetryingDeleteTask
    extends FutureTask<Void> {
        private final ExecutorService executor;
        private final Callable<Void> task;
        private final Path deletionPath;
        private final boolean retryDirNotEmpty;

        private RetryingDeleteTask(ExecutorService executor, Callable<Void> deletionTask, Path deletionPath, boolean retryDirNotEmpty) {
            super(deletionTask);
            this.executor = executor;
            this.task = deletionTask;
            this.deletionPath = deletionPath;
            this.retryDirNotEmpty = retryDirNotEmpty;
        }

        @Override
        public void run() {
            boolean retry = true;
            try {
                this.task.call();
                LOGGER.debug("Deletion complete for \"{}\"", (Object)this.deletionPath);
                this.set(null);
                return;
            }
            catch (DirectoryNotEmptyException e) {
                if (this.retryDirNotEmpty) {
                    LOGGER.warn("Failed to delete \"{}\" - retrying", (Object)this.deletionPath, (Object)e);
                } else {
                    LOGGER.warn("Background deletion of \"{}\" failed - manual cleanup needed", (Object)this.deletionPath, (Object)e);
                    this.setException(e);
                    retry = false;
                }
            }
            catch (FileSystemException e) {
                if (e instanceof AccessDeniedException || RETRY_REASONS.contains(e.getReason())) {
                    LOGGER.warn("Failed to delete \"{}\" - retrying", (Object)this.deletionPath, (Object)e);
                } else {
                    this.setException(e);
                    retry = false;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Background deletion of \"{}\" failed - manual cleanup needed", (Object)this.deletionPath, (Object)e);
                this.setException(e);
                retry = false;
            }
            if (this.isCancelled()) {
                LOGGER.warn("Background deletion for \"{}\" canceled - manual cleanup needed", (Object)this.deletionPath);
                this.set(null);
                retry = false;
            }
            if (retry) {
                try {
                    this.executor.execute(this);
                    LOGGER.info("Submitted background deletion task for \"{}\"", (Object)this.deletionPath);
                }
                catch (RejectedExecutionException e) {
                    this.setException(e);
                    LOGGER.warn("Background deletion for \"{}\" failed - manual cleanup needed", (Object)this.deletionPath, (Object)e);
                }
            }
        }
    }
}

