/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class ThrowableCauseMatcher<T extends Throwable>
extends TypeSafeDiagnosingMatcher<T> {
    private final Matcher<? extends Throwable> causeMatcher;

    public ThrowableCauseMatcher(Matcher<? extends Throwable> causeMatcher) {
        this.causeMatcher = causeMatcher;
    }

    protected boolean matchesSafely(T item, Description mismatchDescription) {
        Throwable cause = ((Throwable)item).getCause();
        if (!this.causeMatcher.matches((Object)cause)) {
            this.causeMatcher.describeMismatch((Object)cause, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("with cause ").appendDescriptionOf(this.causeMatcher);
    }

    public static <T extends Throwable> Matcher<T> causedBy(Matcher<? extends Throwable> matcher) {
        return new ThrowableCauseMatcher<T>(matcher);
    }
}

