/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.core.IsEqual;

public class PrimitiveArrayMatching {
    public static Matcher<byte[]> byteArrayWithSize(int size) {
        return new FeatureMatcher<byte[], Integer>(IsEqual.equalTo((Object)size), "a byte array with size", "array size"){

            protected Integer featureValueOf(byte[] actual) {
                return actual.length;
            }
        };
    }

    public static Matcher<byte[]> byteArrayContaining(byte ... values) {
        final Matcher wrappedMatcher = ArrayMatching.arrayContaining((Object[])PrimitiveArrayMatching.wrap(values));
        return new TypeSafeMatcher<byte[]>(){

            protected void describeMismatchSafely(byte[] item, Description mismatchDescription) {
                wrappedMatcher.describeMismatch((Object)PrimitiveArrayMatching.wrap(item), mismatchDescription);
            }

            public void describeTo(Description description) {
                wrappedMatcher.describeTo(description);
            }

            protected boolean matchesSafely(byte[] item) {
                return wrappedMatcher.matches((Object)PrimitiveArrayMatching.wrap(item));
            }
        };
    }

    private static Byte[] wrap(byte[] primitive) {
        Byte[] wrapped = new Byte[primitive.length];
        for (int i = 0; i < wrapped.length; ++i) {
            wrapped[i] = primitive[i];
        }
        return wrapped;
    }
}

