/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.matchers;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.core.IsEqual;

public class Eventually {
    public static Timeout within(Duration duration) {
        return new Timeout(duration);
    }

    private static class InternalAssertionError
    extends AssertionError {
        private static final long serialVersionUID = 1L;

        private InternalAssertionError() {
        }
    }

    public static final class Timeout {
        private final Duration duration;

        private Timeout(Duration duration) {
            this.duration = duration;
        }

        public <T> Matcher<Supplier<? super T>> is(T value) {
            return this.matches(IsEqual.equalTo(value));
        }

        public <T> Matcher<Supplier<? super T>> matches(final Matcher<T> matcher) {
            return new BaseMatcher<Supplier<? super T>>(){
                private volatile Object last;

                public boolean matches(Object item) {
                    if (item instanceof Supplier) {
                        Supplier supplier = (Supplier)item;
                        try {
                            this.runsCleanly(() -> this.lambda$matches$0(matcher, (Supplier)supplier));
                            return true;
                        }
                        catch (InternalAssertionError e) {
                            return false;
                        }
                    }
                    this.last = item;
                    return false;
                }

                public void describeMismatch(Object item, Description description) {
                    Object lastGenerated = this.last;
                    if (lastGenerated == null) {
                        super.describeMismatch(item, description);
                    } else {
                        matcher.describeMismatch(lastGenerated, description);
                    }
                }

                public void describeTo(Description description) {
                    description.appendDescriptionOf((SelfDescribing)matcher).appendText(" (within ").appendValue((Object)duration).appendText(")");
                }

                private /* synthetic */ void lambda$matches$0(Matcher matcher2, Supplier supplier) {
                    this.last = supplier.get();
                    if (!matcher2.matches(this.last)) {
                        throw new InternalAssertionError();
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T execsCleanly(Callable<T> task) throws Exception {
            Instant threshold = Instant.now().plus(this.duration);
            Duration sleep = Duration.ofMillis(50L);
            try {
                while (true) {
                    try {
                        return task.call();
                    }
                    catch (Throwable t) {
                        Thread.sleep(sleep.toMillis());
                        sleep = sleep.multipliedBy(2L);
                        if (Instant.now().isBefore(threshold)) continue;
                        return task.call();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                try {
                    T t = task.call();
                    return t;
                }
                finally {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void runsCleanly(Runnable task) {
            try {
                this.execsCleanly(Executors.callable(task));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

