/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ConsoleAppenderCapture
implements AutoCloseable {
    private static final String MDC_KEY_ROOT = ConsoleAppenderCapture.class.getSimpleName() + ".testId";
    private final String testId;
    private final String mdcKey = MDC_KEY_ROOT + '.' + UUID.randomUUID();
    private final Runnable removeAppenders;
    private final Map<String, ListAppender<ILoggingEvent>> appenderMap = new HashMap<String, ListAppender<ILoggingEvent>>();
    private final Set<String> supplementalThreads = new ConcurrentSkipListSet<String>();

    public static ConsoleAppenderCapture capture(String testId) {
        ConsoleAppenderCapture cac = new ConsoleAppenderCapture(testId);
        if (cac.appenderMap.isEmpty()) {
            cac.close();
            throw new IllegalStateException("Current logging configuration does not use " + ConsoleAppender.class.getName());
        }
        return cac;
    }

    public static ConsoleAppenderCapture capture() {
        return ConsoleAppenderCapture.capture(null);
    }

    public ConsoleAppenderCapture(String testId) {
        this.testId = testId == null ? "present" : testId;
        MDC.put((String)this.mdcKey, (String)this.testId);
        Runnable removeAppenders = () -> {};
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        block0: for (Logger logger : context.getLoggerList()) {
            Iterator appenderIterator = logger.iteratorForAppenders();
            while (appenderIterator.hasNext()) {
                Appender iLoggingEventAppender = (Appender)appenderIterator.next();
                if (!(iLoggingEventAppender instanceof ConsoleAppender)) continue;
                String target = ((ConsoleAppender)iLoggingEventAppender).getTarget();
                ListAppender appender = this.appenderMap.computeIfAbsent(target, t -> {
                    ListAppender listAppender = new ListAppender();
                    listAppender.setContext((Context)context);
                    listAppender.addFilter((Filter)new AbstractMatcherFilter<ILoggingEvent>(){

                        public FilterReply decide(ILoggingEvent iLoggingEvent) {
                            if (iLoggingEvent.getMDCPropertyMap().getOrDefault(ConsoleAppenderCapture.this.mdcKey, "").equals(ConsoleAppenderCapture.this.testId)) {
                                return FilterReply.ACCEPT;
                            }
                            if (ConsoleAppenderCapture.this.supplementalThreads.contains(iLoggingEvent.getThreadName())) {
                                return FilterReply.ACCEPT;
                            }
                            return FilterReply.DENY;
                        }
                    });
                    listAppender.start();
                    return listAppender;
                });
                logger.addAppender((Appender)appender);
                Runnable r = removeAppenders;
                removeAppenders = () -> {
                    r.run();
                    logger.detachAppender((Appender)appender);
                    appender.stop();
                };
                continue block0;
            }
        }
        this.removeAppenders = removeAppenders;
    }

    public void addSupplementalThread(Thread thread) {
        this.supplementalThreads.add(Objects.requireNonNull(thread, "thread").getName());
    }

    public void removeSupplementalThread(Thread thread) {
        this.supplementalThreads.remove(Objects.requireNonNull(thread, "thread").getName());
    }

    public Map<String, List<ILoggingEvent>> getLogs() {
        return this.appenderMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ListAppender)e.getValue()).list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ILoggingEvent> getEvents(Target target) {
        ListAppender<ILoggingEvent> appender = this.appenderMap.get(target.targetName());
        if (appender == null) {
            return Collections.emptyList();
        }
        ListAppender<ILoggingEvent> listAppender = appender;
        synchronized (listAppender) {
            return new ArrayList<ILoggingEvent>(appender.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMessages(Target target) {
        Objects.requireNonNull(target, "target");
        ListAppender<ILoggingEvent> appender = this.appenderMap.get(target.targetName());
        if (appender == null) {
            return Collections.emptyList();
        }
        ListAppender<ILoggingEvent> listAppender = appender;
        synchronized (listAppender) {
            return appender.list.stream().map(ILoggingEvent::getFormattedMessage).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessagesAsString(Target target) {
        Objects.requireNonNull(target, "target");
        ListAppender<ILoggingEvent> appender = this.appenderMap.get(target.targetName());
        if (appender == null) {
            return "";
        }
        ListAppender<ILoggingEvent> listAppender = appender;
        synchronized (listAppender) {
            return appender.list.stream().map(ILoggingEvent::getFormattedMessage).collect(Collectors.joining(System.lineSeparator()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Target target) {
        Objects.requireNonNull(target, "target");
        ListAppender<ILoggingEvent> appender = this.appenderMap.get(target.targetName());
        if (appender != null) {
            ListAppender<ILoggingEvent> listAppender = appender;
            synchronized (listAppender) {
                appender.list.clear();
            }
        }
    }

    @Override
    public void close() {
        this.removeAppenders.run();
        MDC.remove((String)this.mdcKey);
    }

    public static enum Target {
        STDOUT(ConsoleTarget.SystemOut),
        STDERR(ConsoleTarget.SystemErr);

        private final ConsoleTarget target;

        private Target(ConsoleTarget target) {
            this.target = target;
        }

        public String targetName() {
            return this.target.getName();
        }
    }
}

