/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.junit.Rule;
import org.junit.experimental.results.PrintableResult;
import org.junit.rules.TestName;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.terracotta.org.junit.rules.TemporaryFolder;
import org.terracotta.utilities.io.CapturedPrintStream;
import org.terracotta.utilities.test.AbstractRepeatingRunListener;

public abstract class AbstractRepeatingTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final TestName testName = new TestName();

    protected final void repeatTestRequest(int repeatCount, Request testRequest) throws IOException, AssertionError {
        this.repeatTestRequest(repeatCount, testRequest, new LocalListener(System.out, EnumSet.allOf(ListenerEvents.class)));
    }

    protected final void repeatTestRequest(int repeatCount, Request testRequest, Set<ListenerEvents> enabledEvents) throws IOException, AssertionError {
        this.repeatTestRequest(repeatCount, testRequest, enabledEvents, new Monitor());
    }

    protected final void repeatTestRequest(int repeatCount, Request testRequest, Set<ListenerEvents> enabledEvents, Monitor monitor) throws IOException, AssertionError {
        this.repeatTestRequest(repeatCount, testRequest, new LocalListener(System.out, Objects.requireNonNull(enabledEvents)), monitor);
    }

    protected final void repeatTestRequest(int repeatCount, Request testRequest, AbstractRepeatingRunListener listener) throws IOException, AssertionError {
        this.repeatTestRequest(repeatCount, testRequest, listener, new Monitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void repeatTestRequest(int repeatCount, Request testRequest, AbstractRepeatingRunListener listener, Monitor monitor) throws IOException, AssertionError {
        if (repeatCount <= 0) {
            throw new IllegalArgumentException("repeatCount must be a positive integer");
        }
        Objects.requireNonNull(testRequest, "testRequest cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(monitor, "monitor cannot be null");
        PrintStream stdout = System.out;
        monitor.setOut(stdout);
        PrintStream stderr = System.err;
        monitor.setErr(stderr);
        JUnitCore core = new JUnitCore();
        core.addListener((RunListener)listener);
        Path outPath = this.temporaryFolder.newFile(this.testName.getMethodName() + ".stdout").toPath();
        Path errPath = this.temporaryFolder.newFile(this.testName.getMethodName() + ".stderr").toPath();
        try (CapturedPrintStream captureStdout = CapturedPrintStream.getInstance((Path)outPath);
             CapturedPrintStream captureStderr = CapturedPrintStream.getInstance((Path)errPath);){
            for (int i = 0; i < repeatCount; ++i) {
                Result result;
                int iteration = i + 1;
                listener.setIteration(iteration);
                System.setOut((PrintStream)captureStdout);
                System.setErr((PrintStream)captureStderr);
                long testStartTime = System.currentTimeMillis();
                captureStdout.format("%1$tT.%1tL [%02d] Begin STDOUT for iteration=%2$d%n", new Object[]{testStartTime, iteration});
                captureStderr.format("%1$tT.%1tL [%02d] Begin STDERR for iteration=%2$d%n", new Object[]{testStartTime, iteration});
                try {
                    monitor.before(iteration);
                    result = core.run(testRequest);
                    monitor.after(iteration, result);
                }
                catch (Throwable throwable) {
                    System.setErr(stderr);
                    System.setOut(stdout);
                    long testEndTime = System.currentTimeMillis();
                    captureStdout.format("%1$tT.%1tL [%02d] End STDOUT for iteration=%2$d%n", new Object[]{testEndTime, iteration});
                    captureStderr.format("%1$tT.%1tL [%02d] End STDERR for iteration=%2$d%n", new Object[]{testEndTime, iteration});
                    captureStdout.flush();
                    captureStderr.flush();
                    throw throwable;
                }
                System.setErr(stderr);
                System.setOut(stdout);
                long testEndTime = System.currentTimeMillis();
                captureStdout.format("%1$tT.%1tL [%02d] End STDOUT for iteration=%2$d%n", new Object[]{testEndTime, iteration});
                captureStderr.format("%1$tT.%1tL [%02d] End STDERR for iteration=%2$d%n", new Object[]{testEndTime, iteration});
                captureStdout.flush();
                captureStderr.flush();
                if (!result.wasSuccessful()) {
                    List failures = result.getFailures();
                    System.out.print(new PrintableResult(failures));
                    System.out.println(">>> Begin failing stdout");
                    captureStdout.getReader().lines().forEachOrdered(System.out::println);
                    System.out.println("<<< End failing stdout");
                    System.err.println(">>> Begin failing stderr");
                    captureStderr.getReader().lines().forEachOrdered(System.err::println);
                    System.err.println("<<< End failing stderr");
                    AssertionError totalFailure = new AssertionError((Object)("Failed running iteration " + iteration));
                    for (Failure failure : failures) {
                        ((Throwable)((Object)totalFailure)).addSuppressed(failure.getException());
                    }
                    throw totalFailure;
                }
                captureStdout.reset();
                captureStderr.reset();
            }
        }
    }

    public static enum ListenerEvents {
        RUN_STARTED,
        RUN_FINISHED,
        TEST_STARTED,
        TEST_FINISHED,
        TEST_FAILED,
        TEST_IGNORED,
        TEST_SKIPPED;

    }

    public static class Monitor {
        private PrintStream stdout;
        private PrintStream stderr;

        private void setOut(PrintStream stdout) {
            this.stdout = stdout;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public final PrintStream out() {
            return this.stdout;
        }

        private void setErr(PrintStream stderr) {
            this.stderr = stderr;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public final PrintStream err() {
            return this.stderr;
        }

        public void before(int iteration) {
        }

        public void after(int iteration, Result result) {
        }
    }

    private static class LocalListener
    extends AbstractRepeatingRunListener {
        private final PrintStream out;
        private final Set<ListenerEvents> activeEvents;

        LocalListener(PrintStream out, Set<ListenerEvents> activeEvents) {
            this.out = out;
            this.activeEvents = activeEvents;
        }

        public void testRunStarted(Description description) {
            if (this.activeEvents.contains((Object)ListenerEvents.RUN_STARTED)) {
                this.out.format("%n%1$tT.%1tL [%02d] Starting %s; iteration=%2$d%n", System.currentTimeMillis(), this.iteration(), description);
            }
        }

        public void testStarted(Description description) {
            if (this.activeEvents.contains((Object)ListenerEvents.TEST_STARTED)) {
                this.out.format("%1$tT.%1tL [%02d] Starting %s; iteration=%2$d%n", System.currentTimeMillis(), this.iteration(), description);
            }
        }

        public void testFinished(Description description) {
            if (this.activeEvents.contains((Object)ListenerEvents.TEST_FINISHED)) {
                this.out.format("%1$tT.%1tL [%02d] Completed %s; iteration=%2$d%n", System.currentTimeMillis(), this.iteration(), description);
            }
        }

        public void testFailure(Failure failure) {
            if (this.activeEvents.contains((Object)ListenerEvents.TEST_FAILED)) {
                this.out.format("%n%1$tT.%1tL [%02d] Failed %s; iteration=%2$d%n    %s%n", System.currentTimeMillis(), this.iteration(), failure.getDescription(), failure.getException());
            }
        }

        public void testAssumptionFailure(Failure failure) {
            if (this.activeEvents.contains((Object)ListenerEvents.TEST_SKIPPED)) {
                this.out.format("%1$tT.%1tL [%02d] Skipped %s; iteration=%2$d%n    %s%n", System.currentTimeMillis(), this.iteration(), failure.getDescription(), failure.getException());
            }
        }

        public void testIgnored(Description description) {
            if (this.activeEvents.contains((Object)ListenerEvents.TEST_IGNORED)) {
                this.out.format("%1$tT.%1tL [%02d] Ignored %s; iteration=%2$d%n", System.currentTimeMillis(), this.iteration(), description);
            }
        }

        public void testRunFinished(Result result) {
            if (this.activeEvents.contains((Object)ListenerEvents.RUN_FINISHED)) {
                this.out.format("%1$tT.%1tL [%02d] Ended  Runtime=%.3f s%n", System.currentTimeMillis(), this.iteration(), Float.valueOf((float)result.getRunTime() / 1000.0f));
                if (result.getFailureCount() != 0) {
                    this.out.println("Failed tests:");
                    result.getFailures().forEach(failure -> this.out.format("    %s%n", failure));
                }
                this.out.format("Tests run=%d, ignored=%d, failed=%d%n", result.getRunCount(), result.getIgnoreCount(), result.getFailureCount());
            }
        }
    }
}

