/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import javax.management.MBeanServer;

public final class Diagnostics {
    private static final String HOTSPOT_DIAGNOSTIC_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String HEAP_DUMP_FILENAME_TEMPLATE = "java_%1$04d_%2$tFT%2$tH%2$tM%2$tS.%2$tL.hprof";
    private static final File WORKING_DIRECTORY = new File(System.getProperty("user.dir"));

    private Diagnostics() {
    }

    public static void dumpThreads(Collection<Thread> threads, boolean useThreadInfo, PrintStream printStream) {
        class ThreadPair {
            final Thread thread;
            final ThreadInfo threadInfo;

            public ThreadPair(Thread thread, ThreadInfo threadInfo) {
                this.thread = thread;
                this.threadInfo = threadInfo;
            }

            public ThreadPair(Thread thread) {
                this(thread, null);
            }
        }
        ArrayList<ThreadPair> threadPairs = new ArrayList<ThreadPair>();
        if (useThreadInfo) {
            ArrayList<Thread> threadList = new ArrayList<Thread>(threads);
            long[] threadIds = threadList.stream().mapToLong(Thread::getId).toArray();
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadIds, true, true);
            for (int i = 0; i < threadList.size(); ++i) {
                threadPairs.add(new ThreadPair((Thread)threadList.get(i), threadInfos[i]));
            }
        } else {
            threads.stream().map(x$0 -> new ThreadPair((Thread)x$0)).forEach(threadPairs::add);
        }
        for (ThreadPair p : threadPairs) {
            if (p.threadInfo == null) {
                Thread t = p.thread;
                printStream.format("\"%s\" Id=%d prio=%d %s%n", new Object[]{t.getName(), t.getId(), t.getPriority(), t.getState()});
                for (StackTraceElement element : t.getStackTrace()) {
                    printStream.format("\tat %s%n", element);
                }
                printStream.println();
                continue;
            }
            printStream.print(Diagnostics.format(p.threadInfo));
        }
    }

    public static void threadDump() {
        Diagnostics.threadDump(System.err);
    }

    public static void threadDump(PrintStream out) {
        Objects.requireNonNull(out, "out");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Calendar when = Calendar.getInstance();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
        out.format("%nFull thread dump %1$tF %1$tT.%1$tL %1$tz%n", when);
        for (ThreadInfo threadInfo : threadInfos) {
            out.print(Diagnostics.format(threadInfo));
        }
    }

    private static CharSequence format(ThreadInfo threadInfo) {
        StringBuilder sb = new StringBuilder(4096);
        Thread.State threadState = threadInfo.getThreadState();
        sb.append('\"').append(threadInfo.getThreadName()).append('\"').append(" Id=").append(threadInfo.getThreadId()).append(' ').append((Object)threadState);
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by ").append('\"').append(threadInfo.getLockOwnerName()).append('\"').append(" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            sb.append("\tat ").append(element);
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                switch (threadState) {
                    case BLOCKED: {
                        sb.append("\t- blocked on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t- waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitorInfo = monitorInfoArray[j];
                if (monitorInfo.getLockedStackDepth() != i) continue;
                sb.append("\t- locked ").append(monitorInfo);
                sb.append('\n');
            }
        }
        LockInfo[] lockedSynchronizers = threadInfo.getLockedSynchronizers();
        if (lockedSynchronizers.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(lockedSynchronizers.length);
            sb.append('\n');
            for (LockInfo lockedSynchronizer : lockedSynchronizers) {
                sb.append("\t- ").append(lockedSynchronizer);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb;
    }

    public static String dumpHeap(boolean dumpLiveObjects) {
        long pid = Diagnostics.getLongPid();
        Date currentTime = new Date();
        String dumpName = pid > 0L ? String.format(HEAP_DUMP_FILENAME_TEMPLATE, pid, currentTime) : String.format(HEAP_DUMP_FILENAME_TEMPLATE, 0, currentTime);
        dumpName = new File(WORKING_DIRECTORY, dumpName).getAbsolutePath();
        try {
            Diagnostics.dumpHeap(dumpLiveObjects, dumpName);
        }
        catch (IOException e) {
            System.err.printf("Unable to write heap dump to %s: %s%n", dumpName, e);
            e.printStackTrace(System.err);
            return null;
        }
        return dumpName;
    }

    public static void dumpHeap(boolean dumpLiveObjects, String dumpName) throws IOException {
        if (dumpName == null) {
            throw new NullPointerException("dumpName");
        }
        if (!dumpName.endsWith(".hprof")) {
            dumpName = dumpName + ".hprof";
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_DIAGNOSTIC_MXBEAN_NAME, HotSpotDiagnosticMXBean.class);
        hotSpotDiagnosticMXBean.dumpHeap(dumpName, dumpLiveObjects);
    }

    @Deprecated
    public static int getPid() {
        return (int)Pid.PID.orElse(-1L);
    }

    public static long getLongPid() {
        return Pid.PID.orElse(-1L);
    }

    public static Thread[] getAllThreads() {
        Thread[] threads;
        int actualThreadCount;
        ThreadGroup root = Diagnostics.rootGroup();
        for (int estThreadCount = 1 + root.activeCount(); (actualThreadCount = root.enumerate(threads = new Thread[estThreadCount])) >= estThreadCount; estThreadCount += 1 + estThreadCount * 20 / 100) {
        }
        threads = Arrays.copyOf(threads, actualThreadCount);
        return threads;
    }

    private static ThreadGroup rootGroup() {
        ThreadGroup parent;
        ThreadGroup root = parent = Thread.currentThread().getThreadGroup();
        while ((parent = parent.getParent()) != null) {
            root = parent;
        }
        return root;
    }

    public static void dumpBufferPoolInfo() {
        Diagnostics.dumpBufferPoolInfo(System.out);
    }

    public static void dumpBufferPoolInfo(PrintStream out) {
        out.println("BufferPoolMXBeans:");
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean pool : pools) {
            out.format("[%s] count=%d, used=%sB, capacity=%sB%n", pool.getName(), pool.getCount(), Diagnostics.formatSize(pool.getMemoryUsed()), Diagnostics.formatSize(pool.getTotalCapacity()));
        }
    }

    public static Long getMaxDirectMemory() {
        return Diagnostics.getMaxDirectMemoryInfo().maxDirectMemory();
    }

    public static MaxDirectMemoryInfo getMaxDirectMemoryInfo() {
        return MaxDirectMemoryInfoHelper.INSTANCE;
    }

    private static String formatSize(long v) {
        if (v < 1024L) {
            return v + " ";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        return String.format("%.1f %si", (double)v / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static class MaxDirectMemoryInfo {
        private final Long maxDirectMemory;
        private final String vmClassName;
        private final Throwable maxDirectMemoryAccessFault;

        private MaxDirectMemoryInfo(Long maxDirectMemory, String vmClassName, Throwable maxDirectMemoryAccessFault) {
            this.maxDirectMemory = maxDirectMemory;
            this.vmClassName = vmClassName;
            this.maxDirectMemoryAccessFault = maxDirectMemoryAccessFault;
        }

        public Long maxDirectMemory() {
            return this.maxDirectMemory;
        }

        public String vmClassName() {
            return this.vmClassName;
        }

        public String maxDirectMemoryAccessFault() {
            return this.maxDirectMemoryAccessFault == null ? "" : this.maxDirectMemoryAccessFault.toString();
        }
    }

    private static class MaxDirectMemoryInfoHelper {
        private static final MaxDirectMemoryInfo INSTANCE = MaxDirectMemoryInfoHelper.getMaxDirectMemoryInfoInternal();

        private MaxDirectMemoryInfoHelper() {
        }

        private static MaxDirectMemoryInfo getMaxDirectMemoryInfoInternal() {
            ReflectiveOperationException maxDirectMemoryFault = null;
            Long maxDirectMemory = null;
            Class<?> vmClass = null;
            try {
                vmClass = Class.forName("jdk.internal.misc.VM");
            }
            catch (ClassNotFoundException e) {
                try {
                    vmClass = Class.forName("sun.misc.VM");
                }
                catch (ClassNotFoundException e1) {
                    maxDirectMemoryFault = e;
                }
            }
            if (vmClass != null) {
                try {
                    maxDirectMemory = (Long)vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    if (vmClass.getName().startsWith("jdk") && e.getMessage().contains(" does not export ")) {
                        System.err.format("Unable to access %s.maxDirectMemory(): Access to maxDirectMemory() requires the java option '--add-exports %s/%s=ALL-UNNAMED'%n", vmClass.getName(), MaxDirectMemoryInfoHelper.getModuleName(vmClass), vmClass.getPackage().getName());
                    }
                    maxDirectMemoryFault = e;
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    maxDirectMemoryFault = e;
                }
            }
            return new MaxDirectMemoryInfo(maxDirectMemory, vmClass == null ? "<unavailable>" : vmClass.getName(), maxDirectMemoryFault);
        }

        private static String getModuleName(Class<?> clazz) {
            try {
                Object module = clazz.getClass().getDeclaredMethod("getModule", new Class[0]).invoke(clazz, new Object[0]);
                return (String)module.getClass().getDeclaredMethod("getName", new Class[0]).invoke(module, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
    }

    private static final class Pid {
        private static final OptionalLong PID = Pid.getPidInternal();

        private Pid() {
        }

        private static OptionalLong getPidInternal() {
            Long pid = null;
            try {
                Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
                Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
                Method getPidMethod = processHandleClass.getMethod("pid", new Class[0]);
                pid = (Long)getPidMethod.invoke(currentMethod.invoke(null, new Object[0]), new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String jvmProcessName = ManagementFactory.getRuntimeMXBean().getName();
                try {
                    pid = Long.parseLong(jvmProcessName.substring(0, jvmProcessName.indexOf(64)));
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
            return pid == null ? OptionalLong.empty() : OptionalLong.of(pid);
        }
    }
}

