/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.search.attribute;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.toolkit.search.SearchException;

public enum ToolkitAttributeType {
    BOOLEAN{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Boolean)) {
                throw new SearchException("Expecting a Boolean value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    BYTE{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Byte)) {
                throw new SearchException("Expecting a Byte value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    CHAR{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Character)) {
                throw new SearchException("Expecting a Character value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    DOUBLE{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Double)) {
                throw new SearchException("Expecting a Double value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    FLOAT{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Float)) {
                throw new SearchException("Expecting a Float value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    INT{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Integer)) {
                throw new SearchException("Expecting an Integer value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    LONG{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Long)) {
                throw new SearchException("Expecting a Long value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    SHORT{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Short)) {
                throw new SearchException("Expecting a Short value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    DATE{

        @Override
        public void validateValue(String name, Object value) {
            if (value == null || value.getClass() != Date.class) {
                throw new SearchException("Expecting a java.util.Date value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    SQL_DATE{

        @Override
        public void validateValue(String name, Object value) {
            if (value == null || value.getClass() != java.sql.Date.class) {
                throw new SearchException("Expecting a java.sql.Date value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    ENUM{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof Enum)) {
                throw new SearchException("Expecting a enum value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    }
    ,
    STRING{

        @Override
        public void validateValue(String name, Object value) {
            if (!(value instanceof String)) {
                throw new SearchException("Expecting a String value for attribute [" + name + "] but was " + ToolkitAttributeType.type(value));
            }
        }
    };

    private static final Map<Class, ToolkitAttributeType> MAPPINGS;

    public static ToolkitAttributeType typeFor(String name, Object value) throws SearchException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        ToolkitAttributeType type = ToolkitAttributeType.typeForOrNull(value instanceof Enum ? ((Enum)value).getDeclaringClass() : value.getClass());
        if (type != null) {
            return type;
        }
        throw new SearchException("Unsupported type for search attribute [" + name + "]: " + value.getClass().getName());
    }

    public static ToolkitAttributeType typeFor(Class<?> c) {
        if (c == null) {
            throw new NullPointerException("null class");
        }
        return ToolkitAttributeType.typeForOrNull(c);
    }

    public static boolean isSupportedType(Object value) {
        if (value == null) {
            return true;
        }
        return ToolkitAttributeType.typeForOrNull(value.getClass()) != null;
    }

    public abstract void validateValue(String var1, Object var2) throws SearchException;

    public boolean isComparable() {
        return true;
    }

    private static String type(Object value) {
        if (value == null) {
            return "null";
        }
        return value.getClass().getName();
    }

    private static ToolkitAttributeType typeForOrNull(Class<?> c) {
        ToolkitAttributeType type = MAPPINGS.get(c);
        if (type != null) {
            return type;
        }
        return c.isEnum() ? ENUM : null;
    }

    static {
        MAPPINGS = new HashMap<Class, ToolkitAttributeType>();
        MAPPINGS.put(Boolean.class, BOOLEAN);
        MAPPINGS.put(Byte.class, BYTE);
        MAPPINGS.put(Character.class, CHAR);
        MAPPINGS.put(Double.class, DOUBLE);
        MAPPINGS.put(Float.class, FLOAT);
        MAPPINGS.put(Integer.class, INT);
        MAPPINGS.put(Long.class, LONG);
        MAPPINGS.put(Short.class, SHORT);
        MAPPINGS.put(String.class, STRING);
        MAPPINGS.put(Date.class, DATE);
        MAPPINGS.put(java.sql.Date.class, SQL_DATE);
        MAPPINGS.put(Character.TYPE, CHAR);
        MAPPINGS.put(Integer.TYPE, INT);
        MAPPINGS.put(Long.TYPE, LONG);
        MAPPINGS.put(Byte.TYPE, BYTE);
        MAPPINGS.put(Boolean.TYPE, BOOLEAN);
        MAPPINGS.put(Float.TYPE, FLOAT);
        MAPPINGS.put(Double.TYPE, DOUBLE);
        MAPPINGS.put(Short.TYPE, SHORT);
    }
}

