/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.toolkit.config.Configuration;

public enum SupportedConfigurationType {
    INTEGER(Integer.class){

        @Override
        public <T> Integer getFromConfig(Configuration config, String name) {
            return config.getInt(name);
        }
    }
    ,
    BOOLEAN(Boolean.class){

        @Override
        public <T> Boolean getFromConfig(Configuration config, String name) {
            return config.getBoolean(name);
        }
    }
    ,
    STRING(String.class){

        public <T> String getFromConfig(Configuration config, String name) {
            return config.getString(name);
        }
    }
    ,
    LONG(Long.class){

        @Override
        public <T> Long getFromConfig(Configuration config, String name) {
            return config.getLong(name);
        }

        @Override
        public boolean isSupported(SupportedConfigurationType other) {
            return this == other || other == INTEGER;
        }
    };

    private static final Map<Class, SupportedConfigurationType> SUPPORTED_TYPES;
    private final Class classType;

    public static SupportedConfigurationType getTypeForObject(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null");
        }
        SupportedConfigurationType configType = SUPPORTED_TYPES.get(obj.getClass());
        if (configType == null) {
            throw new RuntimeException("Unsupported type of object - class: " + obj.getClass().getName() + ", value: " + obj);
        }
        return configType;
    }

    public static boolean isTypeSupported(Object obj) {
        if (obj == null) {
            return false;
        }
        return SUPPORTED_TYPES.get(obj.getClass()) != null;
    }

    public static SupportedConfigurationType getTypeForObjectOrNull(Object obj) {
        if (obj == null) {
            return null;
        }
        return SUPPORTED_TYPES.get(obj.getClass());
    }

    private SupportedConfigurationType(Class classType) {
        this.classType = classType;
    }

    public abstract <T> Serializable getFromConfig(Configuration var1, String var2);

    public boolean isSupported(SupportedConfigurationType other) {
        return this == other;
    }

    static {
        HashMap<Class, SupportedConfigurationType> tmp = new HashMap<Class, SupportedConfigurationType>();
        for (SupportedConfigurationType type : SupportedConfigurationType.values()) {
            tmp.put(type.classType, type);
        }
        SUPPORTED_TYPES = tmp;
    }
}

