/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLConfigUtil {
    private static final Pattern pattern = Pattern.compile("\\$\\{.+?\\}");

    public static String translateSystemProperties(String urlConfig) {
        String[] urlConfigSources;
        Object rv = "";
        for (String source : urlConfigSources = urlConfig.split(",")) {
            source = source.trim();
            Set<String> properties = URLConfigUtil.extractPropertyTokens(source);
            for (String token : properties) {
                String leftTrimmed = token.replaceAll("\\$\\{", "");
                String trimmedToken = leftTrimmed.replaceAll("\\}", "");
                String property = System.getProperty(trimmedToken);
                if (property == null) continue;
                String propertyWithQuotesProtected = Matcher.quoteReplacement(property);
                source = source.replaceAll("\\$\\{" + trimmedToken + "\\}", propertyWithQuotesProtected);
            }
            if (source == null) continue;
            rv = (String)rv + (rv == "" ? "" : ",") + source;
        }
        return rv;
    }

    static Set<String> extractPropertyTokens(String sourceString) {
        HashSet<String> propertyTokens = new HashSet<String>();
        Matcher matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            String token = matcher.group();
            propertyTokens.add(token);
        }
        return propertyTokens;
    }

    public static String getUsername(String embeddedTcConfig) {
        String translated = URLConfigUtil.translateSystemProperties(embeddedTcConfig);
        String[] split = translated.split(",");
        String username = null;
        for (String s : split) {
            int index = s.indexOf(64);
            if (index == -1) continue;
            String tmpUsername = s.substring(0, index).trim();
            if (username != null && !username.equals(tmpUsername)) {
                throw new AssertionError((Object)String.format("Invalid configuration: different username found in Terracotta connection URLs - %s and %s", username, tmpUsername));
            }
            username = tmpUsername;
            try {
                username = URLDecoder.decode(username, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return username;
    }
}

