/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.express;

import com.google.common.collect.MapMaker;
import com.tc.abortable.AbortableOperationManager;
import com.tc.abortable.AbortableOperationManagerImpl;
import com.tc.license.ProductID;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.core.SecurityInfo;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.object.DistributedObjectClientFactory;
import com.tc.util.ProductInfo;
import com.tc.util.UUID;
import com.terracotta.toolkit.express.ClientCreatorCallable;
import com.terracotta.toolkit.express.URLConfigUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.license.util.Base64;

public class CreateClient
implements Callable<ClientCreatorCallable> {
    private static TCLogger logger;
    private final String embeddedTcConfig;
    private final boolean isURLConfig;
    private final String productIdName;
    private final String clientName;
    private final ClassLoader loader;
    private final boolean rejoin;
    private final SecurityInfo securityInfo;
    private final Map<String, Object> env;

    public CreateClient(String embeddedTcConfig, boolean isURLConfig, ClassLoader loader, boolean rejoin, String productIdName, String clientName, Map<String, Object> env) {
        this.embeddedTcConfig = embeddedTcConfig;
        this.isURLConfig = isURLConfig;
        this.productIdName = productIdName;
        this.clientName = clientName;
        String username = null;
        if (isURLConfig) {
            username = URLConfigUtil.getUsername(embeddedTcConfig);
        }
        this.securityInfo = new SecurityInfo(username != null, username);
        this.loader = loader;
        this.rejoin = rejoin;
        this.env = env;
    }

    @Override
    public ClientCreatorCallable call() throws Exception {
        TCSecurityManager securityManager = null;
        if (this.securityInfo.isSecure()) {
            if (!ProductInfo.getInstance().isEnterprise()) {
                throw new RuntimeException("You're trying to setup a secured environment, which requires a EE version of Terracotta");
            }
            logger.info((Object)("Secured environment! Enabling SSL & will be authenticating as user '" + this.securityInfo.getUsername() + "'"));
            securityManager = DistributedObjectClientFactory.createSecurityManager(this.env);
        }
        Object configSpec = this.embeddedTcConfig;
        if (!this.isURLConfig) {
            configSpec = "base64://" + Base64.encodeBytes((byte[])this.embeddedTcConfig.getBytes("UTF-8"), (int)10);
        }
        ProductID productId = this.productIdName == null ? ProductID.USER : ProductID.valueOf((String)this.productIdName);
        AbortableOperationManagerImpl abortableOperationManager = new AbortableOperationManagerImpl();
        UUID uuid = UUID.getUUID();
        DistributedObjectClientFactory distributedObjectClientFactory = new DistributedObjectClientFactory((String)configSpec, securityManager, this.securityInfo, this.loader, this.rejoin, productId, this.clientName, (AbortableOperationManager)abortableOperationManager, uuid);
        return new ClientCreatorCallableImpl(distributedObjectClientFactory, (AbortableOperationManager)abortableOperationManager, uuid);
    }

    static {
        ConcurrentMap dummy = new MapMaker().weakValues().makeMap();
        dummy.put("dummy", new Object());
        logger = TCLogging.getLogger(CreateClient.class);
    }

    public static class ClientCreatorCallableImpl
    implements ClientCreatorCallable {
        private final DistributedObjectClientFactory distributedObjectClientFactory;
        private final AbortableOperationManager abortableOperationManager;
        private final UUID uuid;

        public ClientCreatorCallableImpl(DistributedObjectClientFactory distributedObjectClientFactory, AbortableOperationManager abortableOperationManager, UUID uuid) {
            this.distributedObjectClientFactory = distributedObjectClientFactory;
            this.abortableOperationManager = abortableOperationManager;
            this.uuid = uuid;
        }

        @Override
        public Object call() throws Exception {
            return this.distributedObjectClientFactory.create();
        }

        @Override
        public Object getAbortableOperationManager() {
            return this.abortableOperationManager;
        }

        @Override
        public String getUuid() {
            return this.uuid.toString();
        }
    }
}

