/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.client;

import com.terracotta.toolkit.client.TerracottaClientConfig;
import com.terracotta.toolkit.express.TerracottaInternalClient;
import com.terracotta.toolkit.express.TerracottaInternalClientStaticFactory;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.terracotta.toolkit.ToolkitInstantiationException;
import org.terracotta.toolkit.internal.TerracottaL1Instance;
import org.terracotta.toolkit.internal.ToolkitInternal;

public class TerracottaToolkitCreator {
    private static final long TIME_TO_WAIT_FOR_ASYNC_INIT = Long.getLong("com.tc.non.stop.init.wait.time.millis", TimeUnit.SECONDS.toMillis(20L));
    private static final String INIT_WAIT_KEY = "toolkit.init.wait.time.millis";
    private static final String NON_STOP_INIT_THREAD_NAME = "Non Stop initialization of Toolkit";
    private static final String INIT_THREAD_NAME = "Initialization of Toolkit";
    private static final String TOOLKIT_IMPL_CLASSNAME = "com.terracotta.toolkit.TerracottaToolkit";
    private static final String ENTERPRISE_TOOLKIT_IMPL_CLASSNAME = "com.terracotta.toolkit.EnterpriseTerracottaToolkit";
    private static final String NON_STOP_TOOLKIT_IMPL_CLASSNAME = "com.terracotta.toolkit.NonStopToolkitImpl";
    private static final String ENTERPRISE_NON_STOP_TOOLKIT_IMPL_CLASSNAME = "com.terracotta.toolkit.EnterpriseNonStopToolkitImpl";
    private static final String TOOLKIT_DEFAULT_CM_PROVIDER = "com.terracotta.toolkit.ToolkitCacheManagerProvider";
    private static final String PLATFORM_SERVICE = "com.tc.platform.PlatformService";
    private static final String ABORTABLE_OPERATION_MANAGER = "com.tc.abortable.AbortableOperationManager";
    private final TerracottaInternalClient internalClient;
    private final boolean enterprise;
    private final TerracottaClientConfig config;
    private final Properties toolkitProperties;
    private final ClassLoader loader;
    private final boolean isNonStop;
    private final NonStopPlatformServiceHelper nonStopPlatformServiceHelper;
    private final boolean nonstopInitEnabled;

    public TerracottaToolkitCreator(TerracottaClientConfig config, Properties properties, boolean enterprise) {
        this.enterprise = enterprise;
        if (config == null) {
            throw new NullPointerException("terracottaClientConfig cannot be null");
        }
        this.config = config;
        this.internalClient = this.createInternalClient();
        this.toolkitProperties = properties;
        this.loader = config.getClassLoader();
        this.isNonStop = config.isNonStopEnabled();
        this.nonstopInitEnabled = config.isAsyncInit();
        this.nonStopPlatformServiceHelper = new NonStopPlatformServiceHelper();
    }

    public ToolkitInternal createToolkit() {
        try {
            Object defaultToolkitCacheManagerProvider = this.initializeDefaultCacheManagerProvider();
            if (!this.nonstopInitEnabled) {
                if (this.isNonStop) {
                    return this.instantiateNonStopToolkit(this.createInternalToolkitSynchronously(defaultToolkitCacheManagerProvider));
                }
                return this.createInternalToolkitSynchronously(defaultToolkitCacheManagerProvider);
            }
            if (this.isNonStop) {
                FutureTask<ToolkitInternal> futureTask = this.createInternalToolkitAsynchronously(defaultToolkitCacheManagerProvider, NON_STOP_INIT_THREAD_NAME, TIME_TO_WAIT_FOR_ASYNC_INIT);
                return this.instantiateNonStopToolkit(futureTask);
            }
            long timeout = this.getToolkitInitTimeout();
            FutureTask<ToolkitInternal> futureTask = this.createInternalToolkitAsynchronously(defaultToolkitCacheManagerProvider, INIT_THREAD_NAME, timeout);
            if (!futureTask.isDone()) {
                throw new ToolkitInstantiationException("Not able to initialize toolkit in " + timeout + " milliseconds");
            }
            return futureTask.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create toolkit.", e);
        }
    }

    private long getToolkitInitTimeout() throws ToolkitInstantiationException {
        long timeoutInMills = Long.valueOf(this.toolkitProperties.getProperty(INIT_WAIT_KEY, String.valueOf(Long.MAX_VALUE)));
        if (timeoutInMills <= 0L) {
            throw new ToolkitInstantiationException("Toolkit initilization timeout should be greater than zero but provided " + timeoutInMills);
        }
        return timeoutInMills;
    }

    private ToolkitInternal createInternalToolkitSynchronously(Object defaultToolkitCacheManagerProvider) throws Exception {
        ToolkitInternal toolkit = null;
        try {
            toolkit = this.createInternalToolkit(defaultToolkitCacheManagerProvider);
        }
        catch (Exception e) {
            if (defaultToolkitCacheManagerProvider != null) {
                NonStopPlatformServiceHelper.getMethod(defaultToolkitCacheManagerProvider, "shutdownDefaultCacheManager").invoke(defaultToolkitCacheManagerProvider, new Object[0]);
            }
            throw e;
        }
        if (this.isNonStop) {
            this.nonStopPlatformServiceHelper.setPlatformService(this.internalClient.getPlatformService());
        }
        return toolkit;
    }

    private FutureTask<ToolkitInternal> createInternalToolkitAsynchronously(final Object defaultToolkitCacheManagerProvider, String threadName, long timeoutInMills) {
        final CountDownLatch latch = new CountDownLatch(1);
        Callable<ToolkitInternal> callable = new Callable<ToolkitInternal>(){

            @Override
            public ToolkitInternal call() throws Exception {
                return TerracottaToolkitCreator.this.createInternalToolkitSynchronously(defaultToolkitCacheManagerProvider);
            }
        };
        final FutureTask<ToolkitInternal> futureTask = new FutureTask<ToolkitInternal>(callable);
        Thread t = new Thread(threadName){

            @Override
            public void run() {
                futureTask.run();
                latch.countDown();
            }
        };
        t.start();
        try {
            latch.await(timeoutInMills, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return futureTask;
    }

    private ToolkitInternal createInternalToolkit(Object defaultToolkitCacheManagerProvider) throws Exception {
        this.internalClient.init();
        String className = this.enterprise ? ENTERPRISE_TOOLKIT_IMPL_CLASSNAME : TOOLKIT_IMPL_CLASSNAME;
        return (ToolkitInternal)this.internalClient.instantiate(className, new Class[]{TerracottaL1Instance.class, this.internalClient.loadClass(TOOLKIT_DEFAULT_CM_PROVIDER), Boolean.TYPE, ClassLoader.class, this.internalClient.loadClass(PLATFORM_SERVICE)}, new Object[]{this.getTerracottaL1Instance(), defaultToolkitCacheManagerProvider, this.isNonStop, this.loader, this.internalClient.getPlatformService()});
    }

    private TerracottaInternalClient createInternalClient() {
        try {
            return TerracottaInternalClientStaticFactory.getOrCreateTerracottaInternalClient(this.config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ToolkitInternal instantiateNonStopToolkit(FutureTask<ToolkitInternal> futureTask) throws Exception {
        String className = this.enterprise ? ENTERPRISE_NON_STOP_TOOLKIT_IMPL_CLASSNAME : NON_STOP_TOOLKIT_IMPL_CLASSNAME;
        ToolkitInternal tk = (ToolkitInternal)this.internalClient.instantiate(className, new Class[]{FutureTask.class, this.internalClient.loadClass(ABORTABLE_OPERATION_MANAGER), String.class}, new Object[]{futureTask, this.internalClient.getAbortableOperationManager(), this.internalClient.getUuid()});
        this.nonStopPlatformServiceHelper.setToolkit(tk);
        return tk;
    }

    private ToolkitInternal instantiateNonStopToolkit(ToolkitInternal toolkit) throws Exception {
        String className = this.enterprise ? ENTERPRISE_NON_STOP_TOOLKIT_IMPL_CLASSNAME : NON_STOP_TOOLKIT_IMPL_CLASSNAME;
        ToolkitInternal tk = (ToolkitInternal)this.internalClient.instantiate(className, new Class[]{ToolkitInternal.class, this.internalClient.loadClass(ABORTABLE_OPERATION_MANAGER), String.class}, new Object[]{toolkit, this.internalClient.getAbortableOperationManager(), this.internalClient.getUuid()});
        this.nonStopPlatformServiceHelper.setToolkit(tk);
        return tk;
    }

    private TerracottaL1Instance getTerracottaL1Instance() {
        return new TCL1Instance(this.internalClient);
    }

    private Object initializeDefaultCacheManagerProvider() {
        try {
            return this.internalClient.instantiate(TOOLKIT_DEFAULT_CM_PROVIDER, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class TCL1Instance
    implements TerracottaL1Instance {
        private final TerracottaInternalClient terracottaInternalClient;

        public TCL1Instance(TerracottaInternalClient terracottaInternalClient) {
            this.terracottaInternalClient = terracottaInternalClient;
        }

        @Override
        public void shutdown() {
            this.terracottaInternalClient.shutdown();
        }
    }

    private static class NonStopPlatformServiceHelper {
        private boolean set = false;
        private Object platformService;
        private ToolkitInternal nonStopToolkit;

        private NonStopPlatformServiceHelper() {
        }

        synchronized void setPlatformService(Object platformService) throws Exception {
            this.platformService = platformService;
            this.attemptSet();
        }

        synchronized void setToolkit(ToolkitInternal nonStopToolkit) throws Exception {
            this.nonStopToolkit = nonStopToolkit;
            this.attemptSet();
        }

        private void attemptSet() throws Exception {
            if (this.set) {
                return;
            }
            if (this.platformService != null && this.nonStopToolkit != null) {
                this.set = true;
                NonStopPlatformServiceHelper.getMethod(this.nonStopToolkit, "setPlatformService").invoke((Object)this.nonStopToolkit, this.platformService);
            }
        }

        private static Method getMethod(Object obj, String name) {
            for (Method m : obj.getClass().getMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
            throw new AssertionError((Object)("No accessible method [" + name + "] on " + obj.getClass()));
        }
    }
}

