/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.key;

import org.terracotta.agent.repkg.de.schlichtherle.key.AbstractKeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyPromptingCancelledException;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingKeyManager;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingKeyProviderUI;
import org.terracotta.agent.repkg.de.schlichtherle.key.UnknownKeyException;

public class PromptingKeyProvider
extends AbstractKeyProvider {
    private final PromptingLock lock = new PromptingLock();
    private String resourceID;
    private PromptingKeyProviderUI ui;
    private State state = Reset.access$100();

    public synchronized String getResourceID() {
        return this.resourceID;
    }

    final synchronized void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    protected String getUIClassID() {
        return "PromptingKeyProvider";
    }

    private final synchronized PromptingKeyProviderUI getUI() {
        return this.ui;
    }

    final synchronized void setUI(PromptingKeyProviderUI ui) {
        this.ui = ui;
    }

    private final synchronized State getState() {
        return this.state;
    }

    private final synchronized void setState(State state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object getCreateKeyImpl() throws UnknownKeyException {
        PromptingLock promptingLock = this.lock;
        synchronized (promptingLock) {
            return this.getState().getCreateKey(this);
        }
    }

    private Object promptCreateKey() throws UnknownKeyException {
        PromptingKeyManager.ensurePrompting();
        Object oldKey = this.getKey();
        try {
            PromptingKeyProviderUI ui = this.getUI();
            ui.promptCreateKey(this);
        }
        catch (RuntimeException failure) {
            Throwable cause = failure.getCause();
            if (cause instanceof UnknownKeyException) {
                throw (UnknownKeyException)cause;
            }
            throw failure;
        }
        this.resetKey(oldKey);
        Object newKey = this.getKey();
        if (newKey != null) {
            this.setState(KeyChanged.STATE);
            return newKey;
        }
        this.setState(Cancelled.STATE);
        throw new KeyPromptingCancelledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Object getOpenKeyImpl() throws UnknownKeyException {
        PromptingLock promptingLock = this.lock;
        synchronized (promptingLock) {
            return this.getState().getOpenKey(this);
        }
    }

    private Object promptOpenKey(boolean invalid) throws UnknownKeyException {
        boolean changeKey;
        PromptingKeyManager.ensurePrompting();
        Object oldKey = this.getKey();
        try {
            PromptingKeyProviderUI ui = this.getUI();
            changeKey = invalid ? ui.promptInvalidOpenKey(this) : ui.promptUnknownOpenKey(this);
        }
        catch (RuntimeException failure) {
            Throwable cause = failure.getCause();
            if (cause instanceof UnknownKeyException) {
                throw (UnknownKeyException)cause;
            }
            throw failure;
        }
        this.resetKey(oldKey);
        Object newKey = this.getKey();
        if (newKey != null) {
            if (changeKey) {
                this.setState(KeyChangeRequested.STATE);
            } else {
                this.setState(KeyProvided.STATE);
            }
            return newKey;
        }
        this.setState(Cancelled.STATE);
        throw new KeyPromptingCancelledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKey(Object oldKey) {
        if (oldKey != null && oldKey != this.getKey()) {
            Object newKey = this.getKey();
            try {
                this.setKey(oldKey);
                this.resetKey();
            }
            finally {
                this.setKey(newKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void invalidOpenKeyImpl() {
        PromptingLock promptingLock = this.lock;
        synchronized (promptingLock) {
            this.getState().invalidOpenKey(this);
        }
    }

    final void resetCancelledPrompt() {
        this.getState().resetCancelledPrompt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void reset() {
        this.setState(Reset.STATE);
        try {
            this.resetKey();
        }
        finally {
            this.onReset();
        }
    }

    protected void onReset() {
    }

    @Override
    protected synchronized KeyProvider addToKeyManager(String resourceID) throws NullPointerException, IllegalStateException {
        String oldResourceID = this.getResourceID();
        if (oldResourceID != null && !oldResourceID.equals(resourceID)) {
            throw new IllegalStateException("PromptingKeyProvider instances cannot be shared!");
        }
        KeyProvider provider = super.addToKeyManager(resourceID);
        this.setResourceID(resourceID);
        return provider;
    }

    @Override
    protected synchronized KeyProvider removeFromKeyManager(String resourceID) throws NullPointerException, IllegalStateException {
        KeyProvider provider = super.removeFromKeyManager(this.getResourceID());
        this.setResourceID(null);
        return provider;
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }

    private static class Cancelled
    extends State {
        private static final State STATE = new Cancelled();

        private Cancelled() {
        }

        @Override
        public Object getCreateKey(PromptingKeyProvider provider) throws UnknownKeyException {
            throw new KeyPromptingCancelledException();
        }

        @Override
        public Object getOpenKey(PromptingKeyProvider provider) throws UnknownKeyException {
            throw new KeyPromptingCancelledException();
        }

        @Override
        public void invalidOpenKey(PromptingKeyProvider provider) {
        }

        @Override
        public void resetCancelledPrompt(PromptingKeyProvider provider) {
            provider.reset();
        }
    }

    private static class KeyChanged
    extends KeyProvided {
        private static final State STATE = new KeyChanged();

        private KeyChanged() {
        }

        @Override
        public void invalidOpenKey(PromptingKeyProvider provider) {
        }
    }

    private static class KeyChangeRequested
    extends KeyProvided {
        private static final State STATE = new KeyChangeRequested();

        private KeyChangeRequested() {
        }

        @Override
        public Object getCreateKey(PromptingKeyProvider provider) throws UnknownKeyException {
            return provider.promptCreateKey();
        }
    }

    private static class KeyProvided
    extends State {
        private static final State STATE = new KeyProvided();

        private KeyProvided() {
        }

        @Override
        public Object getCreateKey(PromptingKeyProvider provider) throws UnknownKeyException {
            return provider.getKey();
        }

        @Override
        public Object getOpenKey(PromptingKeyProvider provider) {
            return provider.getKey();
        }

        @Override
        public void invalidOpenKey(PromptingKeyProvider provider) {
            provider.setState(KeyInvalidated.STATE);
        }
    }

    private static class KeyInvalidated
    extends Reset {
        private static final State STATE = new KeyInvalidated();

        private KeyInvalidated() {
        }

        @Override
        public Object getOpenKey(PromptingKeyProvider provider) throws UnknownKeyException {
            return provider.promptOpenKey(true);
        }
    }

    private static class Reset
    extends State {
        private static final State STATE = new Reset();

        private Reset() {
        }

        @Override
        public Object getCreateKey(PromptingKeyProvider provider) throws UnknownKeyException {
            return provider.promptCreateKey();
        }

        @Override
        public Object getOpenKey(PromptingKeyProvider provider) throws UnknownKeyException {
            return provider.promptOpenKey(false);
        }

        @Override
        public void invalidOpenKey(PromptingKeyProvider provider) {
        }
    }

    private static abstract class State {
        private State() {
        }

        public abstract Object getCreateKey(PromptingKeyProvider var1) throws UnknownKeyException;

        public abstract Object getOpenKey(PromptingKeyProvider var1) throws UnknownKeyException;

        public void invalidOpenKey(PromptingKeyProvider provider) {
        }

        public void resetCancelledPrompt(PromptingKeyProvider provider) {
        }
    }
}

