/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.terracotta.agent.repkg.de.schlichtherle.io.InputArchiveMetaData;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.InputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32Entry;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.ReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.Paths;
import org.terracotta.agent.repkg.de.schlichtherle.util.zip.BasicZipFile;
import org.terracotta.agent.repkg.de.schlichtherle.util.zip.ZipEntry;

public class Zip32InputArchive
extends BasicZipFile
implements InputArchive {
    private InputArchiveMetaData metaData;

    public Zip32InputArchive(ReadOnlyFile rof, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(rof, charset, preambled, postambled);
    }

    @Override
    protected ZipEntry createZipEntry(String entryName) {
        return new Zip32Entry(Paths.normalize(entryName, '/'));
    }

    @Override
    public int getNumArchiveEntries() {
        return super.size();
    }

    @Override
    public Enumeration getArchiveEntries() {
        return super.entries();
    }

    @Override
    public ArchiveEntry getArchiveEntry(String entryName) {
        return (Zip32Entry)super.getEntry(entryName);
    }

    @Override
    public InputStream getInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        return super.getInputStream(entry.getName(), false, !(dstEntry instanceof Zip32Entry));
    }

    @Override
    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void setMetaData(InputArchiveMetaData metaData) {
        this.metaData = metaData;
    }
}

