/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import org.terracotta.agent.repkg.de.schlichtherle.io.Executor;
import org.terracotta.agent.repkg.de.schlichtherle.io.Task;

final class LegacyExecutor
implements Executor {
    private final String threadName;

    public LegacyExecutor(String threadName) {
        assert (threadName != null);
        this.threadName = threadName;
    }

    @Override
    public Task submit(Runnable target) {
        assert (target != null);
        return new LegacyTask(target, this.threadName);
    }

    private static final class LegacyTask
    implements Task {
        private final Thread thread;

        private LegacyTask(Runnable target, String threadName) {
            assert (target != null);
            assert (threadName != null);
            this.thread = new Thread(target, threadName);
            this.thread.start();
        }

        @Override
        public void cancel() {
            this.thread.interrupt();
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

