/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveControllers;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveFileSystem;
import org.terracotta.agent.repkg.de.schlichtherle.io.Entry;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.FileBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.FileFactory;
import org.terracotta.agent.repkg.de.schlichtherle.io.IORunnable;
import org.terracotta.agent.repkg.de.schlichtherle.io.ReentrantLock;
import org.terracotta.agent.repkg.de.schlichtherle.io.ReentrantReadWriteLock;
import org.terracotta.agent.repkg.de.schlichtherle.io.Streams;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.Archive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveDriver;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.TransientIOException;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingKeyManager;

abstract class ArchiveController
implements Archive,
Entry {
    private final WeakReference weakThis = new WeakReference<ArchiveController>(this);
    private final java.io.File target;
    private final ArchiveController enclController;
    private final String enclEntryName;
    private ArchiveDriver driver;
    private final ReentrantLock readLock;
    private final ReentrantLock writeLock;

    ArchiveController(java.io.File target, ArchiveController enclController, String enclEntryName, ArchiveDriver driver) {
        assert (target != null);
        assert (target.isAbsolute());
        assert (enclController != null == (enclEntryName != null));
        assert (driver != null);
        this.target = target;
        this.enclController = enclController;
        this.enclEntryName = enclEntryName;
        this.driver = driver;
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
        this.setScheduled(false);
    }

    final ReentrantLock readLock() {
        return this.readLock;
    }

    final ReentrantLock writeLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWriteLocked(IORunnable runnable) throws IOException {
        int lockCount;
        int c;
        for (c = lockCount = this.readLock().lockCount(); c > 0; --c) {
            this.readLock().unlock();
        }
        this.writeLock().lock();
        try {
            try {
                runnable.run();
            }
            finally {
                for (c = lockCount; c > 0; --c) {
                    this.readLock().lock();
                }
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final java.io.File getTarget() {
        return this.target;
    }

    @Override
    public final String getPath() {
        return this.target.getPath();
    }

    static final boolean isRoot(String entryName) {
        return "" == entryName;
    }

    final ArchiveController getEnclController() {
        return this.enclController;
    }

    final String getEnclEntryName() {
        return this.enclEntryName;
    }

    final String enclEntryName(String entryName) {
        return ArchiveController.isRoot(entryName) ? this.enclEntryName : this.enclEntryName + "/" + entryName;
    }

    private final boolean isEnclosedBy(ArchiveController wannabe) {
        assert (wannabe != null);
        if (this.enclController == wannabe) {
            return true;
        }
        if (this.enclController == null) {
            return false;
        }
        return this.enclController.isEnclosedBy(wannabe);
    }

    final ArchiveDriver getDriver() {
        return this.driver;
    }

    final void setDriver(ArchiveDriver driver) {
        this.driver = driver;
    }

    final boolean isRfsEntryTarget() {
        return this.enclController == null || this.enclController.getTarget().isDirectory();
    }

    abstract boolean isTouched();

    final void setScheduled(boolean scheduled) {
        assert (this.weakThis.get() != null || !scheduled);
        ArchiveControllers.set(this.getTarget(), scheduled ? this : this.weakThis);
    }

    abstract boolean hasNewData(String var1);

    abstract ArchiveFileSystem autoMount(boolean var1) throws IOException;

    final void autoUmount(String entryName) throws ArchiveException {
        assert (this.writeLock().isLocked());
        if (this.hasNewData(entryName)) {
            this.umount(null, true, false, true, false, false, false);
        }
    }

    abstract void umount(ArchiveException var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ArchiveException;

    abstract int waitAllInputStreamsByOtherThreads(long var1);

    abstract int waitAllOutputStreamsByOtherThreads(long var1);

    abstract void reset() throws IOException;

    public String toString() {
        return this.getClass().getName() + "@" + System.identityHashCode(this) + "(" + this.getPath() + ")";
    }

    final InputStream createInputStream(String entryName) throws FileNotFoundException {
        assert (entryName != null);
        try {
            return this.createInputStream0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.createInputStream(this.enclEntryName(entryName));
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (ArchiveBusyException ex) {
            throw new FileBusyException(ex);
        }
        catch (IOException ioe) {
            FileNotFoundException fnfe = new FileNotFoundException(ioe.toString());
            fnfe.initCause(ioe);
            throw fnfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream createInputStream0(final String entryName) throws IOException {
        assert (entryName != null);
        this.readLock().lock();
        try {
            ArchiveEntry entry;
            if (ArchiveController.isRoot(entryName)) {
                block10: {
                    try {
                        boolean directory = this.isDirectory0(entryName);
                        assert (directory) : "The root entry must be a directory!";
                    }
                    catch (FalsePositiveException ex) {
                        if (ex.getCause() instanceof FileNotFoundException) break block10;
                        throw ex;
                    }
                }
                throw new ArchiveEntryNotFoundException(entryName, "cannot read (potential) virtual root directory");
            }
            if (this.hasNewData(entryName)) {
                this.runWriteLocked(new IORunnable(){

                    @Override
                    public void run() throws IOException {
                        ArchiveController.this.autoUmount(entryName);
                    }
                });
            }
            if ((entry = this.autoMount(false).get(entryName)) == null) {
                throw new ArchiveEntryNotFoundException(entryName, "no such file entry");
            }
            InputStream inputStream = this.createInputStream(entry, null);
            return inputStream;
        }
        finally {
            this.readLock().unlock();
        }
    }

    abstract InputStream createInputStream(ArchiveEntry var1, ArchiveEntry var2) throws IOException;

    final OutputStream createOutputStream(String entryName, boolean append) throws FileNotFoundException {
        assert (entryName != null);
        try {
            return this.createOutputStream0(entryName, append);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.createOutputStream(this.enclEntryName(entryName), append);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (ArchiveBusyException ex) {
            throw new FileBusyException(ex);
        }
        catch (IOException ioe) {
            FileNotFoundException fnfe = new FileNotFoundException(ioe.toString());
            fnfe.initCause(ioe);
            throw fnfe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream createOutputStream0(String entryName, boolean append) throws IOException {
        OutputStream out;
        InputStream in;
        assert (entryName != null);
        this.writeLock().lock();
        try {
            if (ArchiveController.isRoot(entryName)) {
                block12: {
                    try {
                        boolean directory = this.isDirectory0(entryName);
                        assert (directory) : "The root entry must be a directory!";
                    }
                    catch (FalsePositiveException ex) {
                        if (ex.getCause() instanceof FileNotFoundException) break block12;
                        throw ex;
                    }
                }
                throw new ArchiveEntryNotFoundException(entryName, "cannot write (potential) virtual root directory");
            }
            this.autoUmount(entryName);
            boolean lenient = File.isLenient();
            ArchiveFileSystem fileSystem = this.autoMount(lenient);
            in = append && fileSystem.isFile(entryName) ? this.createInputStream0(entryName) : null;
            ArchiveFileSystem.Delta delta = fileSystem.link(entryName, lenient);
            out = this.createOutputStream(delta.getEntry(), null);
            delta.commit();
        }
        finally {
            this.writeLock().unlock();
        }
        if (in != null) {
            try {
                Streams.cat(in, out);
            }
            finally {
                in.close();
            }
        }
        return out;
    }

    abstract OutputStream createOutputStream(ArchiveEntry var1, ArchiveEntry var2) throws IOException;

    final boolean exists(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.exists0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.exists(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean exists0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.exists(entryName);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean isFile(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.isFile0(entryName);
        }
        catch (FileArchiveEntryFalsePositiveException ex) {
            if (ArchiveController.isRoot(entryName) && ex.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.enclController.isFile(this.enclEntryName(entryName));
        }
        catch (DirectoryArchiveEntryFalsePositiveException ex) {
            return this.enclController.isFile(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isFile0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.isFile(entryName);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean isDirectory(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.isDirectory0(entryName);
        }
        catch (FileArchiveEntryFalsePositiveException ex) {
            return false;
        }
        catch (DirectoryArchiveEntryFalsePositiveException ex) {
            return this.enclController.isDirectory(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isDirectory0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.isDirectory(entryName);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final Icon getOpenIcon(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.getOpenIcon0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.getOpenIcon(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Icon getOpenIcon0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            Icon icon = ArchiveController.isRoot(entryName) ? this.getDriver().getOpenIcon(this) : fileSystem.getOpenIcon(entryName);
            return icon;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final Icon getClosedIcon(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.getClosedIcon0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.getOpenIcon(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Icon getClosedIcon0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            Icon icon = ArchiveController.isRoot(entryName) ? this.getDriver().getClosedIcon(this) : fileSystem.getClosedIcon(entryName);
            return icon;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean canRead(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.canRead0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.canRead(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canRead0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.exists(entryName);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean canWrite(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.canWrite0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.canWrite(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canWrite0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.canWrite(entryName);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final long length(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.length0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.length(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long length0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            long l = fileSystem.length(entryName);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final long lastModified(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.lastModified0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.lastModified(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long lastModified0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            long l = fileSystem.lastModified(entryName);
            return l;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final String[] list(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.list0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.list(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] list0(String entryName) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            String[] stringArray = fileSystem.list(entryName);
            return stringArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final String[] list(String entryName, FilenameFilter filenameFilter, File dir) throws RfsEntryFalsePositiveException {
        try {
            return this.list0(entryName, filenameFilter, dir);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.list(this.enclEntryName(entryName), filenameFilter, dir);
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] list0(String entryName, FilenameFilter filenameFilter, File dir) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            String[] stringArray = fileSystem.list(entryName, filenameFilter, dir);
            return stringArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final File[] listFiles(String entryName, FilenameFilter filenameFilter, File dir, FileFactory factory) throws RfsEntryFalsePositiveException {
        try {
            return this.listFiles0(entryName, filenameFilter, dir, factory);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.listFiles(this.enclEntryName(entryName), filenameFilter, dir, factory);
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] listFiles0(String entryName, FilenameFilter filenameFilter, File dir, FileFactory factory) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            File[] fileArray = fileSystem.listFiles(entryName, filenameFilter, dir, factory);
            return fileArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final File[] listFiles(String entryName, FileFilter fileFilter, File dir, FileFactory factory) throws RfsEntryFalsePositiveException {
        try {
            return this.listFiles0(entryName, fileFilter, dir, factory);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.listFiles(this.enclEntryName(entryName), fileFilter, dir, factory);
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File[] listFiles0(String entryName, FileFilter fileFilter, File dir, FileFactory factory) throws IOException {
        this.readLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            File[] fileArray = fileSystem.listFiles(entryName, fileFilter, dir, factory);
            return fileArray;
        }
        finally {
            this.readLock().unlock();
        }
    }

    final boolean setReadOnly(String entryName) throws RfsEntryFalsePositiveException {
        try {
            return this.setReadOnly0(entryName);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.setReadOnly(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean setReadOnly0(String entryName) throws IOException {
        this.writeLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.setReadOnly(entryName);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean setLastModified(String entryName, long time) throws RfsEntryFalsePositiveException {
        try {
            return this.setLastModified0(entryName, time);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.setLastModified(this.enclEntryName(entryName), time);
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean setLastModified0(String entryName, long time) throws IOException {
        this.writeLock().lock();
        try {
            this.autoUmount(entryName);
            ArchiveFileSystem fileSystem = this.autoMount(false);
            boolean bl = fileSystem.setLastModified(entryName, time);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean createNewFile(String entryName, boolean autoCreate) throws IOException {
        try {
            return this.createNewFile0(entryName, autoCreate);
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.createNewFile(this.enclEntryName(entryName), autoCreate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean createNewFile0(String entryName, boolean autoCreate) throws IOException {
        assert (!ArchiveController.isRoot(entryName));
        this.writeLock().lock();
        try {
            ArchiveFileSystem fileSystem = this.autoMount(autoCreate);
            if (fileSystem.exists(entryName)) {
                boolean bl = false;
                return bl;
            }
            this.createOutputStream0(entryName, false).close();
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean mkdir(String entryName, boolean autoCreate) throws RfsEntryFalsePositiveException {
        try {
            this.mkdir0(entryName, autoCreate);
            return true;
        }
        catch (ArchiveEntryFalsePositiveException ex) {
            return this.enclController.mkdir(this.enclEntryName(entryName), autoCreate);
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mkdir0(String entryName, boolean autoCreate) throws IOException {
        this.writeLock().lock();
        try {
            if (ArchiveController.isRoot(entryName)) {
                if (this.isRfsEntryTarget() ? this.target.exists() : this.enclController.exists(this.enclEntryName)) {
                    throw new IOException("target file exists already!");
                }
                this.autoMount(true);
            } else {
                ArchiveFileSystem fileSystem = this.autoMount(autoCreate);
                fileSystem.mkdir(entryName, autoCreate);
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    final boolean delete(String entryName) throws RfsEntryFalsePositiveException {
        try {
            this.delete0(entryName);
            return true;
        }
        catch (DirectoryArchiveEntryFalsePositiveException ex) {
            return this.enclController.delete(this.enclEntryName(entryName));
        }
        catch (FileArchiveEntryFalsePositiveException ex) {
            if (ArchiveController.isRoot(entryName) && !this.enclController.isDirectory(this.enclEntryName(entryName)) && ex.getCause() instanceof FileNotFoundException) {
                return false;
            }
            return this.enclController.delete(this.enclEntryName(entryName));
        }
        catch (RfsEntryFalsePositiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void delete0(String entryName) throws IOException {
        block14: {
            this.writeLock().lock();
            try {
                this.autoUmount(entryName);
                if (ArchiveController.isRoot(entryName)) {
                    ArchiveFileSystem fileSystem;
                    try {
                        fileSystem = this.autoMount(false);
                    }
                    catch (FalsePositiveException ex) {
                        try {
                            this.reset();
                        }
                        catch (IOException cannotHappen) {
                            throw new AssertionError((Object)cannotHappen);
                        }
                        throw ex;
                    }
                    String[] members = fileSystem.list(entryName);
                    if (members != null && members.length != 0) {
                        throw new IOException("archive file system not empty!");
                    }
                    int outputStreams = this.waitAllOutputStreamsByOtherThreads(50L);
                    assert (outputStreams <= 0) : "Entries for open output streams should not be deletable!";
                    int inputStreams = this.waitAllInputStreamsByOtherThreads(50L);
                    if (inputStreams > 0 || outputStreams > 0) {
                        throw new IOException("archive file has open streams!");
                    }
                    this.reset();
                    PromptingKeyManager.resetKeyProvider(this.getPath());
                    if (this.isRfsEntryTarget()) {
                        if (!this.target.delete()) {
                            throw new IOException("couldn't delete archive file!");
                        }
                    } else {
                        this.enclController.delete0(this.enclEntryName(entryName));
                    }
                    break block14;
                }
                ArchiveFileSystem fileSystem = this.autoMount(false);
                fileSystem.delete(entryName);
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }

    final class ArchiveEntryNotFoundException
    extends FileNotFoundException {
        private final String entryName;

        ArchiveEntryNotFoundException(String entryName, String msg) {
            super(msg);
            assert (entryName != null);
            assert (msg != null);
            this.entryName = entryName;
        }

        @Override
        public String getMessage() {
            String msg;
            String path = ArchiveController.this.getPath();
            if (!ArchiveController.isRoot(this.entryName)) {
                path = path + File.separator + this.entryName.replace('/', File.separatorChar);
            }
            if ((msg = super.getMessage()) != null) {
                path = path + " (" + msg + ")";
            }
            return path;
        }
    }

    final class ArchiveFileNotFoundException
    extends FileNotFoundException {
        ArchiveFileNotFoundException(String msg) {
            super(msg);
        }

        @Override
        public String getMessage() {
            String msg = super.getMessage();
            if (msg != null) {
                return ArchiveController.this.getPath() + " (" + msg + ")";
            }
            return ArchiveController.this.getPath();
        }
    }

    final class DirectoryArchiveEntryFalsePositiveException
    extends ArchiveEntryFalsePositiveException {
        DirectoryArchiveEntryFalsePositiveException(ArchiveController enclController, String enclEntryName, IOException cause) {
            super(enclController, enclEntryName, cause);
        }
    }

    final class FileArchiveEntryFalsePositiveException
    extends ArchiveEntryFalsePositiveException {
        FileArchiveEntryFalsePositiveException(ArchiveController enclController, String enclEntryName, IOException cause) {
            super(enclController, enclEntryName, cause);
        }
    }

    abstract class ArchiveEntryFalsePositiveException
    extends FalsePositiveException {
        private final ArchiveController enclController;
        private final String enclEntryName;

        private ArchiveEntryFalsePositiveException(ArchiveController enclController, String enclEntryName, IOException cause) {
            super(cause);
            assert (enclController != ArchiveController.this);
            assert (ArchiveController.this.isEnclosedBy(enclController));
            assert (enclEntryName != null);
            this.enclController = enclController;
            this.enclEntryName = enclEntryName;
        }

        ArchiveController getEnclController() {
            return this.enclController;
        }

        String getEnclEntryName() {
            return this.enclEntryName;
        }
    }

    final class RfsEntryFalsePositiveException
    extends FalsePositiveException {
        RfsEntryFalsePositiveException(IOException cause) {
            super(cause);
        }
    }

    abstract class FalsePositiveException
    extends FileNotFoundException {
        private final boolean cacheable;

        private FalsePositiveException(IOException cause) {
            assert (cause != null);
            boolean trans = cause instanceof TransientIOException;
            super.initCause(trans ? cause.getCause() : cause);
            this.cacheable = !trans;
        }

        ArchiveController getController() {
            return ArchiveController.this;
        }

        boolean isCacheable() {
            return this.cacheable;
        }
    }
}

