/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.express.loader;

import com.terracotta.express.loader.Jar;
import com.terracotta.express.loader.JarManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Handler
extends URLStreamHandler {
    public static final String TAG = "__TC__";
    public static final String TC_JAR_PROTOCOL = "tcjar";
    private static final IOException NO_SUCH_RESOURCE_EXCEPTION = new IOException("no such resource");
    private final JarManager jarManager;

    public Handler(JarManager jarManager) {
        this.jarManager = jarManager;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        Jar jar;
        String proto = url.getProtocol();
        if (!TC_JAR_PROTOCOL.equals(proto)) {
            throw new IOException("unexpected protocol: " + url);
        }
        String path = url.getPath();
        if (!path.startsWith(TAG)) {
            throw new IOException("unexpected path: " + path);
        }
        int end = (path = path.substring(TAG.length())).indexOf(TAG);
        if (end <= 0) {
            throw new IOException("unexpected path: " + path);
        }
        String jarKey = path.substring(0, end);
        String resource = path.substring(end + TAG.length());
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        if ((jar = this.jarManager.get(jarKey)) == null) {
            throw new IOException("No source for: " + url);
        }
        if (resource.length() == 0) {
            return new Connection(url, jar.contents());
        }
        byte[] data = jar.lookup(resource);
        if (data == null) {
            throw NO_SUCH_RESOURCE_EXCEPTION;
        }
        return new Connection(url, data);
    }

    private static class Connection
    extends URLConnection {
        private final byte[] content;

        public Connection(URL url, byte[] content) {
            super(url);
            this.content = content;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }
    }
}

