/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.text.ParseException;

public class ClassUtils {
    public static ClassSpec parseFullyQualifiedFieldName(String fieldName) throws ParseException {
        ClassSpecImpl rv = new ClassSpecImpl();
        rv.parseFullyQualifiedFieldName(fieldName);
        return rv;
    }

    public static int arrayDimensions(Class arrayClass) {
        ClassUtils.verifyIsArray(arrayClass);
        return arrayClass.getName().lastIndexOf("[") + 1;
    }

    public static Class baseComponentType(Class c) {
        ClassUtils.verifyIsArray(c);
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    private static void verifyIsArray(Class arrayClass) {
        if (arrayClass == null) {
            throw new NullPointerException();
        }
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException(arrayClass + " is not an array type");
        }
    }

    public static boolean isPrimitiveArray(Object test) {
        if (test == null) {
            return false;
        }
        Class<?> c = test.getClass();
        if (!c.isArray()) {
            return false;
        }
        return c.getComponentType().isPrimitive();
    }

    public static boolean isDsoEnum(Class c) {
        while (c.getSuperclass() != null) {
            if (c.isEnum()) {
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static void validatePackageOfInvokedClass(String className) {
        if (!className.startsWith("com.tc.")) {
            throw new RuntimeException("Invalid class invocation : " + className);
        }
    }

    private static class ClassSpecImpl
    implements ClassSpec {
        private String fullyQualifiedClassName;
        private String shortFieldName;

        private ClassSpecImpl() {
        }

        private void parseFullyQualifiedFieldName(String fieldName) throws ParseException {
            int lastDot;
            if (fieldName == null) {
                this.throwNotFullyQualifiedFieldName(null, 0);
            }
            if ((lastDot = fieldName.lastIndexOf(46)) <= 0) {
                this.throwNotFullyQualifiedFieldName(fieldName, 0);
            }
            if (lastDot + 1 == fieldName.length()) {
                this.throwNotFullyQualifiedFieldName(fieldName, lastDot);
            }
            this.fullyQualifiedClassName = fieldName.substring(0, lastDot);
            this.shortFieldName = fieldName.substring(lastDot + 1);
        }

        private void throwNotFullyQualifiedFieldName(String fieldName, int position) throws ParseException {
            throw new ParseException("Not a fully qualified fieldname: " + fieldName, position);
        }

        @Override
        public String getFullyQualifiedClassName() {
            return this.fullyQualifiedClassName;
        }

        @Override
        public String getShortFieldName() {
            return this.shortFieldName;
        }

        public String toString() {
            return "ClassSpec[classname=" + this.fullyQualifiedClassName + ", shortFieldName=" + this.shortFieldName + "]";
        }
    }

    public static interface ClassSpec {
        public String getFullyQualifiedClassName();

        public String getShortFieldName();
    }
}

