/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.StringUtil;
import com.tc.util.TCAssertionError;
import java.util.Arrays;
import java.util.Collection;

public class Assert {
    private static final String ASSERT_PROPERTY_NAME = "tcassert";
    private static final boolean enabled = Boolean.valueOf(System.getProperty("tcassert", "true"));

    private static boolean isEnabled() {
        return enabled;
    }

    public static TCAssertionError failure(Object message, Throwable t) {
        return new TCAssertionError(StringUtil.safeToString(message), t);
    }

    public static TCAssertionError failure(Object message) {
        return new TCAssertionError(StringUtil.safeToString(message));
    }

    public static void eval(boolean expr) {
        if (!expr && Assert.isEnabled()) {
            throw Assert.failure("Assertion failed");
        }
    }

    public static void eval(Object message, boolean expr) {
        if (!expr && Assert.isEnabled()) {
            throw Assert.failure("Assertion failed: " + StringUtil.safeToString(message));
        }
    }

    public static void assertTrue(boolean expr) {
        Assert.eval(expr);
    }

    public static void assertTrue(Object message, boolean expr) {
        Assert.eval(message, expr);
    }

    public static void assertFalse(boolean expr) {
        Assert.eval(!expr);
    }

    public static void assertFalse(Object message, boolean expr) {
        Assert.eval(message, !expr);
    }

    public static void assertNull(Object o) {
        Assert.assertNull("object", o);
    }

    public static void assertNull(Object what, Object o) {
        if (o != null && Assert.isEnabled()) {
            throw Assert.failure(StringUtil.safeToString(what) + " was not null");
        }
    }

    public static void assertNotNull(Object what, Object o) {
        if (o == null && Assert.isEnabled()) {
            throw new NullPointerException(StringUtil.safeToString(what) + " is null");
        }
    }

    public static void assertNotNull(Object o) {
        Assert.assertNotNull("object", o);
    }

    public static void assertNoNullElements(Object[] array) {
        if (!Assert.isEnabled()) {
            return;
        }
        Assert.assertNotNull(array);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertNotNull("item " + i, array[i]);
        }
    }

    public static void assertNoBlankElements(String[] array) {
        if (!Assert.isEnabled()) {
            return;
        }
        Assert.assertNotNull(array);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertNotBlank(array[i]);
        }
    }

    public static void assertNotEmpty(Object what, String s) {
        Assert.assertNotNull(what, s);
        if (s.length() == 0 && Assert.isEnabled()) {
            throw new IllegalArgumentException(StringUtil.safeToString(what) + " is empty");
        }
    }

    public static void assertNotEmpty(String s) {
        Assert.assertNotEmpty("string", s);
    }

    public static void assertNotBlank(Object what, String s) {
        Assert.assertNotEmpty(what, s);
        if (s.trim().length() == 0 && Assert.isEnabled()) {
            throw new IllegalArgumentException(StringUtil.safeToString(what) + " is blank");
        }
    }

    public static void assertNotBlank(String s) {
        Assert.assertNotBlank("string", s);
    }

    public static void assertSame(Object lhs, Object rhs) {
        if (lhs == null) {
            Assert.eval("leftHandSide == null, but rightHandSide != null", rhs == null);
        } else {
            Assert.eval("leftHandSide != null, but rightHandSide == null", rhs != null);
            Assert.eval("leftHandSide != rightHandSide", lhs == rhs);
        }
    }

    public static void assertEquals(int expected, int actual) {
        if (expected != actual && Assert.isEnabled()) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(Object msg, int expected, int actual) {
        if (expected != actual && Assert.isEnabled()) {
            throw new TCAssertionError(msg + ": Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(double expected, double actual) {
        if (expected != actual && Assert.isEnabled()) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(double expected, double actual, double epsilon) {
        if (Math.abs(actual - expected) > Math.abs(epsilon) && Assert.isEnabled()) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(boolean expected, boolean actual) {
        if (expected != actual && Assert.isEnabled()) {
            throw new TCAssertionError("Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        boolean expr;
        boolean bl = expected == null ? actual == null : (expr = Arrays.equals(expected, actual));
        if (!expr && Assert.isEnabled()) {
            throw new TCAssertionError("Got differing byte[]s");
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(Object msg, Object expected, Object actual) {
        boolean expr;
        boolean bl = expected == null ? actual == null : (expr = expected.equals(actual));
        if (!expr && Assert.isEnabled()) {
            throw new TCAssertionError((String)(msg != null ? msg + ": " : "") + "Expected <" + expected + "> but got <" + actual + ">");
        }
    }

    public static void assertConsistentCollection(Collection collection, Class elementClass, boolean allowNullElements) {
        Assert.assertNotNull("Collection", collection);
        Assert.assertNotNull("Element class", elementClass);
        for (Object element : collection) {
            if (!allowNullElements) {
                Assert.assertNotNull(element);
            }
            if (element == null) continue;
            Assert.eval("Element '" + element + "' is not an instance of '" + elementClass.getName() + "'", elementClass.isInstance(element));
        }
    }

    public static void assertContainsElement(Object[] objectArray, Object requiredElement) {
        Assert.assertNotNull(objectArray);
        for (int pos = 0; pos < objectArray.length; ++pos) {
            if (objectArray[pos] != requiredElement) continue;
            return;
        }
        if (Assert.isEnabled()) {
            throw Assert.failure("Element<" + requiredElement + "> not found in array " + StringUtil.toString(objectArray, ",", "<", ">"));
        }
    }

    public static void assertDoesNotContainsElement(Object[] objectArray, Object element) {
        Assert.assertNotNull(objectArray);
        for (int pos = 0; pos < objectArray.length; ++pos) {
            if (objectArray[pos] != element) continue;
            Assert.failure("Element<" + element + "> was found in array " + StringUtil.toString(objectArray, ",", "<", ">"));
        }
    }

    public static void fail() {
        if (Assert.isEnabled()) {
            throw Assert.failure("generic failure");
        }
    }

    public static void fail(String message) {
        if (Assert.isEnabled()) {
            throw Assert.failure(message);
        }
    }

    public static void pre(boolean v) {
        if (!v && Assert.isEnabled()) {
            throw new TCAssertionError("Precondition failed");
        }
    }

    public static void post(boolean v) {
        if (!v && Assert.isEnabled()) {
            throw new TCAssertionError("Postcondition failed");
        }
    }

    public static void inv(boolean v) {
        if (!v && Assert.isEnabled()) {
            throw new TCAssertionError("Invariant failed");
        }
    }
}

