/*
 * Decompiled with CFR 0.152.
 */
package com.tc.server;

import com.tc.server.ServerEventType;
import com.tc.server.VersionedServerEvent;
import java.util.Arrays;

public final class BasicServerEvent
implements VersionedServerEvent {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final String cacheName;
    private final Object key;
    private final long version;
    private ServerEventType type;
    private byte[] value;

    public BasicServerEvent(ServerEventType type, Object key, String cacheName) {
        this(type, key, EMPTY_BYTE_ARRAY, -1L, cacheName);
    }

    public BasicServerEvent(ServerEventType type, Object key, byte[] value, String cacheName) {
        this(type, key, value, -1L, cacheName);
    }

    public BasicServerEvent(ServerEventType type, Object key, long version, String cacheName) {
        this(type, key, EMPTY_BYTE_ARRAY, version, cacheName);
    }

    public BasicServerEvent(ServerEventType type, Object key, byte[] value, long version, String cacheName) {
        this.type = type;
        this.key = key;
        this.value = value;
        this.cacheName = cacheName;
        this.version = version;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public ServerEventType getType() {
        return this.type;
    }

    @Override
    public void setType(ServerEventType type) {
        this.type = type;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicServerEvent that = (BasicServerEvent)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.cacheName.equals(that.cacheName)) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.cacheName.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.value != null ? Arrays.hashCode(this.value) : 0);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public String toString() {
        return "ServerEvent{type=" + this.type + ", key=" + this.key + ", value size=" + this.value.length + ", version=" + this.version + ", cacheName='" + this.cacheName + "'}";
    }
}

