/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.tx;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLoggingService;
import com.tc.net.NodeID;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.MetaDataReader;
import com.tc.object.dna.impl.DNAImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.object.locks.NotifyImpl;
import com.tc.object.tx.ServerTransactionID;
import com.tc.object.tx.TransactionID;
import com.tc.object.tx.TxnBatchID;
import com.tc.object.tx.TxnType;
import com.tc.objectserver.tx.ServerTransaction;
import com.tc.objectserver.tx.ServerTransactionFactory;
import com.tc.objectserver.tx.TransactionBatchReader;
import com.tc.util.SequenceID;
import com.tc.util.ServiceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class TransactionBatchReaderImpl
implements TransactionBatchReader {
    private static final TCLogger logger = ServiceUtil.loadService(TCLoggingService.class).getLogger(TransactionBatchReaderImpl.class);
    private static final int HEADER_SIZE = 13;
    private final TCByteBufferInputStream in;
    private final TxnBatchID batchID;
    private final NodeID source;
    private final int numTxns;
    private int txnToRead;
    private final ObjectStringSerializer serializer;
    private final ServerTransactionFactory txnFactory;
    private final LinkedHashMap<TransactionID, MarkInfo> marks = new LinkedHashMap();
    private final TCByteBuffer[] data;
    private final boolean containsSyncWriteTransaction;

    public TransactionBatchReaderImpl(TCByteBuffer[] data, NodeID nodeID, ObjectStringSerializer serializer, ServerTransactionFactory txnFactory, TransactionSizeCounterCallback counterCallback) throws IOException {
        this.data = data;
        this.txnFactory = txnFactory;
        this.in = new TCByteBufferInputStream(data);
        this.source = nodeID;
        this.batchID = new TxnBatchID(this.in.readLong());
        this.txnToRead = this.numTxns = this.in.readInt();
        this.serializer = serializer;
        this.containsSyncWriteTransaction = this.in.readBoolean();
        if (counterCallback != null) {
            counterCallback.increment(this.in.getTotalLength(), this.numTxns);
        }
    }

    @Override
    public boolean containsSyncWriteTransaction() {
        return this.containsSyncWriteTransaction;
    }

    private TCByteBuffer[] getHeaderBuffers(int txnsCount) {
        TCByteBufferOutputStream tos = new TCByteBufferOutputStream(13, false);
        tos.writeLong(this.batchID.toLong());
        tos.writeInt(txnsCount);
        tos.writeBoolean(this.containsSyncWriteTransaction);
        return tos.toArray();
    }

    private long[] readLongArray(TCByteBufferInputStream input) throws IOException {
        int size = input.readInt();
        long[] larray = new long[size];
        for (int i = 0; i < larray.length; ++i) {
            larray[i] = input.readLong();
        }
        return larray;
    }

    @Override
    public NodeID getNodeID() {
        return this.source;
    }

    @Override
    public ServerTransaction getNextTransaction() throws IOException {
        if (this.txnToRead == 0) {
            int bytesRemaining = this.in.available();
            if (bytesRemaining != 0) {
                throw new IOException(bytesRemaining + " bytes remaining (expecting 0)");
            }
            return null;
        }
        TCByteBufferInput.Mark start = this.in.mark();
        TransactionID txnID = new TransactionID(this.in.readLong());
        TxnType txnType = TxnType.typeFor(this.in.readByte());
        int numApplictionTxn = this.in.readInt();
        SequenceID sequenceID = new SequenceID(this.in.readLong());
        boolean isEviction = this.in.readBoolean();
        int numLocks = this.in.readInt();
        LockID[] locks = new LockID[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            LockIDSerializer lidsr = new LockIDSerializer();
            locks[i] = ((LockIDSerializer)lidsr.deserializeFrom(this.in)).getLockID();
        }
        HashMap<String, ObjectID> newRoots = new HashMap<String, ObjectID>();
        int numNewRoots = this.in.readInt();
        for (int i = 0; i < numNewRoots; ++i) {
            String name = this.in.readString();
            ObjectID id = new ObjectID(this.in.readLong());
            newRoots.put(name, id);
        }
        LinkedList<NotifyImpl> notifies = new LinkedList<NotifyImpl>();
        int numNotifies = this.in.readInt();
        for (int i = 0; i < numNotifies; ++i) {
            NotifyImpl n = new NotifyImpl();
            n.deserializeFrom(this.in);
            notifies.add(n);
        }
        long[] highwaterMarks = this.readLongArray(this.in);
        ArrayList<DNAImpl> dnas = new ArrayList<DNAImpl>();
        int numDNA = this.in.readInt();
        ArrayList<MetaDataReader> metaDataReaders = new ArrayList<MetaDataReader>();
        for (int i = 0; i < numDNA; ++i) {
            DNAImpl dna = new DNAImpl(this.serializer, true);
            dna.deserializeFrom(this.in);
            if (dna.getMetaDataReader() != DNAImpl.NULL_META_DATA_READER) {
                metaDataReaders.add(dna.getMetaDataReader());
            }
            if (dna.isDelta() && dna.getActionCount() < 1) {
                logger.warn("received delta dna with no actions: " + dna);
            }
            dnas.add(dna);
        }
        TCByteBufferInput.Mark end = this.in.mark();
        this.marks.put(txnID, new MarkInfo(this.numTxns - this.txnToRead, start, end));
        --this.txnToRead;
        MetaDataReader[] metaDataReadersArr = metaDataReaders.toArray(new MetaDataReader[metaDataReaders.size()]);
        return this.txnFactory.createServerTransaction(this.getBatchID(), txnID, sequenceID, isEviction, locks, this.source, dnas, this.serializer, newRoots, txnType, notifies, metaDataReadersArr, numApplictionTxn, highwaterMarks);
    }

    @Override
    public TxnBatchID getBatchID() {
        return this.batchID;
    }

    @Override
    public int getNumberForTxns() {
        return this.numTxns;
    }

    @Override
    public TCByteBuffer[] getBackingBuffers() {
        return this.data;
    }

    @Override
    public TCByteBuffer[] getBackingBuffers(ServerTransactionID from, ServerTransactionID to) {
        if (!from.getSourceID().equals(this.source) || !to.getSourceID().equals(this.source)) {
            throw new AssertionError((Object)("Source is not the same : " + this.source + " : " + from + " , " + to));
        }
        MarkInfo fromMark = this.marks.get(from.getClientTransactionID());
        MarkInfo toMark = this.marks.get(to.getClientTransactionID());
        if (fromMark.getIndex() > toMark.getIndex()) {
            throw new AssertionError((Object)("From Tid " + from + " is after To Tid : " + to));
        }
        int noOfTxn = toMark.getIndex() - fromMark.getIndex() + 1;
        if (noOfTxn == this.numTxns) {
            return this.getBackingBuffers();
        }
        TCByteBuffer[] header = this.getHeaderBuffers(noOfTxn);
        TCByteBuffer[] content = this.in.toArray(fromMark.getStart(), toMark.getEnd());
        TCByteBuffer[] fullContents = new TCByteBuffer[header.length + content.length];
        System.arraycopy(header, 0, fullContents, 0, header.length);
        System.arraycopy(content, 0, fullContents, header.length, content.length);
        return fullContents;
    }

    @Override
    public ObjectStringSerializer getSerializer() {
        return this.serializer;
    }

    private static final class MarkInfo {
        private final TCByteBufferInput.Mark start;
        private final int index;
        private final TCByteBufferInput.Mark end;

        public MarkInfo(int index, TCByteBufferInput.Mark start, TCByteBufferInput.Mark end) {
            this.index = index;
            this.start = start;
            this.end = end;
        }

        public TCByteBufferInput.Mark getStart() {
            return this.start;
        }

        public TCByteBufferInput.Mark getEnd() {
            return this.end;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static interface TransactionSizeCounterCallback {
        public void increment(long var1, long var3);
    }
}

