/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.tx;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.api.DNAInternal;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.api.LiteralAction;
import com.tc.object.dna.api.LogicalAction;
import com.tc.object.dna.api.PhysicalAction;
import com.tc.object.dna.impl.DNAWriterImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.StorageDNAEncodingImpl;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.object.locks.Notify;
import com.tc.object.metadata.MetaDataDescriptorInternal;
import com.tc.object.tx.TxnBatchID;
import com.tc.object.tx.TxnType;
import com.tc.objectserver.tx.ServerTransaction;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ServerTransactionBatchWriter {
    private static final DNAEncodingInternal DNA_STORAGE_ENCODING = new StorageDNAEncodingImpl();
    private final ObjectStringSerializer serializer;
    private final TxnBatchID batchId;

    public ServerTransactionBatchWriter(TxnBatchID batchId, ObjectStringSerializer serializer) {
        this.batchId = batchId;
        this.serializer = serializer;
    }

    public TCByteBuffer[] writeTransactionBatch(List<ServerTransaction> txns) throws IOException, ClassNotFoundException {
        TCByteBufferOutputStream out = new TCByteBufferOutputStream(32, 4096, false);
        out.writeLong(this.batchId.toLong());
        out.writeInt(txns.size());
        out.writeBoolean(this.containsSyncWriteTransaction(txns));
        for (ServerTransaction serverTransaction : txns) {
            this.writeTransaction(out, serverTransaction);
        }
        return out.toArray();
    }

    private void writeTransaction(TCByteBufferOutputStream out, ServerTransaction txn) throws IOException, ClassNotFoundException {
        out.writeLong(txn.getTransactionID().toLong());
        out.writeByte(txn.getTransactionType().getType());
        out.writeInt(txn.getNumApplicationTxn());
        out.writeLong(txn.getClientSequenceID().toLong());
        out.writeBoolean(txn.isEviction());
        this.writeLockIDs(out, txn.getLockIDs());
        this.writeRootsMap(out, txn.getNewRoots());
        this.writeNotifies(out, txn.getNotifies());
        this.writeHighWaterMarks(out, txn.getHighWaterMarks());
        this.writeDNAs(out, txn.getChanges());
    }

    private void writeDNAs(TCByteBufferOutputStream out, List changes) throws IOException, ClassNotFoundException {
        out.writeInt(changes.size());
        for (DNAInternal dna : changes) {
            this.writeDNA(out, dna);
        }
    }

    private void writeDNA(TCByteBufferOutputStream out, DNAInternal dna) throws IOException, ClassNotFoundException {
        DNAWriterImpl dnaWriter = new DNAWriterImpl(out, dna.getObjectID(), dna.getTypeName(), this.serializer, DNA_STORAGE_ENCODING, dna.isDelta());
        this.writeParentObjectID(dnaWriter, dna.getParentObjectID());
        DNACursor cursor = dna.getCursor();
        this.addActions(dnaWriter, cursor, DNA_STORAGE_ENCODING, dna);
        for (MetaDataDescriptorInternal mdd : dna.getMetaDataReader()) {
            dnaWriter.addMetaData(mdd);
        }
        dnaWriter.markSectionEnd();
        dnaWriter.finalizeHeader();
    }

    private void addActions(DNAWriter dnaWriter, DNACursor cursor, DNAEncoding decoder, DNA dna) throws IOException, ClassNotFoundException {
        while (cursor.next(decoder)) {
            Object action = cursor.getAction();
            if (action instanceof PhysicalAction) {
                this.writePhysicalAction(dnaWriter, (PhysicalAction)action);
                continue;
            }
            if (action instanceof LogicalAction) {
                this.writeLogicalAction(dnaWriter, (LogicalAction)action);
                continue;
            }
            if (action instanceof LiteralAction) {
                this.writeLiteralAction(dnaWriter, (LiteralAction)action);
                continue;
            }
            throw new AssertionError((Object)("Unknown action type : " + action + " in dna : " + dna));
        }
    }

    private void writeParentObjectID(DNAWriter dnaWriter, ObjectID parentObjectID) {
        if (!parentObjectID.isNull()) {
            dnaWriter.setParentObjectID(parentObjectID);
        }
    }

    private void writeLiteralAction(DNAWriter dnaWriter, LiteralAction action) {
        dnaWriter.addLiteralValue(action.getObject());
    }

    private void writeLogicalAction(DNAWriter dnaWriter, LogicalAction action) {
        dnaWriter.addLogicalAction(action.getLogicalOperation(), action.getParameters());
    }

    private void writePhysicalAction(DNAWriter dnaWriter, PhysicalAction action) {
        if (action.isTruePhysical()) {
            dnaWriter.addPhysicalAction(action.getFieldName(), action.getObject(), action.isReference());
        } else if (action.isArrayElement()) {
            dnaWriter.addArrayElementAction(action.getArrayIndex(), action.getObject());
        } else if (action.isEntireArray()) {
            dnaWriter.setArrayLength(Array.getLength(action.getObject()));
            dnaWriter.addEntireArray(action.getObject());
        } else if (action.isSubArray()) {
            dnaWriter.addSubArrayAction(action.getArrayIndex(), action.getObject(), Array.getLength(action.getObject()));
        } else {
            throw new AssertionError((Object)("Unknown Physical Action : " + action));
        }
    }

    private void writeHighWaterMarks(TCByteBufferOutputStream out, long[] highWaterMarks) {
        out.writeInt(highWaterMarks.length);
        for (long h : highWaterMarks) {
            out.writeLong(h);
        }
    }

    private void writeNotifies(TCByteBufferOutputStream out, Collection notifies) {
        out.writeInt(notifies.size());
        for (Notify n : notifies) {
            n.serializeTo(out);
        }
    }

    private void writeRootsMap(TCByteBufferOutputStream out, Map newRoots) {
        out.writeInt(newRoots.size());
        for (Map.Entry e : newRoots.entrySet()) {
            out.writeString((String)e.getKey());
            out.writeLong(((ObjectID)e.getValue()).toLong());
        }
    }

    private void writeLockIDs(TCByteBufferOutputStream out, LockID[] lockIDs) {
        out.writeInt(lockIDs.length);
        for (LockID lockID : lockIDs) {
            LockIDSerializer lidsr = new LockIDSerializer(lockID);
            lidsr.serializeTo(out);
        }
    }

    private boolean containsSyncWriteTransaction(List<ServerTransaction> txns) {
        for (ServerTransaction serverTransaction : txns) {
            if (serverTransaction.getTransactionType() != TxnType.SYNC_WRITE) continue;
            return true;
        }
        return false;
    }
}

