/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.tx;

import com.tc.io.TCByteBufferOutput;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.MetaDataReader;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.UTF8ByteDataHolder;
import com.tc.object.metadata.MetaDataDescriptorInternal;
import com.tc.object.metadata.NVPairSerializer;
import com.tc.objectserver.api.EvictableEntry;
import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.SearchCommand;
import com.terracottatech.search.SearchMetaData;
import com.terracottatech.search.ValueID;
import java.sql.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class RemoveAllMetaDataReader
implements MetaDataReader {
    private static final NVPairSerializer NVPAIR_SERIALIZER = new NVPairSerializer();
    private final String cacheName;
    private final Map<Object, EvictableEntry> candidates;
    private final ObjectID oid;

    public RemoveAllMetaDataReader(ObjectID oid, String cacheName, Map<Object, EvictableEntry> candidates) {
        this.cacheName = cacheName;
        this.candidates = candidates;
        this.oid = oid;
    }

    @Override
    public Iterator<MetaDataDescriptorInternal> iterator() {
        return new RemoveIterator();
    }

    private class RemoveIterator
    implements Iterator<MetaDataDescriptorInternal>,
    MetaDataDescriptorInternal {
        private boolean nextCalled = false;

        private RemoveIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.nextCalled;
        }

        @Override
        public MetaDataDescriptorInternal next() {
            if (this.nextCalled) {
                throw new NoSuchElementException();
            }
            this.nextCalled = true;
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, short value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, java.util.Date value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Date value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Enum value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, byte[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(String name, ObjectID value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addNull(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(String name, Object newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCategory() {
            return "SEARCH";
        }

        @Override
        public void serializeTo(TCByteBufferOutput out, ObjectStringSerializer serializer) {
            serializer.writeString(out, this.getCategory());
            out.writeLong(RemoveAllMetaDataReader.this.oid.toLong());
            out.writeInt(this.numberOfNvPairs());
            NVPAIR_SERIALIZER.serialize((NVPair)new AbstractNVPair.StringNVPair(SearchMetaData.CACHENAME.toString(), RemoveAllMetaDataReader.this.cacheName), out, serializer);
            NVPAIR_SERIALIZER.serialize((NVPair)new AbstractNVPair.EnumNVPair(SearchMetaData.COMMAND.toString(), (Enum)SearchCommand.REMOVE_IF_VALUE_EQUAL), out, serializer);
            NVPAIR_SERIALIZER.serialize((NVPair)new AbstractNVPair.IntNVPair("", (this.numberOfNvPairs() - 3) / 2), out, serializer);
            for (Map.Entry<Object, EvictableEntry> e : RemoveAllMetaDataReader.this.candidates.entrySet()) {
                String key = e.getKey() instanceof UTF8ByteDataHolder ? ((UTF8ByteDataHolder)e.getKey()).asString() : e.getKey().toString();
                ObjectID value = e.getValue().getObjectID();
                NVPAIR_SERIALIZER.serialize((NVPair)new AbstractNVPair.StringNVPair("", key), out, serializer);
                NVPAIR_SERIALIZER.serialize((NVPair)new AbstractNVPair.ValueIdNVPair("", new ValueID(value.toLong())), out, serializer);
            }
        }

        @Override
        public Iterator<NVPair> getMetaDatas() {
            return new RemoveMetaDataIterator(this.numberOfNvPairs());
        }

        @Override
        public int numberOfNvPairs() {
            return 3 + RemoveAllMetaDataReader.this.candidates.size() * 2;
        }

        @Override
        public ObjectID getObjectId() {
            return RemoveAllMetaDataReader.this.oid;
        }

        @Override
        public void setObjectID(ObjectID id) {
            throw new AssertionError();
        }

        private class RemoveMetaDataIterator
        implements Iterator<NVPair> {
            private int count = 0;
            private final int numberOfNvPairs;
            private final Iterator<Map.Entry<Object, EvictableEntry>> toRemove;
            private Map.Entry<Object, EvictableEntry> next;

            public RemoveMetaDataIterator(int numberOfNvPairs) {
                this.toRemove = RemoveAllMetaDataReader.this.candidates.entrySet().iterator();
                this.numberOfNvPairs = numberOfNvPairs;
            }

            @Override
            public boolean hasNext() {
                return this.count < this.numberOfNvPairs;
            }

            @Override
            public NVPair next() {
                ++this.count;
                if (this.count > this.numberOfNvPairs) {
                    throw new NoSuchElementException();
                }
                if (this.count <= 3) {
                    switch (this.count) {
                        case 1: {
                            return new AbstractNVPair.StringNVPair(SearchMetaData.CACHENAME.toString(), RemoveAllMetaDataReader.this.cacheName);
                        }
                        case 2: {
                            this.next = this.toRemove.next();
                            return new AbstractNVPair.EnumNVPair(SearchMetaData.COMMAND.toString(), (Enum)SearchCommand.REMOVE_IF_VALUE_EQUAL);
                        }
                        case 3: {
                            return new AbstractNVPair.IntNVPair("", (this.numberOfNvPairs - 3) / 2);
                        }
                    }
                    throw new AssertionError(this.count);
                }
                if (this.count % 2 == 0) {
                    Object key = this.next.getKey();
                    key = key instanceof UTF8ByteDataHolder ? ((UTF8ByteDataHolder)key).asString() : key.toString();
                    return AbstractNVPair.createNVPair((String)"", (Object)key);
                }
                ObjectID valueOid = this.next.getValue().getObjectID();
                AbstractNVPair.ValueIdNVPair nv = new AbstractNVPair.ValueIdNVPair("", new ValueID(valueOid.toLong()));
                if (this.toRemove.hasNext()) {
                    this.next = this.toRemove.next();
                }
                return nv;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

