/*
 * Decompiled with CFR 0.152.
 */
package com.tc.objectserver.dgc.api;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.objectserver.core.impl.GarbageCollectionID;
import java.io.IOException;

public class GarbageCollectionInfo
implements TCSerializable {
    protected static final long NOT_INITIALIZED = -1L;
    protected static final long NULL_INITIALIZED = -2L;
    private GarbageCollectionID gcID = GarbageCollectionID.NULL_ID;
    private long startTime = -1L;
    private long beginObjectCount = -1L;
    private long markStageTime = -1L;
    private long pauseStageTime = -1L;
    private long elapsedTime = -1L;
    private long endObjectCount = -1L;
    private long totalMarkCycleTime = -1L;
    private long candidateGarbageCount = -1L;
    private long actualGarbageCount = -1L;
    private long preRescueCount = -1L;
    private long rescue1Count = -1L;
    private long rescue1Time = -1L;
    private long rescue2Time = -1L;
    private Type type = Type.NULL_GC;
    public static final GarbageCollectionInfo NULL_INFO = new GarbageCollectionInfo(new GarbageCollectionID(-2L, "NULL INITIALIZED"), Type.NULL_GC);

    public GarbageCollectionInfo() {
    }

    public GarbageCollectionInfo(GarbageCollectionID id, Type type) {
        this.gcID = id;
        this.type = type;
    }

    public boolean isInlineCleanup() {
        return this.type == Type.INLINE_CLEANUP;
    }

    public boolean isInlineDGC() {
        return this.type == Type.INLINE_GC;
    }

    public void setCandidateGarbageCount(long candidateGarbageCount) {
        this.candidateGarbageCount = candidateGarbageCount;
    }

    public void setActualGarbageCount(long actualGarbageCount) {
        this.actualGarbageCount = actualGarbageCount;
    }

    public long getRescue1Count() {
        return this.rescue1Count;
    }

    public void setRescue1Count(long count) {
        this.rescue1Count = count;
    }

    public long getPreRescueCount() {
        return this.preRescueCount;
    }

    public void setPreRescueCount(long count) {
        this.preRescueCount = count;
    }

    public int getIteration() {
        return (int)this.gcID.toLong();
    }

    public boolean isFullGC() {
        return this.type == Type.FULL_GC;
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setBeginObjectCount(long count) {
        this.beginObjectCount = count;
    }

    public long getBeginObjectCount() {
        return this.beginObjectCount;
    }

    public void setEndObjectCount(long count) {
        this.endObjectCount = count;
    }

    public long getEndObjectCount() {
        return this.endObjectCount;
    }

    public void setMarkStageTime(long time) {
        this.markStageTime = time;
    }

    public long getMarkStageTime() {
        return this.markStageTime;
    }

    public void setPausedStageTime(long time) {
        this.pauseStageTime = time;
    }

    public long getPausedStageTime() {
        return this.pauseStageTime;
    }

    public void setElapsedTime(long time) {
        this.elapsedTime = time;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setTotalMarkCycleTime(long time) {
        this.totalMarkCycleTime = time;
    }

    public long getTotalMarkCycleTime() {
        return this.totalMarkCycleTime;
    }

    public void setCandidateGarbageCount(int count) {
        this.candidateGarbageCount = count;
    }

    public long getCandidateGarbageCount() {
        return this.candidateGarbageCount;
    }

    public long getActualGarbageCount() {
        return this.actualGarbageCount;
    }

    public long getRescue1Time() {
        return this.rescue1Time;
    }

    public void setRescue1Time(long rescue1Time) {
        this.rescue1Time = rescue1Time;
    }

    public long getRescue2Time() {
        return this.rescue2Time;
    }

    public void setRescue2Time(long rescue2Time) {
        this.rescue2Time = rescue2Time;
    }

    public GarbageCollectionID getGarbageCollectionID() {
        return this.gcID;
    }

    public String toString() {
        StringBuilder gcInfo = new StringBuilder();
        gcInfo.append("GarbageCollectionInfo [ Iteration = ");
        gcInfo.append(this.gcID.toLong());
        gcInfo.append(" ] =  type  = " + this.type);
        if (this.startTime != -1L) {
            gcInfo.append(" startTime = " + this.startTime);
        }
        if (this.beginObjectCount != -1L) {
            gcInfo.append(" begin object count = " + this.beginObjectCount);
        }
        if (this.endObjectCount != -1L) {
            gcInfo.append(" end object count = " + this.endObjectCount);
        }
        if (this.markStageTime != -1L) {
            gcInfo.append(" markStageTime = " + this.markStageTime);
        }
        if (this.pauseStageTime != -1L) {
            gcInfo.append(" pauseStageTime = " + this.pauseStageTime);
        }
        if (this.elapsedTime != -1L) {
            gcInfo.append(" elapsedTime = " + this.elapsedTime);
        }
        if (this.totalMarkCycleTime != -1L) {
            gcInfo.append(" totalMarkCycleTime = " + this.totalMarkCycleTime);
        }
        if (this.candidateGarbageCount != -1L) {
            gcInfo.append(" candidate garbage  count = " + this.candidateGarbageCount);
        }
        if (this.actualGarbageCount != -1L) {
            gcInfo.append(" actual garbage count = " + this.actualGarbageCount);
        }
        if (this.preRescueCount != -1L) {
            gcInfo.append(" pre rescue count = " + this.preRescueCount);
        }
        if (this.rescue1Time != -1L) {
            gcInfo.append(" rescue1Time = " + this.rescue1Time);
        }
        if (this.rescue1Count != -1L) {
            gcInfo.append(" rescue 1 Count = " + this.rescue1Count);
        }
        if (this.rescue2Time != -1L) {
            gcInfo.append(" rescue2Time = " + this.rescue2Time);
        }
        return gcInfo.toString();
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        long iterationCount = serialInput.readLong();
        String uuidString = serialInput.readString();
        this.gcID = new GarbageCollectionID(iterationCount, uuidString);
        this.startTime = serialInput.readLong();
        this.beginObjectCount = serialInput.readLong();
        this.endObjectCount = serialInput.readLong();
        this.markStageTime = serialInput.readLong();
        this.pauseStageTime = serialInput.readLong();
        this.elapsedTime = serialInput.readLong();
        this.totalMarkCycleTime = serialInput.readLong();
        this.candidateGarbageCount = serialInput.readLong();
        this.actualGarbageCount = serialInput.readLong();
        this.preRescueCount = serialInput.readLong();
        this.rescue1Count = serialInput.readLong();
        this.rescue1Time = serialInput.readLong();
        this.rescue2Time = serialInput.readLong();
        this.type = Type.valueOf(serialInput.readString());
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeLong(this.gcID.toLong());
        serialOutput.writeString(this.gcID.getUUID());
        serialOutput.writeLong(this.startTime);
        serialOutput.writeLong(this.beginObjectCount);
        serialOutput.writeLong(this.endObjectCount);
        serialOutput.writeLong(this.markStageTime);
        serialOutput.writeLong(this.pauseStageTime);
        serialOutput.writeLong(this.elapsedTime);
        serialOutput.writeLong(this.totalMarkCycleTime);
        serialOutput.writeLong(this.candidateGarbageCount);
        serialOutput.writeLong(this.actualGarbageCount);
        serialOutput.writeLong(this.preRescueCount);
        serialOutput.writeLong(this.rescue1Count);
        serialOutput.writeLong(this.rescue1Time);
        serialOutput.writeLong(this.rescue2Time);
        serialOutput.writeString(this.type.toString());
    }

    public static enum Type {
        NULL_GC,
        FULL_GC,
        INLINE_CLEANUP,
        INLINE_GC;

    }
}

