/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.tx;

import com.tc.util.Assert;

public class TxnType {
    private static final byte TYPE_NORMAL = 2;
    private static final byte TYPE_CONCURRENT = 3;
    private static final byte TYPE_SYNC_WRITE = 4;
    public static final TxnType NORMAL = new TxnType(2);
    public static final TxnType SYNC_WRITE = new TxnType(4);
    public static final TxnType CONCURRENT = new TxnType(3);
    private final byte type;

    public static TxnType typeFor(byte type) {
        switch (type) {
            case 2: {
                return NORMAL;
            }
            case 3: {
                return CONCURRENT;
            }
            case 4: {
                return SYNC_WRITE;
            }
        }
        throw Assert.failure("unknown transaction type " + type);
    }

    public boolean isConcurrent() {
        return this == CONCURRENT;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.type;
    }

    private TxnType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 2: {
                return "NORMAL";
            }
            case 3: {
                return "CONCURRENT";
            }
            case 4: {
                return "SYNC_WRITE";
            }
        }
        return "UNKNOWN (" + this.type + ")";
    }
}

