/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.tx;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.lang.Recyclable;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLoggingService;
import com.tc.net.GroupID;
import com.tc.object.ObjectID;
import com.tc.object.TCObject;
import com.tc.object.change.TCChangeBuffer;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.impl.DNAWriterImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.object.locks.Notify;
import com.tc.object.msg.CommitTransactionMessage;
import com.tc.object.msg.CommitTransactionMessageFactory;
import com.tc.object.tx.ClientTransaction;
import com.tc.object.tx.ClientTransactionBatch;
import com.tc.object.tx.TransactionBuffer;
import com.tc.object.tx.TransactionID;
import com.tc.object.tx.TransactionIDGenerator;
import com.tc.object.tx.TxnBatchID;
import com.tc.object.tx.TxnType;
import com.tc.util.Assert;
import com.tc.util.Conversion;
import com.tc.util.SequenceGenerator;
import com.tc.util.SequenceID;
import com.tc.util.ServiceUtil;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientTransactionBatchWriter
implements ClientTransactionBatch {
    private static final TCLogger logger = ServiceUtil.loadService(TCLoggingService.class).getLogger(ClientTransactionBatchWriter.class);
    private final GroupID groupID;
    private final CommitTransactionMessageFactory commitTransactionMessageFactory;
    private final TxnBatchID batchID;
    private final LinkedHashMap transactionData = new LinkedHashMap();
    private final Map foldingKeys = new HashMap();
    private final ObjectStringSerializer serializer;
    private final DNAEncodingInternal encoding;
    private final List batchDataOutputStreams = new ArrayList();
    private final int foldingObjectLimit;
    private final int foldingLockLimit;
    private final boolean foldingEnabled;
    private final boolean debug;
    private short outstandingWriteCount = 0;
    private int bytesWritten = 0;
    private int numTxnsBeforeFolding = 0;
    private int numTxnsAfterFolding = 0;
    private boolean containsSyncWriteTxn = false;
    private boolean committed = false;
    private int holders = 0;

    public ClientTransactionBatchWriter(GroupID groupID, TxnBatchID batchID, ObjectStringSerializer serializer, DNAEncodingInternal encoding, CommitTransactionMessageFactory commitTransactionMessageFactory, FoldingConfig foldingConfig) {
        this.groupID = groupID;
        this.batchID = batchID;
        this.encoding = encoding;
        this.commitTransactionMessageFactory = commitTransactionMessageFactory;
        this.serializer = serializer;
        this.foldingLockLimit = foldingConfig.getLockLimit();
        this.foldingObjectLimit = foldingConfig.getObjectLimit();
        this.foldingEnabled = foldingConfig.isFoldingEnabled();
        this.debug = foldingConfig.isDebugLogging();
    }

    public synchronized String toString() {
        return super.toString() + "[" + this.batchID + ", isEmpty=" + this.isEmpty() + ", numTxnsBeforeFolding= " + this.numTxnsBeforeFolding + " numTxnAfterfoldingTxn= " + this.numTxnsAfterFolding + " size=" + this.bytesWritten + " foldingKeys=" + this.foldingKeys.size();
    }

    @Override
    public synchronized TxnBatchID getTransactionBatchID() {
        boolean interrupted = false;
        while (this.holders > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this.batchID;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.transactionData.isEmpty();
    }

    @Override
    public synchronized int numberOfTxnsBeforeFolding() {
        return this.numTxnsBeforeFolding;
    }

    @Override
    public synchronized int byteSize() {
        return this.bytesWritten;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public synchronized TransactionBuffer removeTransaction(TransactionID txID) {
        TransactionBufferImpl removed = (TransactionBufferImpl)this.transactionData.remove(txID);
        if (removed == null) {
            throw new AssertionError((Object)"Attempt to remove a transaction that doesn't exist");
        }
        if (this.outstandingWriteCount == 0) {
            removed.recycle();
        }
        return removed;
    }

    @Override
    public synchronized boolean contains(TransactionID txID) {
        return this.transactionData.containsKey(txID);
    }

    private TransactionBuffer createBuffer(ClientTransaction txn) {
        TransactionBuffer txnBuffer = this.createTransactionBuffer(txn.getSequenceID(), this.newOutputStream(), this.serializer, this.encoding, txn.getTransactionID());
        this.transactionData.put(txn.getTransactionID(), txnBuffer);
        return txnBuffer;
    }

    private TransactionBuffer getOrCreateBuffer(ClientTransaction txn, SequenceGenerator sequenceGenerator, TransactionIDGenerator tidGenerator) {
        boolean scanForClose;
        boolean exceedsLimits = this.exceedsLimits(txn);
        boolean bl = scanForClose = txn.getNewRoots().size() > 0 || txn.getNotifies().size() > 0 || exceedsLimits;
        if (this.debug) {
            this.log_incomingTxn(txn, exceedsLimits, scanForClose);
        }
        if (scanForClose) {
            this.scanForClose(txn);
        } else {
            boolean dependencyFound = false;
            FoldingKey potential = null;
            IdentityHashMap<FoldingKey, Object> dependentKeys = null;
            for (TCChangeBuffer changeBuffer : txn.getChangeBuffers().values()) {
                TCObject tco = changeBuffer.getTCObject();
                if (tco.isNew()) {
                    if (!this.debug) continue;
                    logger.info("isNew for " + tco.getObjectID());
                    continue;
                }
                ObjectID oid = tco.getObjectID();
                FoldingKey key = (FoldingKey)this.foldingKeys.get(oid);
                if (key == null) {
                    if (!this.debug) continue;
                    logger.info("no fold key for " + oid);
                    continue;
                }
                if (potential == null) {
                    if (this.debug) {
                        logger.info("setting potential key to " + System.identityHashCode(key) + " on " + oid);
                    }
                    potential = key;
                    continue;
                }
                if (!dependencyFound && potential == key && !potential.isClosed()) continue;
                if (!dependencyFound && this.debug) {
                    logger.info("dependency for " + oid + ", potential(" + System.identityHashCode(potential) + "), key(" + System.identityHashCode(key) + "), potential.closed=" + potential.isClosed());
                }
                if (dependentKeys == null) {
                    Assert.assertFalse(dependencyFound);
                    dependentKeys = new IdentityHashMap<FoldingKey, Object>();
                    if (this.debug) {
                        logger.info("add " + System.identityHashCode(potential) + " to depKey set on " + oid);
                    }
                    dependentKeys.put(potential, null);
                }
                dependencyFound = true;
                if (this.debug) {
                    logger.info("add " + System.identityHashCode(key) + " to depKey set on " + oid);
                }
                dependentKeys.put(key, null);
            }
            if (dependencyFound) {
                if (this.debug) {
                    logger.info("Dependency found -- closing dependent keys");
                }
                this.closeDependentKeys(dependentKeys.keySet());
            } else if (!exceedsLimits && potential != null) {
                if (this.debug) {
                    logger.info("potential fold found " + System.identityHashCode(potential));
                }
                if (potential.canAcceptFold(txn.getAllLockIDs(), txn.getLockType(), this.debug)) {
                    if (this.debug) {
                        logger.info("fold accepted into " + System.identityHashCode(potential));
                    }
                    Set incomingOids = txn.getChangeBuffers().keySet();
                    potential.getObjectIDs().addAll(incomingOids);
                    this.registerKeyForOids(incomingOids, potential);
                    return potential.getBuffer();
                }
                if (this.debug) {
                    logger.info("fold denied into " + System.identityHashCode(potential));
                }
            }
        }
        SequenceID sid = new SequenceID(sequenceGenerator.getNextSequence());
        txn.setSequenceID(sid);
        txn.setTransactionID(tidGenerator.nextTransactionID());
        if (this.debug) {
            logger.info("NOT folding, created new sequence " + sid);
        }
        TransactionBuffer txnBuffer = this.createTransactionBuffer(sid, this.newOutputStream(), this.serializer, this.encoding, txn.getTransactionID());
        FoldingKey key = new FoldingKey(txnBuffer, txn.getLockType(), new HashSet(txn.getChangeBuffers().keySet()), this.debug);
        ++this.numTxnsAfterFolding;
        this.registerKeyForOids(txn.getChangeBuffers().keySet(), key);
        this.transactionData.put(txn.getTransactionID(), txnBuffer);
        return txnBuffer;
    }

    protected TransactionBuffer createTransactionBuffer(SequenceID sid, TCByteBufferOutputStream newOutputStream, ObjectStringSerializer objectStringserializer, DNAEncodingInternal dnaEncoding, TransactionID txnID) {
        return new TransactionBufferImpl(sid, newOutputStream, objectStringserializer, dnaEncoding, txnID);
    }

    private void registerKeyForOids(Set oids, FoldingKey key) {
        for (ObjectID oid : oids) {
            FoldingKey prev = this.foldingKeys.put(oid, key);
            if (!this.debug) continue;
            logger.info("registered key(" + System.identityHashCode(key) + " for " + oid + ", replaces key(" + System.identityHashCode(prev) + ")");
        }
    }

    private void log_incomingTxn(ClientTransaction txn, boolean exceedsLimits, boolean scanForClose) {
        logger.info("incoming txn@" + System.identityHashCode(txn) + "[" + txn.getTransactionID() + " locks=" + txn.getAllLockIDs() + ", oids=" + txn.getChangeBuffers().keySet() + ", roots=" + txn.getNewRoots() + ", notifies=" + txn.getNotifies() + ", type=" + txn.getLockType() + "] exceedsLimit=" + exceedsLimits + ", scanForClose=" + scanForClose);
    }

    private void closeDependentKeys(Collection dependentKeys) {
        for (FoldingKey key : dependentKeys) {
            if (this.debug) {
                logger.info("closing dependent key " + System.identityHashCode(key));
            }
            key.close();
        }
    }

    private boolean exceedsLimits(ClientTransaction txn) {
        return ClientTransactionBatchWriter.exceedsLimit(this.foldingLockLimit, txn.getAllLockIDs().size()) || ClientTransactionBatchWriter.exceedsLimit(this.foldingObjectLimit, txn.getChangeBuffers().size());
    }

    private void scanForClose(ClientTransaction txn) {
        HashSet locks = new HashSet(txn.getAllLockIDs());
        Set oids = txn.getChangeBuffers().keySet();
        Iterator i = this.foldingKeys.values().iterator();
        while (i.hasNext()) {
            FoldingKey key = (FoldingKey)i.next();
            if (!key.isClosed() && !key.hasCommonality(locks, oids)) continue;
            i.remove();
            key.close();
        }
    }

    private static boolean exceedsLimit(int limit, int value) {
        if (limit > 0) {
            return value > limit;
        }
        return false;
    }

    @Override
    public synchronized FoldedInfo addTransaction(ClientTransaction txn, SequenceGenerator sequenceGenerator, TransactionIDGenerator tidGenerator) {
        ++this.holders;
        TransactionBuffer txnBuffer = null;
        if (!this.foldingEnabled) {
            txn.setSequenceID(new SequenceID(sequenceGenerator.getNextSequence()));
            txn.setTransactionID(tidGenerator.nextTransactionID());
            txnBuffer = this.addSimpleTransaction(txn);
        } else {
            if (this.committed) {
                throw new AssertionError((Object)"Already committed");
            }
            ++this.numTxnsBeforeFolding;
            if (txn.getLockType().equals(TxnType.SYNC_WRITE)) {
                this.containsSyncWriteTxn = true;
            }
            this.removeEmptyDeltaDna(txn);
            txnBuffer = this.getOrCreateBuffer(txn, sequenceGenerator, tidGenerator);
            txnBuffer.addTransactionCompleteListeners(txn.getTransactionCompleteListeners());
        }
        this.bytesWritten += txnBuffer.write(txn);
        return new FoldedInfo(txnBuffer);
    }

    @Override
    public synchronized TransactionBuffer addSimpleTransaction(ClientTransaction txn) {
        ++this.holders;
        if (this.committed) {
            throw new AssertionError((Object)"Already committed");
        }
        ++this.numTxnsBeforeFolding;
        if (txn.getLockType().equals(TxnType.SYNC_WRITE)) {
            this.containsSyncWriteTxn = true;
        }
        this.removeEmptyDeltaDna(txn);
        TransactionBuffer txnBuffer = this.createBuffer(txn);
        txnBuffer.addTransactionCompleteListeners(txn.getTransactionCompleteListeners());
        return txnBuffer;
    }

    private synchronized void release() {
        if (--this.holders == 0) {
            this.notify();
        }
    }

    private void removeEmptyDeltaDna(ClientTransaction txn) {
        Iterator i = txn.getChangeBuffers().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            TCChangeBuffer buffer = (TCChangeBuffer)entry.getValue();
            if (buffer.getTCObject().isNew() || !buffer.isEmpty()) continue;
            i.remove();
        }
    }

    @Override
    public synchronized TCByteBuffer[] getData() {
        this.committed = true;
        this.foldingKeys.clear();
        this.outstandingWriteCount = (short)(this.outstandingWriteCount + 1);
        TCByteBufferOutputStream out = this.newOutputStream();
        this.writeHeader(out);
        for (TransactionBuffer tb : this.transactionData.values()) {
            tb.writeTo(out);
        }
        this.batchDataOutputStreams.add(out);
        return out.toArray();
    }

    protected void writeHeader(TCByteBufferOutputStream out) {
        out.writeLong(this.batchID.toLong());
        out.writeInt(this.transactionData.size());
        out.writeBoolean(this.containsSyncWriteTxn);
    }

    private TCByteBufferOutputStream newOutputStream() {
        TCByteBufferOutputStream out = new TCByteBufferOutputStream(32, 4096, false);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() {
        CommitTransactionMessage msg;
        ClientTransactionBatchWriter clientTransactionBatchWriter = this;
        synchronized (clientTransactionBatchWriter) {
            msg = this.commitTransactionMessageFactory.newCommitTransactionMessage(this.groupID);
            msg.setBatch(this, this.serializer);
        }
        msg.send();
    }

    public synchronized Collection addTransactionIDsTo(Collection c) {
        c.addAll(this.transactionData.keySet());
        return c;
    }

    @Override
    public synchronized SequenceID getMinTransactionSequence() {
        return this.transactionData.isEmpty() ? SequenceID.NULL_ID : ((TransactionBufferImpl)this.transactionData.values().iterator().next()).getSequenceID();
    }

    public Collection addTransactionSequenceIDsTo(Collection sequenceIDs) {
        for (TransactionBufferImpl tb : this.transactionData.values()) {
            sequenceIDs.add(tb.getSequenceID());
        }
        return sequenceIDs;
    }

    @Override
    public synchronized void recycle() {
        for (TCByteBufferOutputStream buffer : this.batchDataOutputStreams) {
            buffer.recycle();
        }
        this.batchDataOutputStreams.clear();
        this.outstandingWriteCount = (short)(this.outstandingWriteCount - 1);
    }

    @Override
    public synchronized String dump() {
        StringBuffer sb = new StringBuffer("TransactionBatchWriter = { \n");
        for (Map.Entry entry : this.transactionData.entrySet()) {
            sb.append(entry.getKey()).append(" = ");
            sb.append(((TransactionBufferImpl)entry.getValue()).dump());
            sb.append("\n");
        }
        return sb.append(" } ").toString();
    }

    public static class FoldedInfo {
        private final TransactionBuffer buffer;
        private final TransactionID txnID;
        private final boolean folded;

        public FoldedInfo(TransactionBuffer buffer) {
            this.buffer = buffer;
            this.txnID = buffer.getFoldedTransactionID();
            this.folded = buffer.getTxnCount() > 1;
        }

        public TransactionID getFoldedTransactionID() {
            return this.txnID;
        }

        public boolean isFolded() {
            return this.folded;
        }

        public TransactionBuffer getBuffer() {
            return this.buffer;
        }
    }

    public static class FoldingConfig {
        private final int lockLimit;
        private final int objectLimit;
        private final boolean foldingEnabled;
        private final boolean debugLogging;

        public FoldingConfig(boolean foldingEnabled, int objectLimit, int lockLimit, boolean debugLogging) {
            this.foldingEnabled = foldingEnabled;
            this.objectLimit = objectLimit;
            this.lockLimit = lockLimit;
            this.debugLogging = debugLogging;
        }

        public int getLockLimit() {
            return this.lockLimit;
        }

        public int getObjectLimit() {
            return this.objectLimit;
        }

        public boolean isFoldingEnabled() {
            return this.foldingEnabled;
        }

        public boolean isDebugLogging() {
            return this.debugLogging;
        }
    }

    private static class FoldingKey {
        private final Set objectIDs;
        private final TxnType txnType;
        private final TransactionBuffer buffer;
        private boolean closed;

        FoldingKey(TransactionBuffer txnBuffer, TxnType txnType, Set objectIDs, boolean debug) {
            this.buffer = txnBuffer;
            this.txnType = txnType;
            this.objectIDs = objectIDs;
            if (debug) {
                logger.info("created new fold key(" + System.identityHashCode(this) + "), txnType=" + txnType + ", oids=" + objectIDs);
            }
        }

        Set getObjectIDs() {
            return this.objectIDs;
        }

        public void close() {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean hasCommonality(Collection locks, Collection oids) {
            if (this.objectIDs.size() > oids.size()) {
                for (Object oid : oids) {
                    if (!this.objectIDs.contains(oid)) continue;
                    return true;
                }
            } else {
                for (Object oid : this.objectIDs) {
                    if (!oids.contains(oid)) continue;
                    return true;
                }
            }
            return false;
        }

        public TransactionBuffer getBuffer() {
            return this.buffer;
        }

        public boolean canAcceptFold(List txnLocks, TxnType type, boolean debug) {
            if (!type.equals(this.txnType)) {
                if (debug) {
                    logger.info(System.identityHashCode(this) + ": not accepting fold since txn type is different");
                }
                return false;
            }
            if (debug) {
                logger.info(System.identityHashCode(this) + ": fold accepted");
            }
            return true;
        }
    }

    protected class TransactionBufferImpl
    implements Recyclable,
    TransactionBuffer {
        private static final int UNINITIALIZED_LENGTH = -1;
        private final SequenceID sequenceID;
        private final TCByteBufferOutputStream output;
        private final ObjectStringSerializer serializer;
        private final DNAEncodingInternal encoding;
        private final TCByteBufferOutputStream.Mark startMark;
        private final SetOnceFlag committed = new SetOnceFlag();
        private final Map writers = new LinkedHashMap();
        private final TransactionID txnID;
        private final IdentityHashMap references = new IdentityHashMap();
        private boolean needsCopy = false;
        private int headerLength = -1;
        private int txnCount = 0;
        private TCByteBufferOutputStream.Mark changesCountMark;
        private TCByteBufferOutputStream.Mark txnCountMark;
        private ArrayList txnCompleteListers;

        TransactionBufferImpl(SequenceID sequenceID, TCByteBufferOutputStream output, ObjectStringSerializer serializer, DNAEncodingInternal encoding, TransactionID txnID) {
            this.sequenceID = sequenceID;
            this.output = output;
            this.serializer = serializer;
            this.encoding = encoding;
            this.startMark = output.mark();
            this.txnID = txnID;
        }

        @Override
        public TransactionID getFoldedTransactionID() {
            return this.txnID;
        }

        @Override
        public void writeTo(TCByteBufferOutputStream dest) {
            if (this.committed.attemptSet()) {
                this.txnCountMark.write(Conversion.int2Bytes(this.txnCount));
                this.changesCountMark.write(Conversion.int2Bytes(this.writers.size()));
                for (DNAWriter writer : this.writers.values()) {
                    writer.finalizeHeader();
                }
            }
            if (!this.needsCopy) {
                dest.write(this.output.toArray());
                return;
            }
            int expect = this.output.getBytesWritten();
            int begin = dest.getBytesWritten();
            this.startMark.copyTo(dest, this.headerLength);
            for (Map.Entry entry : this.writers.entrySet()) {
                DNAWriter writer = (DNAWriter)entry.getValue();
                writer.copyTo(dest);
            }
            Assert.assertEquals(expect, dest.getBytesWritten() - begin);
        }

        String dump() {
            return " { " + this.sequenceID + " , Txns in Buffer = " + this.references.size() + " , Objects in (Folded) Txn : " + this.writers.size() + " }";
        }

        SequenceID getSequenceID() {
            return this.sequenceID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ClientTransaction txn) {
            try {
                Iterator i = txn.getReferencesOfObjectsInTxn().iterator();
                while (i.hasNext()) {
                    this.references.put(i.next(), null);
                }
                int start = this.output.getBytesWritten();
                if (this.txnCount == 0) {
                    this.writeFirst(txn);
                } else {
                    this.appendChanges(txn);
                }
                ++this.txnCount;
                int n = this.output.getBytesWritten() - start;
                return n;
            }
            finally {
                ClientTransactionBatchWriter.this.release();
            }
        }

        private void appendChanges(ClientTransaction txn) {
            this.writeChanges(txn.getChangeBuffers());
        }

        private void writeChanges(Map changes) {
            for (Map.Entry entry : changes.entrySet()) {
                ObjectID oid = (ObjectID)entry.getKey();
                TCChangeBuffer buffer = (TCChangeBuffer)entry.getValue();
                TCObject tco = buffer.getTCObject();
                boolean isNew = tco.isNew();
                DNAWriter writer = (DNAWriter)this.writers.get(oid);
                if (writer == null) {
                    writer = new DNAWriterImpl(this.output, oid, tco.getExtendingClassName(), this.serializer, this.encoding, !isNew);
                    this.writers.put(oid, writer);
                } else {
                    writer = writer.createAppender();
                }
                if (isNew) {
                    tco.dehydrate(writer);
                    tco.setNotNew();
                    if (buffer.hasMetaData()) {
                        logger.error("not sending meta data attached to \"new\" object of type " + tco.getClassName());
                    }
                }
                buffer.writeTo(writer);
                writer.markSectionEnd();
                if (writer.isContiguous()) continue;
                this.needsCopy = true;
            }
        }

        private void writeFirst(ClientTransaction txn) {
            this.writeTransactionHeader(txn);
            Map changes = txn.getChangeBuffers();
            this.writeChanges(changes);
        }

        private void writeTransactionHeader(ClientTransaction txn) {
            int startPos = this.output.getBytesWritten();
            TransactionID tid = txn.getTransactionID();
            if (tid.isNull()) {
                throw new AssertionError((Object)("Writing Transaction with null Transaction ID : " + txn.toString()));
            }
            this.output.writeLong(tid.toLong());
            this.output.writeByte(txn.getLockType().getType());
            this.txnCountMark = this.output.mark();
            this.output.writeInt(-1);
            SequenceID sid = txn.getSequenceID();
            if (sid.isNull()) {
                throw new AssertionError((Object)("SequenceID is null: " + txn));
            }
            this.output.writeLong(sid.toLong());
            this.output.writeBoolean(false);
            List locks = txn.getAllLockIDs();
            this.output.writeInt(locks.size());
            Iterator i = locks.iterator();
            while (i.hasNext()) {
                new LockIDSerializer((LockID)i.next()).serializeTo(this.output);
            }
            Map newRoots = txn.getNewRoots();
            this.output.writeInt(newRoots.size());
            for (Map.Entry entry : newRoots.entrySet()) {
                String name = (String)entry.getKey();
                ObjectID id = (ObjectID)entry.getValue();
                this.output.writeString(name);
                this.output.writeLong(id.toLong());
            }
            List notifies = txn.getNotifies();
            this.output.writeInt(notifies.size());
            for (Notify n : notifies) {
                n.serializeTo(this.output);
            }
            this.writeAdditionalHeaderInformation(this.output, txn);
            this.changesCountMark = this.output.mark();
            this.output.writeInt(-1);
            Assert.assertEquals(-1, this.headerLength);
            this.headerLength = this.output.getBytesWritten() - startPos;
        }

        protected void writeAdditionalHeaderInformation(TCByteBufferOutputStream out, ClientTransaction txn) {
            this.writeLongArray(out, new long[0]);
        }

        protected void writeLongArray(TCByteBufferOutputStream out, long[] ls) {
            out.writeInt(ls.length);
            for (long element : ls) {
                out.writeLong(element);
            }
        }

        @Override
        public int getTxnCount() {
            return this.txnCount;
        }

        @Override
        public void recycle() {
            this.output.recycle();
        }

        @Override
        public void addTransactionCompleteListeners(List transactionCompleteListeners) {
            if (!transactionCompleteListeners.isEmpty()) {
                if (this.txnCompleteListers == null) {
                    this.txnCompleteListers = new ArrayList(5);
                }
                this.txnCompleteListers.addAll(transactionCompleteListeners);
            }
        }

        @Override
        public List getTransactionCompleteListeners() {
            return this.txnCompleteListers == null ? Collections.EMPTY_LIST : this.txnCompleteListers;
        }
    }
}

