/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.TCSerializable;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class SyncWriteTransactionReceivedMessage
extends DSOMessageBase {
    private static final byte BATCH_ID = 1;
    private static final byte TXN_SET = 2;
    private long batchID;
    private SyncSetSerializer syncTxnSet;

    public SyncWriteTransactionReceivedMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public SyncWriteTransactionReceivedMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.batchID);
        this.putNVPair((byte)2, this.syncTxnSet);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.batchID = this.getLongValue();
                return true;
            }
            case 2: {
                this.syncTxnSet = (SyncSetSerializer)this.getObject(new SyncSetSerializer());
                return true;
            }
        }
        return false;
    }

    public void initialize(long batchId, Set<TransactionID> syncSet) {
        this.batchID = batchId;
        this.syncTxnSet = new SyncSetSerializer(syncSet);
    }

    public long getBatchID() {
        return this.batchID;
    }

    public Set<TransactionID> getSyncTxnSet() {
        return this.syncTxnSet.getSet();
    }

    private static class SyncSetSerializer
    implements TCSerializable {
        private Set<TransactionID> syncTxnSet;

        public SyncSetSerializer() {
        }

        public SyncSetSerializer(Set<TransactionID> syncTxnSet) {
            this.syncTxnSet = syncTxnSet;
        }

        @Override
        public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
            this.syncTxnSet = new HashSet<TransactionID>();
            int size = serialInput.readInt();
            for (int i = 0; i < size; ++i) {
                this.syncTxnSet.add(new TransactionID(serialInput.readLong()));
            }
            return this;
        }

        @Override
        public void serializeTo(TCByteBufferOutput serialOutput) {
            serialOutput.writeInt(this.syncTxnSet.size());
            for (TransactionID txId : this.syncTxnSet) {
                serialOutput.writeLong(txId.toLong());
            }
        }

        public Set<TransactionID> getSet() {
            return this.syncTxnSet;
        }
    }
}

