/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.impl.SerializerDNAEncodingImpl;
import com.tc.object.dna.impl.UTF8ByteDataHolder;
import com.tc.server.BasicServerEvent;
import com.tc.server.CustomLifespanVersionedServerEvent;
import com.tc.server.ServerEvent;
import com.tc.server.ServerEventType;
import com.tc.server.VersionedServerEvent;
import java.io.IOException;

class ServerEventSerializableContext
implements TCSerializable {
    private static final DNAEncoding serializer = new SerializerDNAEncodingImpl();
    private ServerEvent event;

    public ServerEventSerializableContext() {
    }

    public ServerEventSerializableContext(ServerEvent event) {
        this.event = event;
    }

    @Override
    public void serializeTo(TCByteBufferOutput out) {
        serializer.encode(this.event.getType().ordinal(), out);
        serializer.encode(this.event.getCacheName(), out);
        serializer.encode(this.event.getKey(), out);
        serializer.encode(this.event.getValue(), out);
        serializer.encode(((VersionedServerEvent)this.event).getVersion(), out);
        boolean customLifespanEvent = this.event instanceof CustomLifespanVersionedServerEvent;
        serializer.encode(customLifespanEvent, out);
        if (customLifespanEvent) {
            CustomLifespanVersionedServerEvent customLifespanVersionedServerEvent = (CustomLifespanVersionedServerEvent)this.event;
            serializer.encode(customLifespanVersionedServerEvent.getCreationTimeInSeconds(), out);
            serializer.encode(customLifespanVersionedServerEvent.getTimeToIdle(), out);
            serializer.encode(customLifespanVersionedServerEvent.getTimeToLive(), out);
        }
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput in) throws IOException {
        try {
            int index = (Integer)serializer.decode(in);
            ServerEventType type = ServerEventType.values()[index];
            String destination = (String)serializer.decode(in);
            Object key = serializer.decode(in);
            byte[] value = (byte[])serializer.decode(in);
            long version = (Long)serializer.decode(in);
            BasicServerEvent versionedEvent = new BasicServerEvent(type, ServerEventSerializableContext.extractStringIfNecessary(key), value, version, destination);
            boolean customLifespanEvent = (Boolean)serializer.decode(in);
            if (customLifespanEvent) {
                int creationTime = (Integer)serializer.decode(in);
                int timeToIdle = (Integer)serializer.decode(in);
                int timeToLive = (Integer)serializer.decode(in);
                this.event = new CustomLifespanVersionedServerEvent(versionedEvent, creationTime, timeToIdle, timeToLive);
            } else {
                this.event = versionedEvent;
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    private static Object extractStringIfNecessary(Object key) {
        Object normalizedKey = key instanceof UTF8ByteDataHolder ? ((UTF8ByteDataHolder)key).asString() : key;
        return normalizedKey;
    }

    public ServerEvent getEvent() {
        return this.event;
    }
}

