/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.GroupID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.IndexQueryResultSerializer;
import com.tc.object.msg.SearchResponseMessage;
import com.tc.object.session.SessionID;
import com.tc.search.SearchRequestID;
import com.terracottatech.search.IndexQueryResult;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchResultsResponseMessageImpl
extends DSOMessageBase
implements SearchResponseMessage {
    private static final byte SEARCH_REQUEST_ID = 0;
    private static final byte GROUP_ID_FROM = 1;
    private static final byte ERROR_MESSAGE = 2;
    private static final byte RESULTS_SIZE = 3;
    private SearchRequestID requestID;
    private GroupID groupIDFrom;
    private List<IndexQueryResult> results;
    private String errorMessage;

    public SearchResultsResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public SearchResultsResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public SearchRequestID getRequestID() {
        return this.requestID;
    }

    @Override
    public GroupID getGroupIDFrom() {
        return this.groupIDFrom;
    }

    @Override
    public void initSearchResponseMessage(SearchRequestID searchRequestID, GroupID groupID, List<IndexQueryResult> res, List<Aggregator> aggregators, boolean anyCriteriaMatched, boolean isGroupBy, long totalCount) {
        this.requestID = searchRequestID;
        this.groupIDFrom = groupID;
        this.results = res;
    }

    @Override
    public void initSearchResponseMessage(SearchRequestID searchRequestID, GroupID groupID, String error) {
        this.requestID = searchRequestID;
        this.groupIDFrom = groupID;
        this.errorMessage = error;
    }

    @Override
    public List<IndexQueryResult> getResults() {
        return this.results;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isError() {
        return this.errorMessage != null;
    }

    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outStream = this.getOutputStream();
        this.putNVPair((byte)0, this.requestID.toLong());
        this.putNVPair((byte)1, this.groupIDFrom.toInt());
        if (this.results != null) {
            this.putNVPair((byte)3, this.results.size());
            IndexQueryResultSerializer writer = IndexQueryResultSerializer.getInstance(false);
            for (IndexQueryResult result : this.results) {
                writer.serialize(result, outStream);
            }
        }
        if (this.errorMessage != null) {
            this.putNVPair((byte)2, this.errorMessage);
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        TCByteBufferInputStream input = this.getInputStream();
        switch (name) {
            case 0: {
                this.requestID = new SearchRequestID(this.getLongValue());
                return true;
            }
            case 1: {
                this.groupIDFrom = new GroupID(this.getIntValue());
                return true;
            }
            case 3: {
                int size = this.getIntValue();
                this.results = new ArrayList<IndexQueryResult>(size);
                IndexQueryResultSerializer reader = IndexQueryResultSerializer.getInstance(false);
                while (size-- > 0) {
                    Object result = reader.deserializeFrom(input);
                    this.results.add((IndexQueryResult)result);
                }
                return true;
            }
            case 2: {
                this.errorMessage = input.readString();
                return true;
            }
        }
        return false;
    }
}

