/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.SearchResultsRequestMessage;
import com.tc.object.session.SessionID;
import com.tc.search.SearchRequestID;
import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.StackOperations;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SearchResultsRequestMessageImpl
extends DSOMessageBase
implements SearchResultsRequestMessage {
    private SearchRequestID requestID;
    private String cacheName;
    private List queryStack;
    private boolean includeKeys;
    private boolean includeValues;
    private Set<String> attributes;
    private List<NVPair> sortAttributes;
    private List<NVPair> aggregators;
    private int maxResults;
    private int startOffset;
    private int resultPageSize;

    public SearchResultsRequestMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public SearchResultsRequestMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getSourceNodeID();
    }

    @Override
    public SearchRequestID getRequestID() {
        return this.requestID;
    }

    @Override
    public int getStart() {
        return this.startOffset;
    }

    @Override
    public int getPageSize() {
        return this.resultPageSize;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void initialize(SearchRequestID searchRequestID, String cacheName, List queryStack, boolean keys, boolean values, Set<String> attributeSet, List<NVPair> sortAttributesMap, List<NVPair> aggregators, int maxResults, int start, int pageSize) {
        this.cacheName = cacheName;
        this.requestID = searchRequestID;
        this.startOffset = start;
        this.resultPageSize = pageSize;
        this.queryStack = queryStack;
        this.includeKeys = keys;
        this.includeValues = values;
        this.attributes = attributeSet;
        this.aggregators = aggregators;
        this.sortAttributes = sortAttributesMap;
        this.maxResults = maxResults;
    }

    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outStream = this.getOutputStream();
        this.putNVPair((byte)0, this.requestID.toLong());
        this.putNVPair((byte)1, this.cacheName);
        this.putNVPair((byte)2, this.includeKeys);
        this.putNVPair((byte)10, this.includeValues);
        this.putNVPair((byte)9, this.maxResults);
        this.putNVPair((byte)14, this.startOffset);
        this.putNVPair((byte)13, this.resultPageSize);
        this.putNVPair((byte)3, this.attributes.size());
        for (String attribute : this.attributes) {
            outStream.writeString(attribute);
        }
        this.putNVPair((byte)5, this.sortAttributes.size());
        for (NVPair sortedAttributes : this.sortAttributes) {
            NVPAIR_SERIALIZER.serialize(sortedAttributes, outStream, NULL_SERIALIZER);
        }
        this.putNVPair((byte)6, this.aggregators.size());
        for (NVPair attributeAggregator : this.aggregators) {
            NVPAIR_SERIALIZER.serialize(attributeAggregator, outStream, NULL_SERIALIZER);
        }
        if (!this.queryStack.isEmpty()) {
            for (String obj : this.queryStack) {
                if (obj instanceof StackOperations) {
                    StackOperations operation = (StackOperations)obj;
                    this.putNVPair((byte)7, operation.name());
                    continue;
                }
                if (obj instanceof NVPair) {
                    AbstractNVPair pair = (AbstractNVPair)obj;
                    this.putNVPair((byte)8, (NVPair)pair, NULL_SERIALIZER);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected object: " + obj));
            }
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        if (this.queryStack == null) {
            this.queryStack = new LinkedList();
        }
        TCByteBufferInputStream inputStream = this.getInputStream();
        switch (name) {
            case 0: {
                this.requestID = new SearchRequestID(this.getLongValue());
                return true;
            }
            case 1: {
                this.cacheName = this.getStringValue();
                return true;
            }
            case 2: {
                this.includeKeys = this.getBooleanValue();
                return true;
            }
            case 10: {
                this.includeValues = this.getBooleanValue();
                return true;
            }
            case 9: {
                this.maxResults = this.getIntValue();
                return true;
            }
            case 14: {
                this.startOffset = this.getIntValue();
                return true;
            }
            case 13: {
                this.resultPageSize = this.getIntValue();
                return true;
            }
            case 3: {
                this.attributes = new HashSet<String>();
                int count = this.getIntValue();
                while (count-- > 0) {
                    String attribute = this.getStringValue();
                    this.attributes.add(attribute);
                }
                return true;
            }
            case 5: {
                this.sortAttributes = new LinkedList<NVPair>();
                int sortCount = this.getIntValue();
                while (sortCount-- > 0) {
                    NVPair pair = NVPAIR_SERIALIZER.deserialize(inputStream, NULL_SERIALIZER);
                    this.sortAttributes.add(pair);
                }
                return true;
            }
            case 6: {
                this.aggregators = new LinkedList<NVPair>();
                int attributeAggregatorCount = this.getIntValue();
                while (attributeAggregatorCount-- > 0) {
                    NVPair pair = NVPAIR_SERIALIZER.deserialize(inputStream, NULL_SERIALIZER);
                    this.aggregators.add(pair);
                }
                return true;
            }
            case 7: {
                StackOperations operation = StackOperations.valueOf((String)this.getStringValue());
                this.queryStack.add(operation);
                return true;
            }
            case 8: {
                NVPair pair = NVPAIR_SERIALIZER.deserialize(inputStream, NULL_SERIALIZER);
                this.queryStack.add(pair);
                return true;
            }
        }
        return false;
    }

    @Override
    public List getQueryStack() {
        return this.queryStack;
    }

    @Override
    public Set<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<NVPair> getSortAttributes() {
        return this.sortAttributes;
    }

    @Override
    public List<NVPair> getAggregators() {
        return this.aggregators;
    }

    @Override
    public boolean includeKeys() {
        return this.includeKeys;
    }

    @Override
    public boolean includeValues() {
        return this.includeValues;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public int getResultPageSize() {
        return this.resultPageSize;
    }
}

