/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.GroupID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.IndexQueryResultSerializer;
import com.tc.object.msg.SearchQueryResponseMessage;
import com.tc.object.session.SessionID;
import com.tc.search.SearchRequestID;
import com.terracottatech.search.IndexQueryResult;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchQueryResponseMessageImpl
extends DSOMessageBase
implements SearchQueryResponseMessage {
    private static final byte SEARCH_REQUEST_ID = 0;
    private static final byte GROUP_ID_FROM = 1;
    private static final byte RESULTS_SIZE = 2;
    private static final byte AGGREGATOR_RESULTS_SIZE = 3;
    private static final byte ERROR_MESSAGE = 4;
    private static final byte ANY_CRITERIA_MATCHED = 5;
    private static final byte TOTAL_RESULT_COUNT = 6;
    private SearchRequestID requestID;
    private GroupID groupIDFrom;
    private List<IndexQueryResult> results;
    private List<Aggregator> aggregators;
    private String errorMessage;
    private boolean anyCriteriaMatched;
    private boolean isQueryGroupBy;
    private long totalResultCount;

    public SearchQueryResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public SearchQueryResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void initSearchResponseMessage(SearchRequestID searchRequestID, GroupID groupID, List<IndexQueryResult> searchResults, List<Aggregator> aggregatorList, boolean criteriaMatched, boolean isGroupBy, long totalResCount) {
        this.requestID = searchRequestID;
        this.groupIDFrom = groupID;
        this.results = searchResults;
        this.aggregators = aggregatorList;
        this.anyCriteriaMatched = criteriaMatched;
        this.isQueryGroupBy = isGroupBy;
        this.totalResultCount = totalResCount;
    }

    @Override
    public void initSearchResponseMessage(SearchRequestID searchRequestID, GroupID groupID, String errMsg) {
        this.requestID = searchRequestID;
        this.groupIDFrom = groupID;
        this.errorMessage = errMsg;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isError() {
        return this.errorMessage != null;
    }

    @Override
    public boolean isAnyCriteriaMatched() {
        return this.anyCriteriaMatched;
    }

    @Override
    public boolean isQueryGroupBy() {
        return this.isQueryGroupBy;
    }

    @Override
    public SearchRequestID getRequestID() {
        return this.requestID;
    }

    @Override
    public GroupID getGroupIDFrom() {
        return this.groupIDFrom;
    }

    @Override
    public List<IndexQueryResult> getResults() {
        return this.results;
    }

    @Override
    public List<Aggregator> getAggregators() {
        return this.aggregators;
    }

    @Override
    public long getTotalResultCount() {
        return this.totalResultCount;
    }

    @Override
    protected void dehydrateValues() {
        TCByteBufferOutputStream outStream = this.getOutputStream();
        this.putNVPair((byte)0, this.requestID.toLong());
        this.putNVPair((byte)1, this.groupIDFrom.toInt());
        this.putNVPair((byte)6, this.totalResultCount);
        if (this.results != null) {
            this.putNVPair((byte)2, this.results.size());
            outStream.writeBoolean(this.isQueryGroupBy);
            IndexQueryResultSerializer writer = IndexQueryResultSerializer.getInstance(this.isQueryGroupBy);
            for (IndexQueryResult result : this.results) {
                writer.serialize(result, outStream);
            }
        }
        if (this.aggregators != null) {
            this.putNVPair((byte)3, this.aggregators.size());
            for (Aggregator result : this.aggregators) {
                try {
                    result.serializeTo((DataOutput)outStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.errorMessage != null) {
            this.putNVPair((byte)4, this.errorMessage);
        }
        this.putNVPair((byte)5, this.anyCriteriaMatched);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        TCByteBufferInputStream input = this.getInputStream();
        switch (name) {
            case 0: {
                this.requestID = new SearchRequestID(this.getLongValue());
                return true;
            }
            case 1: {
                this.groupIDFrom = new GroupID(this.getIntValue());
                return true;
            }
            case 6: {
                this.totalResultCount = this.getLongValue();
                return true;
            }
            case 2: {
                int size = this.getIntValue();
                this.results = new ArrayList<IndexQueryResult>(size);
                this.isQueryGroupBy = this.getBooleanValue();
                IndexQueryResultSerializer reader = IndexQueryResultSerializer.getInstance(this.isQueryGroupBy);
                while (size-- > 0) {
                    Object result = reader.deserializeFrom(input);
                    this.results.add((IndexQueryResult)result);
                }
                return true;
            }
            case 3: {
                int aggregatorSize = this.getIntValue();
                this.aggregators = new ArrayList<Aggregator>(aggregatorSize);
                while (aggregatorSize-- > 0) {
                    Aggregator aggregator = AbstractAggregator.deserializeInstance((DataInput)input);
                    this.aggregators.add(aggregator);
                }
                return true;
            }
            case 4: {
                this.errorMessage = input.readString();
                return true;
            }
            case 5: {
                this.anyCriteriaMatched = input.readBoolean();
                return true;
            }
        }
        return false;
    }
}

